/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.System2;
import org.sonarsource.sonarlint.core.plugin.commons.container.ClassDerivedBeanDefinition;
import org.sonarsource.sonarlint.core.plugin.commons.container.ComponentKeys;
import org.sonarsource.sonarlint.core.plugin.commons.container.Container;
import org.sonarsource.sonarlint.core.plugin.commons.container.LazyUnlessStartableStrategy;
import org.sonarsource.sonarlint.core.plugin.commons.container.PriorityBeanFactory;
import org.sonarsource.sonarlint.core.plugin.commons.container.SpringInitStrategy;
import org.sonarsource.sonarlint.core.plugin.commons.container.StartableBeanPostProcessor;
import org.sonarsource.sonarlint.core.plugin.commons.container.StartableContainer;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringComponentContainer
implements StartableContainer {
    protected final AnnotationConfigApplicationContext context;
    @Nullable
    protected final SpringComponentContainer parent;
    protected final List<SpringComponentContainer> children = new ArrayList<SpringComponentContainer>();
    private final PropertyDefinitions propertyDefinitions;
    private final ComponentKeys componentKeys = new ComponentKeys();

    public SpringComponentContainer() {
        this(null, new PropertyDefinitions(System2.INSTANCE, new Object[0]), Collections.emptyList(), new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(List<?> externalExtensions) {
        this(null, new PropertyDefinitions(System2.INSTANCE, new Object[0]), externalExtensions, new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(SpringComponentContainer parent) {
        this(parent, parent.propertyDefinitions, Collections.emptyList(), new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(SpringComponentContainer parent, SpringInitStrategy initStrategy) {
        this(parent, parent.propertyDefinitions, Collections.emptyList(), initStrategy);
    }

    protected SpringComponentContainer(@Nullable SpringComponentContainer parent, PropertyDefinitions propertyDefs, List<?> externalExtensions, SpringInitStrategy initStrategy) {
        this.parent = parent;
        this.propertyDefinitions = propertyDefs;
        this.context = new AnnotationConfigApplicationContext(new PriorityBeanFactory());
        this.context.setAllowBeanDefinitionOverriding(false);
        ((AbstractAutowireCapableBeanFactory)((Object)this.context.getBeanFactory())).setParameterNameDiscoverer(null);
        if (parent != null) {
            this.context.setParent(parent.context);
            parent.children.add(this);
        }
        this.add(initStrategy);
        this.add(this);
        this.add(new StartableBeanPostProcessor());
        this.add(externalExtensions);
        this.add(propertyDefs);
    }

    @Override
    public Container add(Object ... objects) {
        for (Object o : objects) {
            if (o instanceof Class) {
                Class clazz = (Class)o;
                this.context.registerBean(this.componentKeys.ofClass(clazz), clazz, new BeanDefinitionCustomizer[0]);
                this.declareProperties(o);
                continue;
            }
            if (o instanceof Iterable) {
                ((Iterable)o).forEach(xva$0 -> this.add(xva$0));
                continue;
            }
            this.registerInstance(o);
            this.declareProperties(o);
        }
        return this;
    }

    private <T> void registerInstance(T instance) {
        Supplier<Object> supplier = () -> instance;
        Class<?> clazz = instance.getClass();
        this.context.registerBean(this.componentKeys.ofInstance(instance), clazz, supplier, new BeanDefinitionCustomizer[0]);
    }

    private Container addExtension(Object o) {
        if (o instanceof Class) {
            Class clazz = (Class)o;
            ClassDerivedBeanDefinition bd = new ClassDerivedBeanDefinition(clazz);
            this.context.registerBeanDefinition(this.componentKeys.ofClass(clazz), bd);
        } else if (o instanceof Iterable) {
            ((Iterable)o).forEach(this::addExtension);
        } else {
            this.registerInstance(o);
        }
        return this;
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        try {
            return this.context.getBean(type);
        }
        catch (Exception t) {
            throw new IllegalStateException("Unable to load component " + type, t);
        }
    }

    @Override
    public <T> Optional<T> getOptionalComponentByType(Class<T> type) {
        try {
            return Optional.of(this.context.getBean(type));
        }
        catch (NoSuchBeanDefinitionException t) {
            return Optional.empty();
        }
    }

    @Override
    public <T> List<T> getComponentsByType(Class<T> type) {
        try {
            return new ArrayList<T>(this.context.getBeansOfType(type).values());
        }
        catch (Exception t) {
            throw new IllegalStateException("Unable to load components " + type, t);
        }
    }

    public AnnotationConfigApplicationContext context() {
        return this.context;
    }

    public void execute() {
        RuntimeException r = null;
        try {
            this.startComponents();
        }
        catch (RuntimeException e) {
            r = e;
        }
        finally {
            block13: {
                try {
                    this.stopComponents();
                }
                catch (RuntimeException e) {
                    if (r != null) break block13;
                    r = e;
                }
            }
        }
        if (r != null) {
            throw r;
        }
    }

    @Override
    public SpringComponentContainer startComponents() {
        this.doBeforeStart();
        this.context.refresh();
        this.doAfterStart();
        return this;
    }

    public SpringComponentContainer stopComponents() {
        try {
            this.stopChildren();
            if (this.context.isActive()) {
                this.context.close();
            }
        }
        finally {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
        }
        return this;
    }

    private void stopChildren() {
        ArrayList<SpringComponentContainer> childrenCopy = new ArrayList<SpringComponentContainer>(this.children);
        Collections.reverse(childrenCopy);
        childrenCopy.forEach(SpringComponentContainer::stopComponents);
    }

    public SpringComponentContainer createChild() {
        return new SpringComponentContainer(this);
    }

    @Override
    @CheckForNull
    public SpringComponentContainer getParent() {
        return this.parent;
    }

    @Override
    public SpringComponentContainer addExtension(@Nullable String pluginKey, Object extension) {
        try {
            this.addExtension(extension);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to register extension " + SpringComponentContainer.getName(extension) + (String)(pluginKey != null ? " from plugin '" + pluginKey + "'" : ""), t);
        }
        this.declareProperties(extension);
        return this;
    }

    private static String getName(Object extension) {
        if (extension instanceof Class) {
            return ((Class)extension).getName();
        }
        return SpringComponentContainer.getName(extension.getClass());
    }

    @Override
    public SpringComponentContainer declareProperties(Object extension) {
        this.propertyDefinitions.addComponent(extension, "");
        return this;
    }

    public AnnotationConfigApplicationContext getSpringContext() {
        return this.context;
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }
}

