/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.markdown.Markdown;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.rule.extractor.LegacyHotspotRuleDescriptionSectionsGenerator;
import org.sonarsource.sonarlint.core.rule.extractor.SecurityStandards;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDescriptionSection;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamDefinition;

public class SonarLintRuleDefinition {
    private final String key;
    private final String name;
    private final IssueSeverity defaultSeverity;
    private final RuleType type;
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<org.sonarsource.sonarlint.core.commons.SoftwareQuality, ImpactSeverity> defaultImpacts;
    private final String description;
    private final List<SonarLintRuleDescriptionSection> descriptionSections;
    private final Map<String, SonarLintRuleParamDefinition> params;
    private final Map<String, String> defaultParams = new HashMap<String, String>();
    private final boolean isActiveByDefault;
    private final Language language;
    private final String[] tags;
    private final Set<String> deprecatedKeys;
    private final Set<String> educationPrincipleKeys;
    private final Optional<String> internalKey;
    private final Optional<VulnerabilityProbability> vulnerabilityProbability;

    public SonarLintRuleDefinition(RulesDefinition.Rule rule) {
        String htmlDescription;
        this.key = RuleKey.of(rule.repository().key(), rule.key()).toString();
        this.name = rule.name();
        this.defaultSeverity = IssueSeverity.valueOf(rule.severity());
        this.type = RuleType.valueOf(rule.type().name());
        this.cleanCodeAttribute = Optional.ofNullable(rule.cleanCodeAttribute()).map(Enum::name).map(CleanCodeAttribute::valueOf).orElse(CleanCodeAttribute.defaultCleanCodeAttribute());
        this.defaultImpacts = rule.defaultImpacts().entrySet().stream().map(e -> Map.entry(org.sonarsource.sonarlint.core.commons.SoftwareQuality.valueOf(((SoftwareQuality)((Object)((Object)e.getKey()))).name()), ImpactSeverity.valueOf(((Severity)((Object)((Object)e.getValue()))).name()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String string = htmlDescription = rule.htmlDescription() != null ? rule.htmlDescription() : Markdown.convertToHtml(rule.markdownDescription());
        if (rule.type() == org.sonar.api.rules.RuleType.SECURITY_HOTSPOT) {
            this.description = null;
            this.descriptionSections = LegacyHotspotRuleDescriptionSectionsGenerator.extractDescriptionSectionsFromHtml(htmlDescription);
        } else {
            this.description = htmlDescription;
            this.descriptionSections = rule.ruleDescriptionSections().stream().map(s -> new SonarLintRuleDescriptionSection(s.getKey(), s.getHtmlContent(), s.getContext().map(c -> new SonarLintRuleDescriptionSection.Context(c.getKey(), c.getDisplayName())))).collect(Collectors.toList());
        }
        this.isActiveByDefault = rule.activatedByDefault();
        this.language = Language.forKey(rule.repository().language()).orElseThrow(() -> new IllegalStateException("Unknown language with key: " + rule.repository().language()));
        this.tags = rule.tags().toArray(new String[0]);
        this.deprecatedKeys = rule.deprecatedRuleKeys().stream().map(RuleKey::toString).collect(Collectors.toSet());
        this.educationPrincipleKeys = rule.educationPrincipleKeys();
        this.vulnerabilityProbability = rule.type() == org.sonar.api.rules.RuleType.SECURITY_HOTSPOT ? Optional.of(SecurityStandards.fromSecurityStandards(rule.securityStandards()).getSlCategory().getVulnerability()) : Optional.empty();
        HashMap<String, SonarLintRuleParamDefinition> builder = new HashMap<String, SonarLintRuleParamDefinition>();
        for (RulesDefinition.Param param : rule.params()) {
            SonarLintRuleParamDefinition paramDefinition = new SonarLintRuleParamDefinition(param);
            builder.put(param.key(), paramDefinition);
            String defaultValue = paramDefinition.defaultValue();
            if (defaultValue == null) continue;
            this.defaultParams.put(param.key(), defaultValue);
        }
        this.params = Collections.unmodifiableMap(builder);
        this.internalKey = Optional.ofNullable(rule.internalKey());
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public IssueSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public RuleType getType() {
        return this.type;
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    public Map<org.sonarsource.sonarlint.core.commons.SoftwareQuality, ImpactSeverity> getDefaultImpacts() {
        return this.defaultImpacts;
    }

    public Map<String, SonarLintRuleParamDefinition> getParams() {
        return this.params;
    }

    public Map<String, String> getDefaultParams() {
        return this.defaultParams;
    }

    public boolean isActiveByDefault() {
        return this.isActiveByDefault;
    }

    public String getHtmlDescription() {
        return this.description;
    }

    public List<SonarLintRuleDescriptionSection> getDescriptionSections() {
        return this.descriptionSections;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String[] getTags() {
        return this.tags;
    }

    public Set<String> getDeprecatedKeys() {
        return this.deprecatedKeys;
    }

    public Set<String> getEducationPrincipleKeys() {
        return this.educationPrincipleKeys;
    }

    public Optional<String> getInternalKey() {
        return this.internalKey;
    }

    public Optional<VulnerabilityProbability> getVulnerabilityProbability() {
        return this.vulnerabilityProbability;
    }
}

