/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.StandaloneRuleConfigDto;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamDefinition;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerRule;

public class RuleDetails {
    public static final String DEFAULT_SECTION = "default";
    private final String key;
    private final Language language;
    private final String name;
    private final String htmlDescription;
    private final Map<String, List<DescriptionSection>> descriptionSectionsByKey;
    private final IssueSeverity defaultSeverity;
    private final RuleType type;
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<SoftwareQuality, ImpactSeverity> defaultImpacts;
    private final Collection<EffectiveRuleParam> params;
    private final String extendedDescription;
    private final Set<String> educationPrincipleKeys;

    public static RuleDetails from(SonarLintRuleDefinition ruleDefinition, @Nullable StandaloneRuleConfigDto ruleConfig) {
        return new RuleDetails(ruleDefinition.getKey(), ruleDefinition.getLanguage(), ruleDefinition.getName(), ruleDefinition.getHtmlDescription(), ruleDefinition.getDescriptionSections().stream().map(s -> new DescriptionSection(s.getKey(), s.getHtmlContent(), s.getContext().map(c -> new DescriptionSection.Context(c.getKey(), c.getDisplayName())))).collect(Collectors.groupingBy(DescriptionSection::getKey)), ruleDefinition.getDefaultSeverity(), ruleDefinition.getType(), ruleDefinition.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute()), ruleDefinition.getDefaultImpacts(), null, RuleDetails.transformParams(ruleDefinition.getParams(), ruleConfig != null ? ruleConfig.getParamValueByKey() : Map.of()), ruleDefinition.getEducationPrincipleKeys());
    }

    @NotNull
    private static List<EffectiveRuleParam> transformParams(Map<String, SonarLintRuleParamDefinition> ruleDefinitionParams, Map<String, String> ruleConfigParams) {
        return ruleDefinitionParams.values().stream().map(p -> new EffectiveRuleParam(p.name(), p.description(), ruleConfigParams.getOrDefault(p.key(), p.defaultValue()), p.defaultValue())).collect(Collectors.toList());
    }

    public static RuleDetails merging(ServerActiveRule activeRuleFromStorage, ServerRule serverRule) {
        return new RuleDetails(activeRuleFromStorage.getRuleKey(), serverRule.getLanguage(), serverRule.getName(), serverRule.getHtmlDesc(), serverRule.getDescriptionSections().stream().map(s -> new DescriptionSection(s.getKey(), s.getHtmlContent(), s.getContext().map(c -> new DescriptionSection.Context(c.getKey(), c.getDisplayName())))).collect(Collectors.groupingBy(DescriptionSection::getKey)), Optional.ofNullable(activeRuleFromStorage.getSeverity()).orElse(serverRule.getSeverity()), serverRule.getType(), null, Map.of(), serverRule.getHtmlNote(), Collections.emptyList(), serverRule.getEducationPrincipleKeys());
    }

    public static RuleDetails merging(ServerRule activeRuleFromServer, SonarLintRuleDefinition ruleDefFromPlugin, boolean skipCleanCodeTaxonomy) {
        CleanCodeAttribute cleanCodeAttribute = skipCleanCodeTaxonomy ? null : ruleDefFromPlugin.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute());
        Map<SoftwareQuality, ImpactSeverity> defaultImpacts = skipCleanCodeTaxonomy ? Map.of() : ruleDefFromPlugin.getDefaultImpacts();
        return new RuleDetails(ruleDefFromPlugin.getKey(), ruleDefFromPlugin.getLanguage(), ruleDefFromPlugin.getName(), ruleDefFromPlugin.getHtmlDescription(), ruleDefFromPlugin.getDescriptionSections().stream().map(s -> new DescriptionSection(s.getKey(), s.getHtmlContent(), s.getContext().map(c -> new DescriptionSection.Context(c.getKey(), c.getDisplayName())))).collect(Collectors.groupingBy(DescriptionSection::getKey)), Optional.ofNullable(activeRuleFromServer.getSeverity()).orElse(ruleDefFromPlugin.getDefaultSeverity()), ruleDefFromPlugin.getType(), cleanCodeAttribute, defaultImpacts, activeRuleFromServer.getHtmlNote(), Collections.emptyList(), ruleDefFromPlugin.getEducationPrincipleKeys());
    }

    public static RuleDetails merging(ServerActiveRule activeRuleFromStorage, ServerRule serverRule, SonarLintRuleDefinition templateRuleDefFromPlugin, boolean skipCleanCodeTaxonomy) {
        CleanCodeAttribute cleanCodeAttribute = skipCleanCodeTaxonomy ? null : templateRuleDefFromPlugin.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute());
        Map<SoftwareQuality, ImpactSeverity> defaultImpacts = skipCleanCodeTaxonomy ? Map.of() : templateRuleDefFromPlugin.getDefaultImpacts();
        return new RuleDetails(activeRuleFromStorage.getRuleKey(), templateRuleDefFromPlugin.getLanguage(), serverRule.getName(), serverRule.getHtmlDesc(), serverRule.getDescriptionSections().stream().map(s -> new DescriptionSection(s.getKey(), s.getHtmlContent(), s.getContext().map(c -> new DescriptionSection.Context(c.getKey(), c.getDisplayName())))).collect(Collectors.groupingBy(DescriptionSection::getKey)), serverRule.getSeverity(), templateRuleDefFromPlugin.getType(), cleanCodeAttribute, defaultImpacts, serverRule.getHtmlNote(), Collections.emptyList(), templateRuleDefFromPlugin.getEducationPrincipleKeys());
    }

    public RuleDetails(String key, Language language, String name, String htmlDescription, Map<String, List<DescriptionSection>> descriptionSectionsByKey, IssueSeverity defaultSeverity, RuleType type, @Nullable CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> defaultImpacts, @Nullable String extendedDescription, Collection<EffectiveRuleParam> params, Set<String> educationPrincipleKeys) {
        this.key = key;
        this.language = language;
        this.name = name;
        this.htmlDescription = htmlDescription;
        this.descriptionSectionsByKey = descriptionSectionsByKey;
        this.defaultSeverity = defaultSeverity;
        this.type = type;
        this.cleanCodeAttribute = cleanCodeAttribute;
        this.defaultImpacts = defaultImpacts;
        this.params = params;
        this.extendedDescription = extendedDescription;
        this.educationPrincipleKeys = educationPrincipleKeys;
    }

    public String getKey() {
        return this.key;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }

    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public boolean hasMonolithicDescription() {
        return this.descriptionSectionsByKey.isEmpty() || this.hasOnlyDefaultSection();
    }

    private boolean hasOnlyDefaultSection() {
        return this.descriptionSectionsByKey.size() == 1 && this.descriptionSectionsByKey.containsKey(DEFAULT_SECTION);
    }

    public Map<String, List<DescriptionSection>> getDescriptionSectionsByKey() {
        return this.descriptionSectionsByKey;
    }

    public IssueSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public RuleType getType() {
        return this.type;
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    public Map<SoftwareQuality, ImpactSeverity> getDefaultImpacts() {
        return this.defaultImpacts;
    }

    public Collection<EffectiveRuleParam> getParams() {
        return this.params;
    }

    public Set<String> getCleanCodePrincipleKeys() {
        return this.educationPrincipleKeys;
    }

    @CheckForNull
    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public static class DescriptionSection {
        private final String key;
        private final String htmlContent;
        private final Optional<Context> context;

        public DescriptionSection(String key, String htmlContent, Optional<Context> context) {
            this.key = key;
            this.htmlContent = htmlContent;
            this.context = context;
        }

        public String getKey() {
            return this.key;
        }

        public String getHtmlContent() {
            return this.htmlContent;
        }

        public Optional<Context> getContext() {
            return this.context;
        }

        public static class Context {
            private final String key;
            private final String displayName;

            public Context(String key, String displayName) {
                this.key = key;
                this.displayName = displayName;
            }

            public String getKey() {
                return this.key;
            }

            public String getDisplayName() {
                return this.displayName;
            }
        }
    }

    public static class EffectiveRuleParam {
        private final String name;
        private final String description;
        @Nullable
        private final String value;
        @Nullable
        private final String defaultValue;

        public EffectiveRuleParam(String name, String description, @Nullable String value, @Nullable String defaultValue) {
            this.name = name;
            this.description = description;
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @CheckForNull
        public String getValue() {
            return this.value;
        }

        @CheckForNull
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

