/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.issue;

import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonarsource.sonarlint.core.commons.IssueStatus;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.LineWithHash;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssue;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssueResolution;
import org.sonarsource.sonarlint.core.commons.Transition;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.exception.UnexpectedBodyException;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Issues;
import org.sonarsource.sonarlint.core.serverapi.source.SourceApi;
import org.sonarsource.sonarlint.core.serverapi.util.ProtobufUtil;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class IssueApi {
    public static final Version MIN_SQ_VERSION_SUPPORTING_PULL = Version.create("9.6");
    private static final Map<IssueStatus, Transition> transitionByStatus = Map.of(IssueStatus.ACCEPT, Transition.ACCEPT, IssueStatus.WONT_FIX, Transition.WONT_FIX, IssueStatus.FALSE_POSITIVE, Transition.FALSE_POSITIVE);
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String ORGANIZATION_PARAM = "&organization=";
    private final ServerApiHelper serverApiHelper;

    public IssueApi(ServerApiHelper serverApiHelper) {
        this.serverApiHelper = serverApiHelper;
    }

    public static boolean supportIssuePull(boolean isSonarCloud, Version serverVersion) {
        return !isSonarCloud && serverVersion.compareToIgnoreQualifier(MIN_SQ_VERSION_SUPPORTING_PULL) >= 0;
    }

    public DownloadIssuesResult downloadVulnerabilitiesForRules(String key, Set<String> ruleKeys, @Nullable String branchName, ProgressMonitor progress) {
        StringBuilder searchUrl = new StringBuilder();
        searchUrl.append(IssueApi.getVulnerabilitiesUrl(key, ruleKeys));
        searchUrl.append(IssueApi.getUrlBranchParameter(branchName));
        this.serverApiHelper.getOrganizationKey().ifPresent(org -> searchUrl.append(ORGANIZATION_PARAM).append(UrlUtils.urlEncode(org)));
        ArrayList<Issues.Issue> result = new ArrayList<Issues.Issue>();
        HashMap<String, String> componentsPathByKey = new HashMap<String, String>();
        this.serverApiHelper.getPaginated(searchUrl.toString(), Issues.SearchWsResponse::parseFrom, r -> r.getPaging().getTotal(), r -> {
            componentsPathByKey.clear();
            componentsPathByKey.putAll(r.getComponentsList().stream().filter(Issues.Component::hasPath).collect(Collectors.toMap(Issues.Component::getKey, Issues.Component::getPath)));
            return r.getIssuesList();
        }, result::add, true, progress);
        return new DownloadIssuesResult(result, componentsPathByKey);
    }

    private static String getVulnerabilitiesUrl(String key, Set<String> ruleKeys) {
        return "/api/issues/search.protobuf?statuses=OPEN,CONFIRMED,REOPENED,RESOLVED&types=VULNERABILITY&componentKeys=" + UrlUtils.urlEncode(key) + "&rules=" + UrlUtils.urlEncode(String.join((CharSequence)",", ruleKeys));
    }

    private static String getUrlBranchParameter(@Nullable String branchName) {
        if (branchName != null) {
            return "&branch=" + UrlUtils.urlEncode(branchName);
        }
        return "";
    }

    public List<ScannerInput.ServerIssue> downloadAllFromBatchIssues(String key, @Nullable String branchName) {
        String batchIssueUrl = IssueApi.getBatchIssuesUrl(key) + IssueApi.getUrlBranchParameter(branchName);
        return ServerApiHelper.processTimed(() -> this.serverApiHelper.rawGet(batchIssueUrl), response -> {
            if (response.code() == 403 || response.code() == 404) {
                return Collections.emptyList();
            }
            if (response.code() != 200) {
                throw ServerApiHelper.handleError(response);
            }
            InputStream input = response.bodyAsStream();
            Parser<ScannerInput.ServerIssue> parser = ScannerInput.ServerIssue.parser();
            return ProtobufUtil.readMessages(input, parser);
        }, duration -> LOG.debug("Downloaded issues in {}ms", (Object)duration));
    }

    private static String getBatchIssuesUrl(String key) {
        return "/batch/issues?key=" + UrlUtils.urlEncode(key);
    }

    private static String getPullIssuesUrl(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        String enabledLanguageKeys = enabledLanguages.stream().map(Language::getLanguageKey).collect(Collectors.joining(","));
        StringBuilder url = new StringBuilder().append("/api/issues/pull?projectKey=").append(UrlUtils.urlEncode(projectKey)).append("&branchName=").append(UrlUtils.urlEncode(branchName));
        if (!enabledLanguageKeys.isEmpty()) {
            url.append("&languages=").append(enabledLanguageKeys);
        }
        if (changedSince != null) {
            url.append("&changedSince=").append(changedSince);
        }
        return url.toString();
    }

    public IssuesPullResult pullIssues(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        return ServerApiHelper.processTimed(() -> this.serverApiHelper.get(IssueApi.getPullIssuesUrl(projectKey, branchName, enabledLanguages, changedSince)), response -> {
            InputStream input = response.bodyAsStream();
            Issues.IssuesPullQueryTimestamp timestamp = Issues.IssuesPullQueryTimestamp.parseDelimitedFrom(input);
            return new IssuesPullResult(timestamp, ProtobufUtil.readMessages(input, Issues.IssueLite.parser()));
        }, duration -> LOG.debug("Pulled issues in {}ms", (Object)duration));
    }

    private static String getPullTaintIssuesUrl(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        String enabledLanguageKeys = enabledLanguages.stream().map(Language::getLanguageKey).collect(Collectors.joining(","));
        StringBuilder url = new StringBuilder().append("/api/issues/pull_taint?projectKey=").append(UrlUtils.urlEncode(projectKey)).append("&branchName=").append(UrlUtils.urlEncode(branchName));
        if (!enabledLanguageKeys.isEmpty()) {
            url.append("&languages=").append(enabledLanguageKeys);
        }
        if (changedSince != null) {
            url.append("&changedSince=").append(changedSince);
        }
        return url.toString();
    }

    public TaintIssuesPullResult pullTaintIssues(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        return ServerApiHelper.processTimed(() -> this.serverApiHelper.get(IssueApi.getPullTaintIssuesUrl(projectKey, branchName, enabledLanguages, changedSince)), response -> {
            InputStream input = response.bodyAsStream();
            Issues.TaintVulnerabilityPullQueryTimestamp timestamp = Issues.TaintVulnerabilityPullQueryTimestamp.parseDelimitedFrom(input);
            return new TaintIssuesPullResult(timestamp, ProtobufUtil.readMessages(input, Issues.TaintVulnerabilityLite.parser()));
        }, duration -> LOG.debug("Pulled taint issues in {}ms", (Object)duration));
    }

    public CompletableFuture<Void> changeStatusAsync(String issueKey, Transition transition) {
        String body = "issue=" + UrlUtils.urlEncode(issueKey) + "&transition=" + UrlUtils.urlEncode(transition.getStatus());
        return this.serverApiHelper.postAsync("/api/issues/do_transition", "application/x-www-form-urlencoded", body).thenAccept(response -> {});
    }

    public CompletableFuture<Void> addComment(String issueKey, String text) {
        String body = "issue=" + UrlUtils.urlEncode(issueKey) + "&text=" + UrlUtils.urlEncode(text);
        return this.serverApiHelper.postAsync("/api/issues/add_comment", "application/x-www-form-urlencoded", body).thenAccept(response -> {});
    }

    public CompletableFuture<Issues.Issue> searchByKey(String issueKey) {
        StringBuilder searchUrl = new StringBuilder();
        searchUrl.append("/api/issues/search.protobuf?issues=").append(UrlUtils.urlEncode(issueKey)).append("&additionalFields=transitions");
        this.serverApiHelper.getOrganizationKey().ifPresent(org -> searchUrl.append(ORGANIZATION_PARAM).append(UrlUtils.urlEncode(org)));
        searchUrl.append("&ps=1&p=1");
        return this.serverApiHelper.getAsync(searchUrl.toString()).thenApply(rawResponse -> {
            Issues.Issue issue;
            block9: {
                InputStream body = rawResponse.bodyAsStream();
                try {
                    Issues.SearchWsResponse wsResponse = Issues.SearchWsResponse.parseFrom(body);
                    if (wsResponse.getIssuesList().isEmpty()) {
                        throw new UnexpectedBodyException("No issue found with key '" + issueKey + "'");
                    }
                    issue = wsResponse.getIssuesList().get(0);
                    if (body == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (body != null) {
                            try {
                                body.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error("Error when searching issue + '" + issueKey + "'", e);
                        throw new UnexpectedBodyException(e);
                    }
                }
                body.close();
            }
            return issue;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<ServerIssueDetails> fetchServerIssue(String issueKey, String projectKey, String branch, @Nullable String pullRequest) {
        Object searchUrl = "/api/issues/search.protobuf?issues=" + UrlUtils.urlEncode(issueKey) + "&componentKeys=" + projectKey + "&ps=1&p=1";
        if (pullRequest != null && !pullRequest.isEmpty()) {
            searchUrl = ((String)searchUrl).concat("&pullRequest=").concat(UrlUtils.urlEncode(pullRequest));
        } else if (!branch.isEmpty()) {
            searchUrl = ((String)searchUrl).concat("&branch=").concat(UrlUtils.urlEncode(branch));
        }
        try (HttpClient.Response wsResponse = this.serverApiHelper.get((String)searchUrl);){
            Optional<ServerIssueDetails> optional;
            block25: {
                Optional<Issues.Component> optionalComponentWithPath;
                Issues.Issue issue;
                Issues.SearchWsResponse response;
                InputStream is;
                block23: {
                    Optional<ServerIssueDetails> optional2;
                    block24: {
                        block21: {
                            Optional<ServerIssueDetails> optional3;
                            block22: {
                                is = wsResponse.bodyAsStream();
                                try {
                                    response = Issues.SearchWsResponse.parseFrom(is);
                                    if (!response.getIssuesList().isEmpty() && !response.getComponentsList().isEmpty()) break block21;
                                    LOG.warn("No issue found with key '" + issueKey + "'");
                                    optional3 = Optional.empty();
                                    if (is == null) break block22;
                                }
                                catch (Throwable throwable) {
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                is.close();
                            }
                            return optional3;
                        }
                        issue = response.getIssuesList().get(0);
                        optionalComponentWithPath = response.getComponentsList().stream().filter(component -> component.getKey().equals(issue.getComponent())).findFirst();
                        if (!optionalComponentWithPath.isEmpty()) break block23;
                        LOG.warn("No path found in components for the issue with key '" + issueKey + "'");
                        optional2 = Optional.empty();
                        if (is == null) break block24;
                        is.close();
                    }
                    return optional2;
                }
                String fileKey = issue.getComponent();
                Optional<String> codeSnippet = this.getCodeSnippet(fileKey, issue.getTextRange(), branch, pullRequest);
                optional = Optional.of(new ServerIssueDetails(issue, optionalComponentWithPath.get().getPath(), response.getComponentsList(), codeSnippet.orElse("")));
                if (is == null) break block25;
                is.close();
            }
            return optional;
        }
        catch (Exception e) {
            LOG.warn("Error while fetching issue", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<String> getCodeSnippet(String fileKey, Common.TextRange textRange, String branch, @Nullable String pullRequest) {
        Optional<String> source = new SourceApi(this.serverApiHelper).getRawSourceCodeForBranchAndPullRequest(fileKey, branch, pullRequest);
        if (source.isPresent()) {
            try {
                String codeSnippet = ServerApiUtils.extractCodeSnippet(source.get(), textRange);
                return Optional.of(codeSnippet);
            }
            catch (Exception e) {
                LOG.debug("Unable to compute code snippet of '" + fileKey + "' for text range: " + textRange, (Object)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public CompletableFuture<Void> anticipatedTransitions(String projectKey, List<LocalOnlyIssue> resolvedLocalOnlyIssues) {
        return this.serverApiHelper.postAsync("/api/issues/anticipated_transitions?projectKey=" + projectKey, "application/json; charset=utf-8", new Gson().toJson(IssueApi.adapt(resolvedLocalOnlyIssues))).thenAccept(response -> {});
    }

    private static List<IssueAnticipatedTransition> adapt(List<LocalOnlyIssue> resolvedLocalOnlyIssues) {
        return resolvedLocalOnlyIssues.stream().map(IssueApi::adapt).collect(Collectors.toList());
    }

    private static IssueAnticipatedTransition adapt(LocalOnlyIssue issue) {
        Integer lineNumber = null;
        String lineHash = null;
        LineWithHash lineWithHash = issue.getLineWithHash();
        if (lineWithHash != null) {
            lineNumber = lineWithHash.getNumber();
            lineHash = lineWithHash.getHash();
        }
        LocalOnlyIssueResolution resolution = Objects.requireNonNull(issue.getResolution());
        return new IssueAnticipatedTransition(issue.getServerRelativePath(), lineNumber, lineHash, issue.getRuleKey(), issue.getMessage(), transitionByStatus.get((Object)resolution.getStatus()).getStatus(), resolution.getComment());
    }

    private static class IssueAnticipatedTransition {
        public final String filePath;
        public final Integer line;
        public final String hash;
        public final String ruleKey;
        public final String issueMessage;
        public final String transition;
        public final String comment;

        private IssueAnticipatedTransition(String filePath, @Nullable Integer line, @Nullable String hash, String ruleKey, String issueMessage, String transition, @Nullable String comment) {
            this.filePath = filePath;
            this.line = line;
            this.hash = hash;
            this.ruleKey = ruleKey;
            this.issueMessage = issueMessage;
            this.transition = transition;
            this.comment = comment;
        }
    }

    public static class ServerIssueDetails {
        public final String key;
        public final String ruleKey;
        public final String codeSnippet;
        public final String creationDate;
        public final String message;
        public final String path;
        public final Common.TextRange textRange;
        public final List<Common.Flow> flowList;
        public final List<Issues.Component> componentsList;

        public ServerIssueDetails(Issues.Issue issue, String path, List<Issues.Component> componentsList, String codeSnippet) {
            this.key = issue.getKey();
            this.ruleKey = issue.getRule();
            this.textRange = issue.getTextRange();
            this.path = path;
            this.flowList = issue.getFlowsList();
            this.message = issue.getMessage();
            this.creationDate = issue.getCreationDate();
            this.componentsList = componentsList;
            this.codeSnippet = codeSnippet;
        }
    }

    public static class TaintIssuesPullResult {
        private final Issues.TaintVulnerabilityPullQueryTimestamp timestamp;
        private final List<Issues.TaintVulnerabilityLite> issues;

        public TaintIssuesPullResult(Issues.TaintVulnerabilityPullQueryTimestamp timestamp, List<Issues.TaintVulnerabilityLite> issues) {
            this.timestamp = timestamp;
            this.issues = issues;
        }

        public Issues.TaintVulnerabilityPullQueryTimestamp getTimestamp() {
            return this.timestamp;
        }

        public List<Issues.TaintVulnerabilityLite> getTaintIssues() {
            return this.issues;
        }
    }

    public static class IssuesPullResult {
        private final Issues.IssuesPullQueryTimestamp timestamp;
        private final List<Issues.IssueLite> issues;

        public IssuesPullResult(Issues.IssuesPullQueryTimestamp timestamp, List<Issues.IssueLite> issues) {
            this.timestamp = timestamp;
            this.issues = issues;
        }

        public Issues.IssuesPullQueryTimestamp getTimestamp() {
            return this.timestamp;
        }

        public List<Issues.IssueLite> getIssues() {
            return this.issues;
        }
    }

    public static class DownloadIssuesResult {
        private final List<Issues.Issue> issues;
        private final Map<String, String> componentPathsByKey;

        private DownloadIssuesResult(List<Issues.Issue> issues, Map<String, String> componentPathsByKey) {
            this.issues = issues;
            this.componentPathsByKey = componentPathsByKey;
        }

        public List<Issues.Issue> getIssues() {
            return this.issues;
        }

        public Map<String, String> getComponentPathsByKey() {
            return this.componentPathsByKey;
        }
    }
}

