/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.stream;

import java.util.List;
import org.sonarsource.sonarlint.core.serverapi.stream.Event;

public class EventParser {
    private static final String EVENT_TYPE_PREFIX = "event: ";
    private static final String DATA_PREFIX = "data: ";

    static Event parse(String eventPayload) {
        List<String> fields = List.of(eventPayload.split("\\n"));
        String type = "";
        StringBuilder data = new StringBuilder();
        for (String field : fields) {
            if (field.startsWith(EVENT_TYPE_PREFIX)) {
                type = field.substring(EVENT_TYPE_PREFIX.length());
                continue;
            }
            if (!field.startsWith(DATA_PREFIX)) continue;
            data.append(field.substring(DATA_PREFIX.length()));
        }
        return new Event(type, data.toString());
    }

    private EventParser() {
    }
}

