/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.SonarProjectStorage;
import org.sonarsource.sonarlint.core.serverconnection.storage.PluginsStorage;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectStoragePaths;
import org.sonarsource.sonarlint.core.serverconnection.storage.ServerInfoStorage;
import org.sonarsource.sonarlint.core.serverconnection.storage.ServerIssueStoresManager;

public class ConnectionStorage {
    private final ServerIssueStoresManager serverIssueStoresManager;
    private final ServerInfoStorage serverInfoStorage;
    private final Map<String, SonarProjectStorage> sonarProjectStorageByKey = new ConcurrentHashMap<String, SonarProjectStorage>();
    private final Path projectsStorageRoot;
    private final PluginsStorage pluginsStorage;
    private final Path connectionStorageRoot;

    public ConnectionStorage(Path globalStorageRoot, Path workDir, String connectionId) {
        this.connectionStorageRoot = globalStorageRoot.resolve(ProjectStoragePaths.encodeForFs(connectionId));
        this.projectsStorageRoot = this.connectionStorageRoot.resolve("projects");
        this.serverIssueStoresManager = new ServerIssueStoresManager(this.projectsStorageRoot, workDir);
        this.serverInfoStorage = new ServerInfoStorage(this.connectionStorageRoot);
        this.pluginsStorage = new PluginsStorage(this.connectionStorageRoot);
    }

    public ServerInfoStorage serverInfo() {
        return this.serverInfoStorage;
    }

    public SonarProjectStorage project(String sonarProjectKey) {
        return this.sonarProjectStorageByKey.computeIfAbsent(sonarProjectKey, k -> new SonarProjectStorage(this.projectsStorageRoot, this.serverIssueStoresManager, sonarProjectKey));
    }

    public PluginsStorage plugins() {
        return this.pluginsStorage;
    }

    public void close() {
        this.serverIssueStoresManager.close();
    }

    public void delete() {
        FileUtils.deleteRecursively(this.connectionStorageRoot);
    }
}

