/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FilenameUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class IssueStorePaths {
    private IssueStorePaths() {
    }

    @CheckForNull
    public static String idePathToFileKey(ProjectBinding projectBinding, String ideFilePath) {
        String serverFilePath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (serverFilePath == null) {
            return null;
        }
        return IssueStorePaths.componentKey(projectBinding, serverFilePath);
    }

    public static String componentKey(ProjectBinding projectBinding, String serverFilePath) {
        return IssueStorePaths.componentKey(projectBinding.projectKey(), serverFilePath);
    }

    public static String componentKey(String projectKey, String serverFilePath) {
        return projectKey + ":" + serverFilePath;
    }

    @CheckForNull
    public static String idePathToServerPath(ProjectBinding projectBinding, String ideFilePathStr) {
        Path commonPart;
        Path ideFilePath = Paths.get(ideFilePathStr, new String[0]);
        if (StringUtils.isNotEmpty(projectBinding.idePathPrefix())) {
            Path idePathPrefix = Paths.get(projectBinding.idePathPrefix(), new String[0]);
            if (!ideFilePath.startsWith(idePathPrefix)) {
                return null;
            }
            commonPart = idePathPrefix.relativize(ideFilePath);
        } else {
            commonPart = ideFilePath;
        }
        if (StringUtils.isNotEmpty(projectBinding.serverPathPrefix())) {
            Path serverPathPrefix = Paths.get(projectBinding.serverPathPrefix(), new String[0]);
            return FilenameUtils.separatorsToUnix(serverPathPrefix.resolve(commonPart).toString());
        }
        return FilenameUtils.separatorsToUnix(commonPart.toString());
    }
}

