/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.PluginsMinVersions;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.plugins.ServerPlugin;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.StoredPlugin;
import org.sonarsource.sonarlint.core.serverconnection.VersionUtils;

public class PluginsSynchronizer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Set<String> sonarSourceDisabledPluginKeys;
    private final ConnectionStorage storage;
    private final PluginsMinVersions pluginsMinVersions = new PluginsMinVersions();
    private Set<String> embeddedPluginKeys;
    private static final String OLD_SONARTS_PLUGIN_KEY = "typescript";

    public PluginsSynchronizer(Set<Language> enabledLanguages, ConnectionStorage storage, Set<String> embeddedPluginKeys) {
        this.sonarSourceDisabledPluginKeys = PluginsSynchronizer.getSonarSourceDisabledPluginKeys(enabledLanguages);
        this.storage = storage;
        this.embeddedPluginKeys = embeddedPluginKeys;
    }

    public boolean synchronize(ServerApi serverApi, ProgressMonitor progressMonitor, boolean supportsCustomSecrets) {
        if (supportsCustomSecrets) {
            HashSet<String> embeddedPluginKeysCopy = new HashSet<String>(this.embeddedPluginKeys);
            embeddedPluginKeysCopy.remove(Language.SECRETS.getPluginKey());
            this.embeddedPluginKeys = embeddedPluginKeysCopy;
        }
        Map<String, StoredPlugin> storedPluginsByKey = this.storage.plugins().getStoredPluginsByKey();
        List<ServerPlugin> serverPlugins = serverApi.plugins().getInstalled();
        List<ServerPlugin> pluginsToDownload = serverPlugins.stream().filter(p -> this.shouldDownload((ServerPlugin)p, storedPluginsByKey)).collect(Collectors.toList());
        this.downloadAll(serverApi, pluginsToDownload, progressMonitor);
        return !pluginsToDownload.isEmpty();
    }

    private void downloadAll(ServerApi serverApi, List<ServerPlugin> pluginsToDownload, ProgressMonitor progressMonitor) {
        int i = 0;
        for (ServerPlugin p : pluginsToDownload) {
            progressMonitor.setProgressAndCheckCancel("Downloading analyzer '" + p.getKey() + "'", (float)i++ / (float)pluginsToDownload.size());
            this.downloadPlugin(serverApi, p);
        }
    }

    private void downloadPlugin(ServerApi serverApi, ServerPlugin plugin) {
        LOG.info("[SYNC] Downloading plugin '{}'", (Object)plugin.getFilename());
        serverApi.plugins().getPlugin(plugin.getKey(), pluginBinary -> this.storage.plugins().store(plugin, (InputStream)pluginBinary));
    }

    private boolean shouldDownload(ServerPlugin serverPlugin, Map<String, StoredPlugin> storedPluginsByKey) {
        if (this.embeddedPluginKeys.contains(serverPlugin.getKey())) {
            LOG.debug("[SYNC] Code analyzer '{}' is embedded in SonarLint. Skip downloading it.", (Object)serverPlugin.getKey());
            return false;
        }
        if (PluginsSynchronizer.upToDate(serverPlugin, storedPluginsByKey)) {
            LOG.debug("[SYNC] Code analyzer '{}' is up-to-date. Skip downloading it.", (Object)serverPlugin.getKey());
            return false;
        }
        if (!serverPlugin.isSonarLintSupported()) {
            LOG.debug("[SYNC] Code analyzer '{}' does not support SonarLint. Skip downloading it.", (Object)serverPlugin.getKey());
            return false;
        }
        if (this.sonarSourceDisabledPluginKeys.contains(serverPlugin.getKey())) {
            LOG.debug("[SYNC] Code analyzer '{}' is disabled in SonarLint (language not enabled). Skip downloading it.", (Object)serverPlugin.getKey());
            return false;
        }
        String pluginVersion = VersionUtils.getJarVersion(serverPlugin.getFilename());
        if (!this.pluginsMinVersions.isVersionSupported(serverPlugin.getKey(), pluginVersion)) {
            String minimumVersion = this.pluginsMinVersions.getMinimumVersion(serverPlugin.getKey());
            LOG.debug("[SYNC] Code analyzer '{}' version '{}' is not supported (minimal version is '{}'). Skip downloading it.", serverPlugin.getKey(), pluginVersion, minimumVersion);
            return false;
        }
        return true;
    }

    private static boolean upToDate(ServerPlugin serverPlugin, Map<String, StoredPlugin> storedPluginsByKey) {
        return storedPluginsByKey.containsKey(serverPlugin.getKey()) && storedPluginsByKey.get(serverPlugin.getKey()).hasSameHash(serverPlugin);
    }

    private static Set<String> getSonarSourceDisabledPluginKeys(Set<Language> enabledLanguages) {
        Map<String, List<Language>> languagesByPluginKey = Arrays.stream(Language.values()).collect(Collectors.groupingBy(Language::getPluginKey));
        Set<String> disabledPluginKeys = languagesByPluginKey.entrySet().stream().filter(e -> Collections.disjoint(enabledLanguages, (Collection)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!enabledLanguages.contains((Object)Language.TS)) {
            disabledPluginKeys.add(OLD_SONARTS_PLUGIN_KEY);
        }
        return disabledPluginKeys;
    }
}

