/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.issue.IssueApi;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.DownloadException;
import org.sonarsource.sonarlint.core.serverconnection.IssueDownloader;
import org.sonarsource.sonarlint.core.serverconnection.IssueStorePaths;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.serverconnection.ServerUpdaterUtils;
import org.sonarsource.sonarlint.core.serverconnection.TaintIssueDownloader;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectServerIssueStore;

public class ServerIssueUpdater {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConnectionStorage storage;
    private final IssueDownloader issueDownloader;
    private final TaintIssueDownloader taintIssueDownloader;

    public ServerIssueUpdater(ConnectionStorage storage, IssueDownloader issueDownloader, TaintIssueDownloader taintIssueDownloader) {
        this.storage = storage;
        this.issueDownloader = issueDownloader;
        this.taintIssueDownloader = taintIssueDownloader;
    }

    public void update(ServerApi serverApi, String projectKey, String branchName, boolean isSonarCloud, Version serverVersion) {
        if (IssueApi.supportIssuePull(isSonarCloud, serverVersion)) {
            this.sync(serverApi, projectKey, branchName, this.issueDownloader.getEnabledLanguages());
        } else {
            List<ServerIssue> issues = this.issueDownloader.downloadFromBatch(serverApi, projectKey, branchName);
            this.storage.project(projectKey).findings().replaceAllIssuesOfBranch(branchName, issues);
        }
    }

    public void sync(ServerApi serverApi, String projectKey, String branchName, Set<Language> enabledLanguages) {
        Optional<Instant> lastSync = this.storage.project(projectKey).findings().getLastIssueSyncTimestamp(branchName);
        lastSync = ServerUpdaterUtils.computeLastSync(enabledLanguages, lastSync, this.storage.project(projectKey).findings().getLastIssueEnabledLanguages(branchName));
        IssueDownloader.PullResult result = this.issueDownloader.downloadFromPull(serverApi, projectKey, branchName, lastSync);
        this.storage.project(projectKey).findings().mergeIssues(branchName, result.getChangedIssues(), result.getClosedIssueKeys(), result.getQueryTimestamp(), enabledLanguages);
    }

    public void syncTaints(ServerApi serverApi, String projectKey, String branchName, Set<Language> enabledLanguages) {
        ProjectServerIssueStore serverIssueStore = this.storage.project(projectKey).findings();
        Optional<Instant> lastSync = serverIssueStore.getLastTaintSyncTimestamp(branchName);
        lastSync = ServerUpdaterUtils.computeLastSync(enabledLanguages, lastSync, this.storage.project(projectKey).findings().getLastTaintEnabledLanguages(branchName));
        TaintIssueDownloader.PullTaintResult result = this.taintIssueDownloader.downloadTaintFromPull(serverApi, projectKey, branchName, lastSync);
        serverIssueStore.mergeTaintIssues(branchName, result.getChangedTaintIssues(), result.getClosedIssueKeys(), result.getQueryTimestamp(), enabledLanguages);
    }

    public void updateFileIssues(ServerApi serverApi, ProjectBinding projectBinding, String ideFilePath, String branchName, boolean isSonarCloud, Version serverVersion) {
        String serverFilePath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (serverFilePath == null) {
            return;
        }
        this.updateFileIssues(serverApi, projectBinding.projectKey(), serverFilePath, branchName, isSonarCloud, serverVersion);
    }

    public void updateFileIssues(ServerApi serverApi, String projectKey, String serverFileRelativePath, String branchName, boolean isSonarCloud, Version serverVersion) {
        String fileKey = IssueStorePaths.componentKey(projectKey, serverFileRelativePath);
        if (!IssueApi.supportIssuePull(isSonarCloud, serverVersion)) {
            ArrayList<ServerIssue> issues = new ArrayList<ServerIssue>();
            try {
                issues.addAll(this.issueDownloader.downloadFromBatch(serverApi, fileKey, branchName));
            }
            catch (Exception e) {
                throw new DownloadException("Failed to update file issues: " + e.getMessage(), null);
            }
            this.storage.project(projectKey).findings().replaceAllIssuesOfFile(branchName, serverFileRelativePath, issues);
        } else {
            LOG.debug("Skip downloading file issues on SonarQube " + IssueApi.MIN_SQ_VERSION_SUPPORTING_PULL + "+");
        }
    }

    public void updateFileTaints(ServerApi serverApi, ProjectBinding projectBinding, String ideFilePath, String branchName, boolean isSonarCloud, Version serverVersion, ProgressMonitor progress) {
        String serverFilePath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (serverFilePath == null) {
            return;
        }
        String fileKey = IssueStorePaths.componentKey(projectBinding, serverFilePath);
        if (!IssueApi.supportIssuePull(isSonarCloud, serverVersion)) {
            ArrayList<ServerTaintIssue> taintIssues = new ArrayList<ServerTaintIssue>();
            try {
                taintIssues.addAll(this.taintIssueDownloader.downloadTaintFromIssueSearch(serverApi, fileKey, branchName, progress));
            }
            catch (Exception e) {
                throw new DownloadException("Failed to update file taint vulnerabilities: " + e.getMessage(), null);
            }
            this.storage.project(projectBinding.projectKey()).findings().replaceAllTaintOfFile(branchName, serverFilePath, taintIssues);
        } else {
            LOG.debug("Skip downloading file taint issues on SonarQube " + IssueApi.MIN_SQ_VERSION_SUPPORTING_PULL + "+");
        }
    }
}

