/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.issue.IssueApi;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Issues;
import org.sonarsource.sonarlint.core.serverapi.source.SourceApi;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;
import org.sonarsource.sonarlint.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class TaintIssueDownloader {
    private static final Pattern MATCH_ALL_WHITESPACES = Pattern.compile("\\s");
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Set<Language> enabledLanguages;

    public TaintIssueDownloader(Set<Language> enabledLanguages) {
        this.enabledLanguages = enabledLanguages;
    }

    public List<ServerTaintIssue> downloadTaintFromIssueSearch(ServerApi serverApi, String key, @Nullable String branchName, ProgressMonitor progress) {
        IssueApi issueApi = serverApi.issue();
        ArrayList<ServerTaintIssue> result = new ArrayList<ServerTaintIssue>();
        Set<String> taintRuleKeys = serverApi.rules().getAllTaintRules(List.of(Language.values()), progress);
        HashMap sourceCodeByKey = new HashMap();
        IssueApi.DownloadIssuesResult downloadVulnerabilitiesForRules = issueApi.downloadVulnerabilitiesForRules(key, taintRuleKeys, branchName, progress);
        downloadVulnerabilitiesForRules.getIssues().stream().map(i -> TaintIssueDownloader.convertTaintVulnerability(serverApi.source(), i, downloadVulnerabilitiesForRules.getComponentPathsByKey(), sourceCodeByKey)).filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    public PullTaintResult downloadTaintFromPull(ServerApi serverApi, String projectKey, String branchName, Optional<Instant> lastSync) {
        IssueApi issueApi = serverApi.issue();
        IssueApi.TaintIssuesPullResult apiResult = issueApi.pullTaintIssues(projectKey, branchName, this.enabledLanguages, lastSync.map(Instant::toEpochMilli).orElse(null));
        List<ServerTaintIssue> changedIssues = apiResult.getTaintIssues().stream().filter(i -> i.getMainLocation().hasFilePath()).filter(Predicate.not(Issues.TaintVulnerabilityLite::getClosed)).map(TaintIssueDownloader::convertLiteTaintIssue).collect(Collectors.toList());
        Set<String> closedIssueKeys = apiResult.getTaintIssues().stream().filter(i -> i.getMainLocation().hasFilePath()).filter(Issues.TaintVulnerabilityLite::getClosed).map(Issues.TaintVulnerabilityLite::getKey).collect(Collectors.toSet());
        return new PullTaintResult(Instant.ofEpochMilli(apiResult.getTimestamp().getQueryTimestamp()), changedIssues, closedIssueKeys);
    }

    @CheckForNull
    private static ServerTaintIssue convertTaintVulnerability(SourceApi sourceApi, Issues.Issue taintVulnerabilityFromWs, Map<String, String> componentsByKey, Map<String, String> sourceCodeByKey) {
        RuleKey ruleKey = RuleKey.parse(taintVulnerabilityFromWs.getRule());
        ServerTaintIssue.ServerIssueLocation primaryLocation = TaintIssueDownloader.convertPrimaryLocation(sourceApi, taintVulnerabilityFromWs, componentsByKey, sourceCodeByKey);
        String filePath = primaryLocation.getFilePath();
        if (filePath == null) {
            return null;
        }
        String ruleDescriptionContextKey = taintVulnerabilityFromWs.hasRuleDescriptionContextKey() ? taintVulnerabilityFromWs.getRuleDescriptionContextKey() : null;
        CleanCodeAttribute cleanCodeAttribute = TaintIssueDownloader.parseProtoCleanCodeAttribute(taintVulnerabilityFromWs);
        Map<SoftwareQuality, ImpactSeverity> impacts = taintVulnerabilityFromWs.getImpactsList().stream().map(i -> Map.entry(TaintIssueDownloader.parseProtoSoftwareQuality(i), TaintIssueDownloader.parseProtoImpactSeverity(i))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ServerTaintIssue(taintVulnerabilityFromWs.getKey(), !taintVulnerabilityFromWs.getResolution().isEmpty(), ruleKey.toString(), primaryLocation.getMessage(), filePath, ServerApiUtils.parseOffsetDateTime(taintVulnerabilityFromWs.getCreationDate()).toInstant(), IssueSeverity.valueOf(taintVulnerabilityFromWs.getSeverity().name()), RuleType.valueOf(taintVulnerabilityFromWs.getType().name()), primaryLocation.getTextRange(), ruleDescriptionContextKey, cleanCodeAttribute, impacts).setFlows(TaintIssueDownloader.convertFlows(sourceApi, taintVulnerabilityFromWs.getFlowsList(), componentsByKey, sourceCodeByKey));
    }

    @CheckForNull
    @VisibleForTesting
    static CleanCodeAttribute parseProtoCleanCodeAttribute(Issues.Issue taintVulnerabilityFromWs) {
        if (!taintVulnerabilityFromWs.hasCleanCodeAttribute() || taintVulnerabilityFromWs.getCleanCodeAttribute() == Common.CleanCodeAttribute.UNKNOWN_ATTRIBUTE) {
            return null;
        }
        return CleanCodeAttribute.valueOf(taintVulnerabilityFromWs.getCleanCodeAttribute().name());
    }

    @CheckForNull
    @VisibleForTesting
    static CleanCodeAttribute parseProtoCleanCodeAttribute(Issues.TaintVulnerabilityLite taintVulnerabilityFromWs) {
        if (!taintVulnerabilityFromWs.hasCleanCodeAttribute() || taintVulnerabilityFromWs.getCleanCodeAttribute() == Common.CleanCodeAttribute.UNKNOWN_ATTRIBUTE) {
            return null;
        }
        return CleanCodeAttribute.valueOf(taintVulnerabilityFromWs.getCleanCodeAttribute().name());
    }

    @VisibleForTesting
    static SoftwareQuality parseProtoSoftwareQuality(Common.Impact protoImpact) {
        if (!protoImpact.hasSoftwareQuality() || protoImpact.getSoftwareQuality() == Common.SoftwareQuality.UNKNOWN_IMPACT_QUALITY) {
            throw new IllegalArgumentException("Unknown or missing software quality");
        }
        return SoftwareQuality.valueOf(protoImpact.getSoftwareQuality().name());
    }

    @VisibleForTesting
    static ImpactSeverity parseProtoImpactSeverity(Common.Impact protoImpact) {
        if (!protoImpact.hasSeverity() || protoImpact.getSeverity() == Common.ImpactSeverity.UNKNOWN_IMPACT_SEVERITY) {
            throw new IllegalArgumentException("Unknown or missing impact severity");
        }
        return ImpactSeverity.valueOf(protoImpact.getSeverity().name());
    }

    private static List<ServerTaintIssue.Flow> convertFlows(SourceApi sourceApi, List<Common.Flow> flowsList, Map<String, String> componentPathsByKey, Map<String, String> sourceCodeByKey) {
        return flowsList.stream().map(flowFromWs -> new ServerTaintIssue.Flow(flowFromWs.getLocationsList().stream().map(locationFromWs -> {
            String componentPath = (String)componentPathsByKey.get(locationFromWs.getComponent());
            if (locationFromWs.hasTextRange()) {
                String codeSnippet = TaintIssueDownloader.getCodeSnippet(sourceApi, locationFromWs.getComponent(), locationFromWs.getTextRange(), sourceCodeByKey);
                String textRangeHash = codeSnippet != null ? TaintIssueDownloader.hash(codeSnippet) : "";
                return new ServerTaintIssue.ServerIssueLocation(componentPath, TaintIssueDownloader.convertTextRangeFromWs(locationFromWs.getTextRange(), textRangeHash), locationFromWs.getMsg());
            }
            return new ServerTaintIssue.ServerIssueLocation(componentPath, null, locationFromWs.getMsg());
        }).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private static TextRangeWithHash toServerTaintIssueTextRange(Issues.TextRange textRange) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset(), textRange.getHash());
    }

    private static ServerTaintIssue convertLiteTaintIssue(Issues.TaintVulnerabilityLite liteTaintIssueFromWs) {
        Issues.Location mainLocation = liteTaintIssueFromWs.getMainLocation();
        String filePath = mainLocation.getFilePath();
        Instant creationDate = Instant.ofEpochMilli(liteTaintIssueFromWs.getCreationDate());
        IssueSeverity severity = IssueSeverity.valueOf(liteTaintIssueFromWs.getSeverity().name());
        RuleType type = RuleType.valueOf(liteTaintIssueFromWs.getType().name());
        String ruleDescriptionContextKey = liteTaintIssueFromWs.hasRuleDescriptionContextKey() ? liteTaintIssueFromWs.getRuleDescriptionContextKey() : null;
        CleanCodeAttribute cleanCodeAttribute = TaintIssueDownloader.parseProtoCleanCodeAttribute(liteTaintIssueFromWs);
        Map<SoftwareQuality, ImpactSeverity> impacts = liteTaintIssueFromWs.getImpactsList().stream().map(i -> Map.entry(TaintIssueDownloader.parseProtoSoftwareQuality(i), TaintIssueDownloader.parseProtoImpactSeverity(i))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ServerTaintIssue taintIssue = mainLocation.hasTextRange() ? new ServerTaintIssue(liteTaintIssueFromWs.getKey(), liteTaintIssueFromWs.getResolved(), liteTaintIssueFromWs.getRuleKey(), mainLocation.getMessage(), filePath, creationDate, severity, type, TaintIssueDownloader.toServerTaintIssueTextRange(mainLocation.getTextRange()), ruleDescriptionContextKey, cleanCodeAttribute, impacts) : new ServerTaintIssue(liteTaintIssueFromWs.getKey(), liteTaintIssueFromWs.getResolved(), liteTaintIssueFromWs.getRuleKey(), mainLocation.getMessage(), filePath, creationDate, severity, type, null, ruleDescriptionContextKey, cleanCodeAttribute, impacts);
        taintIssue.setFlows(liteTaintIssueFromWs.getFlowsList().stream().map(TaintIssueDownloader::convertFlows).collect(Collectors.toList()));
        return taintIssue;
    }

    private static ServerTaintIssue.Flow convertFlows(Issues.Flow flowFromWs) {
        return new ServerTaintIssue.Flow(flowFromWs.getLocationsList().stream().map(locationFromWs -> {
            String filePath;
            String string = filePath = locationFromWs.hasFilePath() ? locationFromWs.getFilePath() : null;
            if (locationFromWs.hasTextRange()) {
                return new ServerTaintIssue.ServerIssueLocation(filePath, TaintIssueDownloader.toServerTaintIssueTextRange(locationFromWs.getTextRange()), locationFromWs.getMessage());
            }
            return new ServerTaintIssue.ServerIssueLocation(filePath, null, locationFromWs.getMessage());
        }).collect(Collectors.toList()));
    }

    private static ServerTaintIssue.ServerIssueLocation convertPrimaryLocation(SourceApi sourceApi, Issues.Issue issueFromWs, Map<String, String> componentPathsByKey, Map<String, String> sourceCodeByKey) {
        String componentPath = componentPathsByKey.get(issueFromWs.getComponent());
        if (issueFromWs.hasTextRange()) {
            String codeSnippet = TaintIssueDownloader.getCodeSnippet(sourceApi, issueFromWs.getComponent(), issueFromWs.getTextRange(), sourceCodeByKey);
            String textRangeHash = codeSnippet != null ? TaintIssueDownloader.hash(codeSnippet) : "";
            return new ServerTaintIssue.ServerIssueLocation(componentPath, TaintIssueDownloader.convertTextRangeFromWs(issueFromWs.getTextRange(), textRangeHash), issueFromWs.getMessage());
        }
        return new ServerTaintIssue.ServerIssueLocation(componentPath, null, issueFromWs.getMessage());
    }

    static String hash(String codeSnippet) {
        String codeSnippetWithoutWhitespaces = MATCH_ALL_WHITESPACES.matcher(codeSnippet).replaceAll("");
        return DigestUtils.md5Hex(codeSnippetWithoutWhitespaces);
    }

    private static TextRangeWithHash convertTextRangeFromWs(Common.TextRange textRange, String hash) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartOffset(), textRange.getEndLine(), textRange.getEndOffset(), hash);
    }

    @CheckForNull
    private static String getCodeSnippet(SourceApi sourceApi, String fileKey, Common.TextRange textRange, Map<String, String> sourceCodeByKey) {
        String sourceCode = TaintIssueDownloader.getOrFetchSourceCode(sourceApi, fileKey, sourceCodeByKey);
        if (StringUtils.isEmpty(sourceCode)) {
            return null;
        }
        try {
            return ServerApiUtils.extractCodeSnippet(sourceCode, textRange);
        }
        catch (Exception e) {
            LOG.debug("Unable to compute code snippet of '" + fileKey + "' for text range: " + textRange, (Object)e);
            return null;
        }
    }

    private static String getOrFetchSourceCode(SourceApi sourceApi, String fileKey, Map<String, String> sourceCodeByKey) {
        return sourceCodeByKey.computeIfAbsent(fileKey, k -> sourceApi.getRawSourceCode(fileKey).orElse(""));
    }

    public static class PullTaintResult {
        private final Instant queryTimestamp;
        private final List<ServerTaintIssue> changedIssues;
        private final Set<String> closedIssueKeys;

        public PullTaintResult(Instant queryTimestamp, List<ServerTaintIssue> changedIssues, Set<String> closedIssueKeys) {
            this.queryTimestamp = queryTimestamp;
            this.changedIssues = changedIssues;
            this.closedIssueKeys = closedIssueKeys;
        }

        public Instant getQueryTimestamp() {
            return this.queryTimestamp;
        }

        public List<ServerTaintIssue> getChangedTaintIssues() {
            return this.changedIssues;
        }

        public Set<String> getClosedIssueKeys() {
            return this.closedIssueKeys;
        }
    }
}

