/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.issues;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerFinding;

public class ServerTaintIssue
implements ServerFinding {
    private String key;
    private boolean resolved;
    private String ruleKey;
    private String message;
    private String filePath;
    private Instant creationDate;
    private IssueSeverity severity;
    private RuleType type;
    private List<Flow> flows = new ArrayList<Flow>();
    private TextRangeWithHash textRange;
    @Nullable
    private final String ruleDescriptionContextKey;
    @Nullable
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<SoftwareQuality, ImpactSeverity> impacts;
    private boolean isOnNewCode;

    public ServerTaintIssue(String key, boolean resolved, String ruleKey, String message, String filePath, Instant creationDate, IssueSeverity severity, RuleType type, @Nullable TextRangeWithHash textRange, @Nullable String ruleDescriptionContextKey, @Nullable CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> impacts) {
        this.key = key;
        this.resolved = resolved;
        this.ruleKey = ruleKey;
        this.message = message;
        this.filePath = filePath;
        this.creationDate = creationDate;
        this.severity = severity;
        this.type = type;
        this.textRange = textRange;
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
        this.cleanCodeAttribute = cleanCodeAttribute;
        this.impacts = impacts;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public String getRuleKey() {
        return this.ruleKey;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Instant getCreationDate() {
        return this.creationDate;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public RuleType getType() {
        return this.type;
    }

    @CheckForNull
    public TextRangeWithHash getTextRange() {
        return this.textRange;
    }

    @CheckForNull
    public String getRuleDescriptionContextKey() {
        return this.ruleDescriptionContextKey;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    public Map<SoftwareQuality, ImpactSeverity> getImpacts() {
        return this.impacts;
    }

    public ServerTaintIssue setKey(String key) {
        this.key = key;
        return this;
    }

    public ServerTaintIssue setResolved(boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    public ServerTaintIssue setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public ServerTaintIssue setMessage(String message) {
        this.message = message;
        return this;
    }

    public ServerTaintIssue setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public ServerTaintIssue setCreationDate(Instant creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public ServerTaintIssue setSeverity(IssueSeverity severity) {
        this.severity = severity;
        return this;
    }

    public ServerTaintIssue setType(RuleType type) {
        this.type = type;
        return this;
    }

    public ServerTaintIssue setTextRange(@Nullable TextRangeWithHash textRange) {
        this.textRange = textRange;
        return this;
    }

    public ServerTaintIssue setFlows(List<Flow> flows) {
        this.flows = flows;
        return this;
    }

    public void setIsOnNewCode(boolean isOnNewCode) {
        this.isOnNewCode = isOnNewCode;
    }

    public boolean isOnNewCode() {
        return this.isOnNewCode;
    }

    public static class ServerIssueLocation {
        private final String message;
        private final String filePath;
        private final TextRangeWithHash textRange;

        public ServerIssueLocation(@Nullable String filePath, @Nullable TextRangeWithHash textRange, @Nullable String message) {
            this.textRange = textRange;
            this.filePath = filePath;
            this.message = message;
        }

        @CheckForNull
        public String getFilePath() {
            return this.filePath;
        }

        public String getMessage() {
            return this.message;
        }

        @CheckForNull
        public TextRangeWithHash getTextRange() {
            return this.textRange;
        }
    }

    public static class Flow {
        private final List<ServerIssueLocation> locations;

        public Flow(List<ServerIssueLocation> locations) {
            this.locations = locations;
        }

        public List<ServerIssueLocation> locations() {
            return this.locations;
        }
    }
}

