/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.time.LocalDate;
import org.sonarsource.sonarlint.shaded.com.google.gson.TypeAdapter;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonReader;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonWriter;

public class LocalDateAdapter
extends TypeAdapter<LocalDate> {
    @Override
    public void write(JsonWriter jsonWriter, LocalDate localDate) throws IOException {
        jsonWriter.beginObject().name("year").value(localDate.getYear()).name("month").value(localDate.getMonthValue()).name("day").value(localDate.getDayOfMonth()).endObject();
    }

    @Override
    public LocalDate read(JsonReader jsonReader) throws IOException {
        int year = 0;
        int month = 0;
        int day = 0;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "year": {
                    year = jsonReader.nextInt();
                    break;
                }
                case "month": {
                    month = jsonReader.nextInt();
                    break;
                }
                case "day": {
                    day = jsonReader.nextInt();
                    break;
                }
            }
        }
        jsonReader.endObject();
        return LocalDate.of(year, month, day);
    }
}

