/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonarsource.sonarlint.core.commons.SonarLintUserHome;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.telemetry.InternalDebug;

public class TelemetryPathManager {
    private static final SonarLintLogger LOG = SonarLintLogger.get();

    private TelemetryPathManager() {
    }

    public static Path getPath(String productKey) {
        return TelemetryPathManager.getPath(SonarLintUserHome.get(), productKey);
    }

    public static Path getPath(Path sonarlintUserHome, String productKey) {
        return sonarlintUserHome.resolve("telemetry").resolve(productKey).resolve("usage");
    }

    public static void migrate(String productKey, Path oldPath) {
        Path newPath = TelemetryPathManager.getPath(productKey);
        TelemetryPathManager.migrate(oldPath, newPath);
    }

    public static void migrate(Path oldPath, Path newPath) {
        block4: {
            if (newPath.toFile().isFile() || !oldPath.toFile().exists()) {
                return;
            }
            try {
                if (!newPath.getParent().toFile().exists()) {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(oldPath, newPath, new CopyOption[0]);
            }
            catch (IOException e) {
                if (!InternalDebug.isEnabled()) break block4;
                LOG.error("Failed to migrate telemetry storage", e);
            }
        }
    }
}

