/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.websocket;

import com.google.common.util.concurrent.MoreExecutors;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.http.WebSocketClient;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.IssueChangedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotChangedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotClosedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotRaisedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.TaintVulnerabilityClosedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.TaintVulnerabilityRaisedEventParser;
import org.sonarsource.sonarlint.core.websocket.History;
import org.sonarsource.sonarlint.core.websocket.WebSocketEventSubscribePayload;
import org.sonarsource.sonarlint.core.websocket.parsing.SmartNotificationEventParser;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonObject;

public class SonarCloudWebSocket {
    private static final Map<String, EventParser<?>> parsersByTypeForProjectFilter = Map.of("QualityGateChanged", new SmartNotificationEventParser("QUALITY_GATE"), "IssueChanged", new IssueChangedEventParser(), "SecurityHotspotClosed", new SecurityHotspotClosedEventParser(), "SecurityHotspotRaised", new SecurityHotspotRaisedEventParser(), "SecurityHotspotChanged", new SecurityHotspotChangedEventParser(), "TaintVulnerabilityClosed", new TaintVulnerabilityClosedEventParser(), "TaintVulnerabilityRaised", new TaintVulnerabilityRaisedEventParser());
    private static final Map<String, EventParser<?>> parsersByTypeForProjectUserFilter = Map.of("MyNewIssues", new SmartNotificationEventParser("NEW_ISSUES"));
    private static final Map<String, EventParser<?>> parsersByType = Stream.of(parsersByTypeForProjectFilter, parsersByTypeForProjectUserFilter).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final String PROJECT_FILTER_TYPE = "PROJECT";
    private static final String PROJECT_USER_FILTER_TYPE = "PROJECT_USER";
    private static final Gson gson = new Gson();
    private final History history = new History();
    private final ScheduledExecutorService sonarCloudWebSocketScheduler = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sonarcloud-websocket-scheduled-jobs"));
    private WebSocket ws;

    public static String getUrl() {
        return System.getProperty("sonarlint.internal.sonarcloud.websocket.url", "wss://events-api.sonarcloud.io/");
    }

    public static SonarCloudWebSocket create(WebSocketClient webSocketClient, Consumer<ServerEvent> serverEventConsumer, Runnable connectionEndedRunnable) {
        SonarCloudWebSocket webSocket = new SonarCloudWebSocket();
        webSocket.ws = webSocketClient.createWebSocketConnection(SonarCloudWebSocket.getUrl(), rawEvent -> webSocket.handleRawMessage((String)rawEvent, serverEventConsumer), connectionEndedRunnable);
        webSocket.sonarCloudWebSocketScheduler.scheduleAtFixedRate(webSocket::cleanUpMessageHistory, 0L, 5L, TimeUnit.MINUTES);
        webSocket.sonarCloudWebSocketScheduler.schedule(connectionEndedRunnable, 119L, TimeUnit.MINUTES);
        webSocket.sonarCloudWebSocketScheduler.scheduleAtFixedRate(webSocket::keepAlive, 9L, 9L, TimeUnit.MINUTES);
        return webSocket;
    }

    private void keepAlive() {
        this.ws.sendText("{\"action\": \"keep_alive\",\"statusCode\":200}", true);
    }

    private void cleanUpMessageHistory() {
        this.history.forgetOlderThan(Duration.ofMinutes(1L));
    }

    private SonarCloudWebSocket() {
    }

    public void subscribe(String projectKey) {
        this.send("subscribe", projectKey, parsersByTypeForProjectFilter, PROJECT_FILTER_TYPE);
        this.send("subscribe", projectKey, parsersByTypeForProjectUserFilter, PROJECT_USER_FILTER_TYPE);
    }

    public void unsubscribe(String projectKey) {
        this.send("unsubscribe", projectKey, parsersByTypeForProjectFilter, PROJECT_FILTER_TYPE);
        this.send("unsubscribe", projectKey, parsersByTypeForProjectUserFilter, PROJECT_USER_FILTER_TYPE);
    }

    private void send(String messageType, String projectKey, Map<String, EventParser<?>> parsersByType, String filter) {
        Object[] eventsKey = parsersByType.keySet().toArray(new String[0]);
        Arrays.sort(eventsKey);
        WebSocketEventSubscribePayload payload = new WebSocketEventSubscribePayload(messageType, (String[])eventsKey, filter, projectKey);
        String jsonString = gson.toJson(payload);
        SonarLintLogger.get().debug(String.format("sent '%s' for project '%s' and filter '%s'", messageType, projectKey, filter));
        this.ws.sendText(jsonString, true);
    }

    private void handleRawMessage(String message, Consumer<ServerEvent> serverEventConsumer) {
        if (this.history.exists(message)) {
            return;
        }
        this.history.recordMessage(message);
        try {
            WebSocketEvent wsEvent = gson.fromJson(message, WebSocketEvent.class);
            SonarCloudWebSocket.parse(wsEvent).ifPresent(serverEventConsumer);
            SonarLintLogger.get().debug("Server event received: " + message, (Object)ClientLogOutput.Level.DEBUG);
        }
        catch (Exception e) {
            SonarLintLogger.get().error("Malformed event received: " + message, e);
        }
    }

    private static Optional<? extends ServerEvent> parse(WebSocketEvent event) {
        String eventType = event.event;
        if (eventType == null) {
            return Optional.empty();
        }
        if (parsersByType.containsKey(eventType)) {
            return SonarCloudWebSocket.tryParsing(parsersByType.get(eventType), event);
        }
        SonarLintLogger.get().error("Unknown '{}' event type ", (Object)eventType);
        return Optional.empty();
    }

    private static Optional<? extends ServerEvent> tryParsing(EventParser<? extends ServerEvent> eventParser, WebSocketEvent event) {
        try {
            return eventParser.parse(event.data.toString());
        }
        catch (Exception e) {
            SonarLintLogger.get().error("Cannot parse '{}' received event", (Object)event.event, (Object)e);
            return Optional.empty();
        }
    }

    public void close() {
        if (this.ws != null) {
            if (!this.ws.isOutputClosed()) {
                try {
                    this.ws.sendClose(1000, "").get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    SonarLintLogger.get().error("Cannot close the WebSocket output", e);
                }
            }
            if (!this.ws.isInputClosed()) {
                this.ws.abort();
            }
            this.ws = null;
        }
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.sonarCloudWebSocketScheduler, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            SonarLintLogger.get().warn("Unable to stop SonarCloud WebSocket job scheduler in a timely manner");
        }
    }

    public boolean isOpen() {
        return this.ws != null && !this.ws.isInputClosed() && !this.ws.isOutputClosed();
    }

    private static class WebSocketEvent {
        private String event;
        private JsonObject data;

        private WebSocketEvent() {
        }
    }
}

