/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.support;

import java.lang.reflect.Constructor;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.AccessException;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.ConstructorExecutor;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.EvaluationContext;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.TypedValue;
import org.sonarsource.sonarlint.shaded.org.springframework.expression.spel.support.ReflectionHelper;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;
import org.sonarsource.sonarlint.shaded.org.springframework.util.ReflectionUtils;

public class ReflectiveConstructorExecutor
implements ConstructorExecutor {
    private final Constructor<?> ctor;
    @Nullable
    private final Integer varargsPosition;

    public ReflectiveConstructorExecutor(Constructor<?> ctor) {
        this.ctor = ctor;
        this.varargsPosition = ctor.isVarArgs() ? Integer.valueOf(ctor.getParameterCount() - 1) : null;
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object ... arguments) throws AccessException {
        try {
            ReflectionHelper.convertArguments(context.getTypeConverter(), arguments, this.ctor, this.varargsPosition);
            if (this.ctor.isVarArgs()) {
                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.ctor.getParameterTypes(), arguments);
            }
            ReflectionUtils.makeAccessible(this.ctor);
            return new TypedValue(this.ctor.newInstance(arguments));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking constructor: " + this.ctor, ex);
        }
    }

    public Constructor<?> getConstructor() {
        return this.ctor;
    }
}

