/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.authentication.ntlm;

import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.message.BasicHeader;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NtlmAuthenticator
implements Authenticator {
    private static final String NTLM_AUTHENTICATION = "NTLM";
    private final NTCredentials ntCredentials;

    public NtlmAuthenticator(String domainAndUsernameString, String password) {
        DomainAndUsername domainAndUsername = DomainAndUsername.split(domainAndUsernameString);
        this.ntCredentials = new NTCredentials(domainAndUsername.username(), password, null, domainAndUsername.domain());
    }

    public @Nullable Request authenticate(@Nullable Route route, @NonNull Response response) throws IOException {
        String wwwAuthenticateHeader = response.header("WWW-Authenticate");
        if (wwwAuthenticateHeader == null || !wwwAuthenticateHeader.startsWith(NTLM_AUTHENTICATION)) {
            return null;
        }
        try {
            NTLMScheme scheme = new NTLMScheme();
            scheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", NTLM_AUTHENTICATION));
            Header authenticatedHeader = scheme.authenticate((Credentials)this.ntCredentials, null);
            if (wwwAuthenticateHeader.equals(NTLM_AUTHENTICATION)) {
                return response.request().newBuilder().header("Authorization", authenticatedHeader.getValue()).build();
            }
            scheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", wwwAuthenticateHeader));
            authenticatedHeader = scheme.authenticate((Credentials)this.ntCredentials, null);
            return response.request().newBuilder().header("Authorization", authenticatedHeader.getValue()).build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private record DomainAndUsername(@Nullable String domain, @NonNull String username) {
        private static DomainAndUsername split(String domainAndUsername) {
            String[] split = domainAndUsername.split("\\\\", 2);
            if (split.length == 2) {
                return new DomainAndUsername(split[0], split[1]);
            }
            return new DomainAndUsername(null, domainAndUsername);
        }
    }
}

