/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BoundFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CodeGenerator;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.ES6Generator;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EqualObjectGraphs;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JSCode;
import org.mozilla.javascript.JSDescriptor;
import org.mozilla.javascript.JSFunction;
import org.mozilla.javascript.JSScript;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.KnownBuiltInFunction;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.NewLiteralStorage;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFn;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public final class Interpreter
extends Icode
implements Evaluator {
    static final int EXCEPTION_TRY_START_SLOT = 0;
    static final int EXCEPTION_TRY_END_SLOT = 1;
    static final int EXCEPTION_HANDLER_SLOT = 2;
    static final int EXCEPTION_TYPE_SLOT = 3;
    static final int EXCEPTION_LOCAL_SLOT = 4;
    static final int EXCEPTION_SCOPE_SLOT = 5;
    static final int EXCEPTION_SLOT_SIZE = 6;
    static PrintStream interpreterBytecodePrintStream = System.out;
    private static final int INVOCATION_COST = 100;
    private static final int EXCEPTION_COST = 100;
    private static final Object undefined = Undefined.instance;
    private static final NewState BREAK_LOOP = new NewState(){};
    private static final NewState BREAK_JUMPLESSRUN = new NewState(){};
    private static final NewState BREAK_WITHOUT_EXTENSION = new NewState(){};
    private static final InstructionClass[] instructionObjs = new InstructionClass[179];
    private static final Object DBL_MRK;

    private static boolean compareDescs(JSDescriptor i1, JSDescriptor i2) {
        return i1 == i2 || Objects.equals(Interpreter.getRawSource(i1), Interpreter.getRawSource(i2));
    }

    private static CallFrame captureFrameForGenerator(CallFrame frame) {
        frame.frozen = true;
        CallFrame result = frame.captureForGenerator();
        frame.frozen = false;
        return result;
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnv, ScriptNode tree, String rawSource, boolean returnFunction) {
        CodeGenerator cgen = new CodeGenerator();
        JSDescriptor itsData = cgen.compile(compilerEnv, tree, rawSource, returnFunction);
        return new CompilationResult(itsData, compilerEnv.homeObject());
    }

    @Override
    public DebuggableScript getDebuggableScript(Object bytecode) {
        return ((CompilationResult)bytecode).descriptor;
    }

    @Override
    public Script createScriptObject(Object bytecode, Object staticSecurityDomain) {
        CompilationResult compilerResult = (CompilationResult)bytecode;
        return JSFunction.createScript(compilerResult.descriptor, compilerResult.homeObject, staticSecurityDomain);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Function createFunctionObject(Context cx, Scriptable scope, Object bytecode, Object staticSecurityDomain) {
        CompilationResult compilerResult = (CompilationResult)bytecode;
        return JSFunction.createFunction(cx, scope, compilerResult.descriptor, compilerResult.homeObject, staticSecurityDomain);
    }

    private static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame frame, boolean onlyFinally) {
        int[] exceptionTable = frame.idata.itsExceptionTable;
        if (exceptionTable == null) {
            return -1;
        }
        int pc = frame.pc - 1;
        int best = -1;
        int bestStart = 0;
        int bestEnd = 0;
        for (int i = 0; i != exceptionTable.length; i += 6) {
            int start = exceptionTable[i + 0];
            int end = exceptionTable[i + 1];
            if (start > pc || pc >= end || onlyFinally && exceptionTable[i + 3] != 1) continue;
            if (best >= 0) {
                if (bestEnd < end) continue;
                if (bestStart > start) {
                    Kit.codeBug();
                }
                if (bestEnd == end) {
                    Kit.codeBug();
                }
            }
            best = i;
            bestStart = start;
            bestEnd = end;
        }
        return best;
    }

    static <T extends ScriptOrFn<T>> void dumpICode(InterpreterData.Builder<T> idata, JSDescriptor.Builder<T> desc) {
        if (!Token.printICode) {
            return;
        }
        byte[] iCode = idata.itsICode;
        int iCodeLength = iCode.length;
        String[] strings = idata.itsStringTable;
        BigInteger[] bigInts = idata.itsBigIntTable;
        PrintStream out = interpreterBytecodePrintStream;
        out.println("ICode dump, for " + desc.name + ", length = " + iCodeLength);
        out.println("MaxStack = " + idata.itsMaxStack);
        int indexReg = 0;
        int pc = 0;
        while (pc < iCodeLength) {
            out.flush();
            out.print(" [" + pc + "] ");
            byte token = iCode[pc];
            int icodeLength = Interpreter.bytecodeSpan(token);
            String tname = Icode.bytecodeName(token);
            int old_pc = pc++;
            switch (token) {
                default: {
                    if (icodeLength != 1) {
                        Kit.codeBug();
                    }
                    out.println(tname);
                    break;
                }
                case -84: 
                case -83: 
                case -61: 
                case -28: 
                case -6: 
                case 5: 
                case 6: 
                case 7: {
                    int newPC = pc + Interpreter.getShort(iCode, pc) - 1;
                    out.println(tname + " " + newPC);
                    pc += 2;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: {
                    byte incrDecrType = iCode[pc];
                    out.println(tname + " " + incrDecrType);
                    ++pc;
                    break;
                }
                case -26: 
                case -25: {
                    int callType = iCode[pc] & 0xFF;
                    boolean isNew = iCode[pc + 1] != 0;
                    int line = Interpreter.getIndex(iCode, pc + 2);
                    out.println(tname + " " + callType + " " + isNew + " " + indexReg + " " + line);
                    pc += 4;
                    break;
                }
                case 63: {
                    boolean afterFisrtFlag = iCode[pc] != 0;
                    out.println(tname + " " + afterFisrtFlag);
                    ++pc;
                    break;
                }
                case 54: {
                    out.println(tname + " " + String.valueOf(idata.itsRegExpLiterals[indexReg]));
                    break;
                }
                case -34: {
                    boolean copyArray;
                    boolean bl = copyArray = iCode[pc++] != 0;
                    if (indexReg < 0) {
                        out.println(tname + " length: " + (-indexReg - 1));
                        break;
                    }
                    Object[] keys = (Object[])idata.literalIds[indexReg];
                    out.println(tname + " " + Arrays.toString(keys) + " " + copyArray);
                    break;
                }
                case -38: {
                    out.println(tname + " " + String.valueOf(idata.literalIds[indexReg]));
                    break;
                }
                case -37: 
                case -24: 
                case -23: {
                    out.println(tname + " #" + indexReg);
                    break;
                }
                case -85: 
                case -62: 
                case 30: 
                case 43: 
                case 77: {
                    out.println(tname + " " + indexReg);
                    break;
                }
                case -73: 
                case -72: 
                case -70: 
                case -69: 
                case 56: 
                case 79: {
                    int line = Interpreter.getIndex(iCode, pc);
                    out.println(tname + " : " + line);
                    pc += 2;
                    break;
                }
                case -32: {
                    int value = Interpreter.getShort(iCode, pc);
                    out.println(tname + " " + value);
                    pc += 2;
                    break;
                }
                case -33: {
                    int value = Interpreter.getInt(iCode, pc);
                    out.println(tname + " " + value);
                    pc += 4;
                    break;
                }
                case 45: {
                    double value = idata.itsDoubleTable[indexReg];
                    out.println(tname + " " + value);
                    break;
                }
                case -31: {
                    int line = Interpreter.getIndex(iCode, pc);
                    out.println(tname + " : " + line);
                    pc += 2;
                    break;
                }
                case -52: {
                    String str = strings[0xFF & iCode[pc]];
                    out.println(tname + " \"" + str + "\"");
                    ++pc;
                    break;
                }
                case -53: {
                    String str = strings[Interpreter.getIndex(iCode, pc)];
                    out.println(tname + " \"" + str + "\"");
                    pc += 2;
                    break;
                }
                case -54: {
                    String str = strings[Interpreter.getInt(iCode, pc)];
                    out.println(tname + " \"" + str + "\"");
                    pc += 4;
                    break;
                }
                case -48: {
                    String str = strings[0];
                    out.println(tname + " \"" + str + "\"");
                    break;
                }
                case -49: {
                    String str = strings[1];
                    out.println(tname + " \"" + str + "\"");
                    break;
                }
                case -50: {
                    String str = strings[2];
                    out.println(tname + " \"" + str + "\"");
                    break;
                }
                case -51: {
                    String str = strings[3];
                    out.println(tname + " \"" + str + "\"");
                    break;
                }
                case -39: {
                    indexReg = 0;
                    out.println(tname);
                    break;
                }
                case -40: {
                    indexReg = 1;
                    out.println(tname);
                    break;
                }
                case -41: {
                    indexReg = 2;
                    out.println(tname);
                    break;
                }
                case -42: {
                    indexReg = 3;
                    out.println(tname);
                    break;
                }
                case -43: {
                    indexReg = 4;
                    out.println(tname);
                    break;
                }
                case -44: {
                    indexReg = 5;
                    out.println(tname);
                    break;
                }
                case -45: {
                    indexReg = 0xFF & iCode[pc];
                    out.println(tname + " " + indexReg);
                    ++pc;
                    break;
                }
                case -46: {
                    indexReg = Interpreter.getIndex(iCode, pc);
                    out.println(tname + " " + indexReg);
                    pc += 2;
                    break;
                }
                case -47: {
                    indexReg = Interpreter.getInt(iCode, pc);
                    out.println(tname + " " + indexReg);
                    pc += 4;
                    break;
                }
                case -68: 
                case -56: 
                case -55: {
                    indexReg = iCode[pc];
                    out.println(tname + " " + indexReg);
                    ++pc;
                    break;
                }
                case -74: {
                    out.println(tname + " " + bigInts[0].toString() + "n");
                    break;
                }
                case -75: {
                    out.println(tname + " " + bigInts[1].toString() + "n");
                    break;
                }
                case -76: {
                    out.println(tname + " " + bigInts[2].toString() + "n");
                    break;
                }
                case -77: {
                    out.println(tname + " " + bigInts[3].toString() + "n");
                    break;
                }
                case -78: {
                    BigInteger bigInt = bigInts[0xFF & iCode[pc]];
                    out.println(tname + " " + bigInt.toString() + "n");
                    ++pc;
                    break;
                }
                case -79: {
                    BigInteger bigInt = bigInts[Interpreter.getIndex(iCode, pc)];
                    out.println(tname + " " + bigInt.toString() + "n");
                    pc += 2;
                    break;
                }
                case -80: {
                    BigInteger bigInt = bigInts[Interpreter.getInt(iCode, pc)];
                    out.println(tname + " " + bigInt.toString() + "n");
                    pc += 4;
                    break;
                }
            }
            if (old_pc + icodeLength == pc) continue;
            Kit.codeBug();
        }
        int[] table = idata.itsExceptionTable;
        if (table != null) {
            out.println("Exception handlers: " + table.length / 6);
            for (int i = 0; i != table.length; i += 6) {
                int tryStart = table[i + 0];
                int tryEnd = table[i + 1];
                int handlerStart = table[i + 2];
                int type = table[i + 3];
                int exceptionLocal = table[i + 4];
                out.println(" tryStart=" + tryStart + " tryEnd=" + tryEnd + " handlerStart=" + handlerStart + " type=" + (type == 0 ? "catch" : "finally") + " exceptionLocal=" + exceptionLocal);
            }
        }
        out.flush();
    }

    private static int bytecodeSpan(int bytecode) {
        switch (bytecode) {
            case -73: 
            case -72: 
            case -70: 
            case -69: 
            case 56: 
            case 79: {
                return 3;
            }
            case -84: 
            case -83: 
            case -61: 
            case -28: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -26: 
            case -25: {
                return 5;
            }
            case 63: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -32: {
                return 3;
            }
            case -33: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -52: {
                return 2;
            }
            case -53: {
                return 3;
            }
            case -54: {
                return 5;
            }
            case -68: 
            case -56: 
            case -55: {
                return 2;
            }
            case -31: {
                return 3;
            }
            case -34: {
                return 2;
            }
            case -78: {
                return 2;
            }
            case -79: {
                return 3;
            }
            case -80: {
                return 5;
            }
        }
        if (!Interpreter.validBytecode(bytecode)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(JSDescriptor desc) {
        int span;
        InterpreterData data;
        JSCode code = desc.getCode();
        if (code instanceof InterpreterData) {
            data = (InterpreterData)code;
        } else {
            code = desc.getConstructor();
            if (code instanceof InterpreterData) {
                data = (InterpreterData)code;
            } else {
                Kit.codeBug("Attempt to get line number data for non-interpreted code.");
                return null;
            }
        }
        HashSet<Integer> presentLines = new HashSet<Integer>();
        byte[] iCode = data.itsICode;
        int iCodeLength = iCode.length;
        for (int pc = 0; pc != iCodeLength; pc += span) {
            byte bytecode = iCode[pc];
            span = Interpreter.bytecodeSpan(bytecode);
            if (bytecode != -31) continue;
            if (span != 3) {
                Kit.codeBug();
            }
            int line = Interpreter.getIndex(iCode, pc + 1);
            presentLines.add(line);
        }
        int[] ret = new int[presentLines.size()];
        int i = 0;
        Iterator iterator = presentLines.iterator();
        while (iterator.hasNext()) {
            int num = (Integer)iterator.next();
            ret[i++] = num;
        }
        return ret;
    }

    @Override
    public void captureStackInfo(RhinoException ex) {
        Context cx = Context.getCurrentContext();
        if (cx == null || cx.lastInterpreterFrame == null) {
            ex.interpreterStackInfo = null;
        } else {
            ex.interpreterStackInfo = cx.lastInterpreterFrame;
            ex.interpreterLineData = ((CallFrame)cx.lastInterpreterFrame).pcSourceLineStart;
        }
    }

    @Override
    public String getSourcePositionFromStack(Context cx, int[] linep) {
        CallFrame frame = (CallFrame)cx.lastInterpreterFrame;
        InterpreterData<?> idata = frame.idata;
        JSDescriptor<?> desc = frame.fnOrScript.getDescriptor();
        linep[0] = frame.pcSourceLineStart >= 0 ? Interpreter.getIndex(idata.itsICode, frame.pcSourceLineStart) : 0;
        return desc.getSourceName();
    }

    @Override
    public String getPatchedStack(RhinoException ex, String nativeStackTrace) {
        String tag = "org.mozilla.javascript.Interpreter.interpretLoop";
        StringBuilder sb = new StringBuilder(nativeStackTrace.length() + 1000);
        String lineSeparator = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame calleeFrame = null;
        CallFrame frame = (CallFrame)ex.interpreterStackInfo;
        int offset = 0;
        while (frame != null) {
            char c;
            CallFrame callerFrame = frame;
            int pos = nativeStackTrace.indexOf(tag, offset);
            if (pos < 0) break;
            pos += tag.length();
            while (pos != nativeStackTrace.length() && (c = nativeStackTrace.charAt(pos)) != '\n' && c != '\r') {
                ++pos;
            }
            sb.append(nativeStackTrace, offset, pos);
            offset = pos;
            while (callerFrame != null) {
                int pc;
                InterpreterData<?> idata = callerFrame.idata;
                JSDescriptor<?> desc = callerFrame.fnOrScript.getDescriptor();
                sb.append(lineSeparator);
                sb.append("\tat script");
                if (desc.getName() != null && desc.getName().length() != 0) {
                    sb.append('.');
                    sb.append(desc.getName());
                }
                sb.append('(');
                sb.append(desc.getSourceName());
                int n = pc = calleeFrame == null ? ex.interpreterLineData : calleeFrame.parentPC;
                if (pc >= 0) {
                    sb.append(':');
                    sb.append(Interpreter.getIndex(idata.itsICode, pc));
                }
                sb.append(')');
                calleeFrame = callerFrame;
                callerFrame = callerFrame.parentFrame;
            }
            frame = calleeFrame.previousInterpreterFrame;
        }
        sb.append(nativeStackTrace.substring(offset));
        return sb.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException ex) {
        ScriptStackElement[][] stack = this.getScriptStackElements(ex);
        ArrayList<String> list = new ArrayList<String>(stack.length);
        String lineSeparator = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement[] group : stack) {
            StringBuilder sb = new StringBuilder();
            for (ScriptStackElement elem : group) {
                elem.renderJavaStyle(sb);
                sb.append(lineSeparator);
            }
            list.add(sb.toString());
        }
        return list;
    }

    public ScriptStackElement[][] getScriptStackElements(RhinoException ex) {
        if (ex.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<ScriptStackElement[]> list = new ArrayList<ScriptStackElement[]>();
        CallFrame calleeFrame = null;
        CallFrame frame = (CallFrame)ex.interpreterStackInfo;
        while (frame != null) {
            CallFrame callerFrame = frame;
            ArrayList<ScriptStackElement> group = new ArrayList<ScriptStackElement>();
            while (callerFrame != null) {
                int pc;
                InterpreterData<?> idata = callerFrame.idata;
                JSDescriptor<?> desc = callerFrame.fnOrScript.getDescriptor();
                String fileName = desc.getSourceName();
                String functionName = null;
                int lineNumber = -1;
                int n = pc = calleeFrame == null ? ex.interpreterLineData : calleeFrame.parentPC;
                if (pc >= 0) {
                    lineNumber = Interpreter.getIndex(idata.itsICode, pc);
                }
                if (desc.getName() != null && desc.getName().length() != 0) {
                    functionName = desc.getName();
                }
                calleeFrame = callerFrame;
                callerFrame = callerFrame.parentFrame;
                group.add(new ScriptStackElement(fileName, functionName, lineNumber));
            }
            list.add(group.toArray(new ScriptStackElement[0]));
            frame = calleeFrame.previousInterpreterFrame;
        }
        return (ScriptStackElement[][])list.toArray((T[])new ScriptStackElement[list.size()][]);
    }

    static String getRawSource(JSDescriptor desc) {
        if (desc.getRawSource() == null) {
            return null;
        }
        return desc.getRawSource();
    }

    private static void initFunction(Context cx, Scriptable scope, JSDescriptor parent, int index) {
        JSFunction fn = JSFunction.createFunction(cx, scope, parent, index, null);
        JSDescriptor<JSFunction> desc = fn.getDescriptor();
        ScriptRuntime.initFunction(cx, scope, fn, desc.getFunctionType(), parent.isEvalFunction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(ScriptOrFn ifun, InterpreterData idata, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        JSDescriptor desc;
        if (!ScriptRuntime.hasTopCall(cx)) {
            Kit.codeBug();
        }
        if (cx.interpreterSecurityDomain != (desc = ifun.getDescriptor()).getSecurityDomain()) {
            Object savedDomain = cx.interpreterSecurityDomain;
            cx.interpreterSecurityDomain = desc.getSecurityDomain();
            try {
                if (ifun instanceof JSScript) {
                    Object object = desc.getSecurityController().callWithDomain(desc.getSecurityDomain(), cx, (JSScript)ifun, scope, thisObj, args);
                    return object;
                }
                if (ifun instanceof JSFunction) {
                    Object object = desc.getSecurityController().callWithDomain(desc.getSecurityDomain(), cx, (JSFunction)ifun, scope, thisObj, args);
                    return object;
                }
                Kit.codeBug("Unknown compiled code type.");
            }
            finally {
                cx.interpreterSecurityDomain = savedDomain;
            }
        }
        CallFrame frame = Interpreter.initFrame(cx, scope, thisObj, ifun.getHomeObject(), args, null, null, 0, args.length, ifun, idata, null);
        frame.isContinuationsTopFrame = cx.isContinuationsTopCall;
        cx.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(cx, frame, null);
    }

    /*
     * Exception decompiling
     */
    public static Object resumeGenerator(Context cx, Scriptable scope, int operation, Object savedState, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object restartContinuation(NativeContinuation c, Context cx, Scriptable scope, Object[] args) {
        if (!ScriptRuntime.hasTopCall(cx)) {
            return ScriptRuntime.doTopCall(c, cx, scope, null, args, cx.isTopLevelStrict);
        }
        Object arg = args.length == 0 ? Undefined.instance : args[0];
        CallFrame capturedFrame = (CallFrame)c.getImplementation();
        if (capturedFrame == null) {
            return arg;
        }
        ContinuationJump cjump = new ContinuationJump(c, null);
        cjump.result = arg;
        return Interpreter.interpretLoop(cx, null, cjump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object interpretLoop(Context cx, CallFrame frame, Object throwable) {
        Object oldFrame = cx.lastInterpreterFrame;
        try {
            double interpreterResultDbl;
            Object interpreterResult;
            block48: {
                ContinuationJump cjump;
                boolean instructionCounting = cx.instructionThreshold != 0;
                Object stringReg = null;
                Object bigIntReg = null;
                int indexReg = -1;
                GeneratorState generatorState = null;
                if (throwable != null) {
                    if (throwable instanceof GeneratorState) {
                        generatorState = (GeneratorState)throwable;
                        Interpreter.enterFrame(cx, frame, ScriptRuntime.emptyArgs, true);
                        throwable = null;
                    } else if (!(throwable instanceof ContinuationJump)) {
                        Kit.codeBug();
                    }
                }
                interpreterResult = null;
                interpreterResultDbl = 0.0;
                block12: while (true) {
                    block50: {
                        int exState;
                        InterpreterResult result;
                        block49: {
                            Object sbr;
                            while (true) {
                                if (throwable != null) {
                                    frame = Interpreter.processThrowable(cx, throwable, frame, indexReg, instructionCounting);
                                    throwable = frame.throwable;
                                    frame.throwable = null;
                                } else if (generatorState == null && frame.frozen) {
                                    Kit.codeBug();
                                }
                                result = Interpreter.interpretFunction(cx, frame, throwable, generatorState, indexReg, instructionCounting);
                                if (!(result instanceof StateContinueResult)) break;
                                StateContinueResult scr = (StateContinueResult)result;
                                frame = scr.frame;
                                indexReg = scr.indexReg;
                            }
                            if (result instanceof StateBreakResult) {
                                sbr = (StateBreakResult)result;
                                frame = ((StateBreakResult)sbr).frame;
                                interpreterResult = frame.result;
                                interpreterResultDbl = frame.resultDbl;
                                break block48;
                            }
                            if (!(result instanceof YieldResult)) break block49;
                            sbr = ((YieldResult)result).yielding;
                            return sbr;
                        }
                        try {
                            if (result instanceof ThrowableResult) {
                                ThrowableResult tr = (ThrowableResult)result;
                                frame = tr.frame;
                                throwable = tr.throwable;
                            } else {
                                Kit.codeBug();
                            }
                        }
                        catch (Throwable ex) {
                            if (throwable != null) {
                                ex.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            throwable = ex;
                        }
                        if (throwable == null) {
                            Kit.codeBug();
                        }
                        int EX_CATCH_STATE = 2;
                        boolean EX_FINALLY_STATE = true;
                        boolean EX_NO_JS_STATE = false;
                        cjump = null;
                        if (generatorState != null && generatorState.operation == 2 && throwable == generatorState.value) {
                            exState = 1;
                        } else if (throwable instanceof JavaScriptException) {
                            exState = 2;
                        } else if (throwable instanceof EcmaError) {
                            exState = 2;
                        } else if (throwable instanceof EvaluatorException) {
                            exState = 2;
                        } else if (throwable instanceof ContinuationPending) {
                            exState = 0;
                        } else if (throwable instanceof RuntimeException) {
                            exState = cx.hasFeature(13) ? 2 : 1;
                        } else if (throwable instanceof Error) {
                            exState = cx.hasFeature(13) ? 2 : 0;
                        } else if (throwable instanceof ContinuationJump) {
                            exState = 1;
                            cjump = (ContinuationJump)throwable;
                        } else {
                            int n = exState = cx.hasFeature(13) ? 2 : 1;
                        }
                        if (instructionCounting) {
                            try {
                                Interpreter.addInstructionCount(cx, frame, 100);
                            }
                            catch (RuntimeException ex) {
                                throwable = ex;
                                exState = 1;
                            }
                            catch (Error ex) {
                                throwable = ex;
                                cjump = null;
                                exState = 0;
                            }
                        }
                        if (frame.debuggerFrame != null && throwable instanceof RuntimeException) {
                            RuntimeException rex = (RuntimeException)throwable;
                            try {
                                frame.debuggerFrame.onExceptionThrown(cx, rex);
                            }
                            catch (Throwable ex) {
                                throwable = ex;
                                cjump = null;
                                exState = 0;
                            }
                        }
                        do {
                            boolean onlyFinally;
                            if (exState != 0 && (indexReg = Interpreter.getExceptionHandler(frame, onlyFinally = exState != 2)) >= 0) continue block12;
                            Interpreter.exitFrame(cx, frame, throwable);
                            frame = frame.parentFrame;
                            if (frame == null) break block50;
                        } while (cjump == null || !Objects.equals(cjump.branchFrame, frame));
                        indexReg = -1;
                        continue;
                    }
                    if (cjump == null) break block48;
                    if (cjump.branchFrame != null) {
                        Kit.codeBug();
                    }
                    if (cjump.capturedFrame == null) break;
                    indexReg = -1;
                }
                interpreterResult = cjump.result;
                interpreterResultDbl = cjump.resultDbl;
                throwable = null;
            }
            cx.lastInterpreterFrame = frame != null ? (frame.parentFrame == null ? frame.previousInterpreterFrame : frame.parentFrame) : null;
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            Object object = interpreterResult != DBL_MRK ? interpreterResult : ScriptRuntime.wrapNumber(interpreterResultDbl);
            return object;
        }
        finally {
            cx.lastInterpreterFrame = oldFrame;
        }
    }

    private static InterpreterResult interpretFunction(Context cx, CallFrame frame, Object tble, GeneratorState genState, int iReg, boolean instructionCounting) {
        InterpreterState state;
        block10: {
            state = new InterpreterState(frame.savedStackTop, iReg, instructionCounting);
            try {
                block9: {
                    NewState nextState;
                    byte[] iCode = frame.idata.itsICode;
                    state.generatorState = genState;
                    state.throwable = tble;
                    cx.lastInterpreterFrame = frame;
                    while (true) {
                        int offset;
                        byte op;
                        InstructionClass insn;
                        if ((nextState = (insn = instructionObjs[87 + (op = iCode[frame.pc++])]).execute(cx, frame, state, op)) == null) {
                            continue;
                        }
                        if (nextState == BREAK_LOOP) break block9;
                        if (nextState != BREAK_JUMPLESSRUN) break;
                        if (instructionCounting) {
                            Interpreter.addInstructionCount(cx, frame, 2);
                        }
                        frame.pc = (offset = Interpreter.getShort(iCode, frame.pc)) != 0 ? (frame.pc += offset - 1) : frame.idata.longJumps.get(frame.pc);
                        if (!instructionCounting) continue;
                        frame.pcPrevBranch = frame.pc;
                    }
                    if (nextState != BREAK_WITHOUT_EXTENSION) {
                        return (InterpreterResult)nextState;
                    }
                    break block10;
                }
                Interpreter.exitFrame(cx, frame, null);
                if (frame.parentFrame != null) {
                    CallFrame newFrame = frame.parentFrame;
                    if (newFrame.frozen) {
                        newFrame = newFrame.cloneFrozen();
                    }
                    Interpreter.setCallResult(newFrame, frame.result, frame.resultDbl);
                    return new StateContinueResult(newFrame, state.indexReg);
                }
                return new StateBreakResult(frame);
            }
            catch (Throwable ex) {
                if (state.throwable != null) {
                    ex.printStackTrace(System.err);
                    throw new IllegalStateException();
                }
                state.throwable = ex;
            }
        }
        return new ThrowableResult(frame, state.throwable);
    }

    private static Object freezeGenerator(Context cx, CallFrame frame, InterpreterState state, GeneratorState generatorState, boolean yieldStar) {
        Object result;
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeErrorById("msg.yield.closing", new Object[0]);
        }
        frame.frozen = true;
        frame.result = frame.stack[state.stackTop];
        frame.resultDbl = frame.sDbl[state.stackTop];
        frame.savedStackTop = state.stackTop;
        --frame.pc;
        ScriptRuntime.exitActivationFunction(cx);
        Object object = result = frame.result != UniqueTag.DOUBLE_MARK ? frame.result : ScriptRuntime.wrapNumber(frame.resultDbl);
        if (yieldStar) {
            return new ES6Generator.YieldStarResult(result);
        }
        return result;
    }

    private static Object thawGenerator(CallFrame frame, InterpreterState state, GeneratorState generatorState, int op) {
        frame.frozen = false;
        int sourceLine = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
        frame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, frame.fnOrScript.getDescriptor().getSourceName(), sourceLine);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (op == 79 || op == -73) {
            frame.stack[state.stackTop] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static boolean doEquals(InterpreterState state, Object[] stack, double[] sDbl) {
        Object rhs = stack[state.stackTop--];
        Object lhs = stack[state.stackTop];
        boolean res = rhs == UniqueTag.DOUBLE_MARK ? (lhs == UniqueTag.DOUBLE_MARK ? sDbl[state.stackTop] == sDbl[state.stackTop + 1] : ScriptRuntime.eqNumber(sDbl[state.stackTop + 1], lhs)) : (lhs == UniqueTag.DOUBLE_MARK ? ScriptRuntime.eqNumber(sDbl[state.stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
        return res;
    }

    private static boolean doShallowEquals(InterpreterState state, Object[] stack, double[] sDbl) {
        boolean res;
        Object rhs = stack[state.stackTop--];
        Object lhs = stack[state.stackTop];
        if (rhs == UniqueTag.DOUBLE_MARK) {
            double rDbl = sDbl[state.stackTop + 1];
            res = lhs == UniqueTag.DOUBLE_MARK ? rDbl == sDbl[state.stackTop] : (lhs instanceof Number && !(lhs instanceof BigInteger) ? rDbl == ((Number)lhs).doubleValue() : false);
        } else if (lhs == UniqueTag.DOUBLE_MARK) {
            double ldbl = sDbl[state.stackTop];
            res = rhs instanceof Number && !(rhs instanceof BigInteger) ? ldbl == ((Number)rhs).doubleValue() : false;
        } else {
            res = ScriptRuntime.shallowEq(lhs, rhs);
        }
        return res;
    }

    private static Object[] addBoundArgs(Object[] boundArgs, Object[] newArgs) {
        if (newArgs.length == 0) {
            return boundArgs;
        }
        if (boundArgs == null) {
            return newArgs;
        }
        Object[] result = Arrays.copyOf(newArgs, boundArgs.length + newArgs.length);
        System.arraycopy(boundArgs, 0, result, newArgs.length, boundArgs.length);
        return result;
    }

    private static CallFrame processThrowable(Context cx, Object throwable, CallFrame frame, int indexReg, boolean instructionCounting) {
        if (indexReg >= 0) {
            if (frame.frozen) {
                frame = frame.cloneFrozen();
            }
            int[] table = frame.idata.itsExceptionTable;
            frame.pc = table[indexReg + 2];
            if (instructionCounting) {
                frame.pcPrevBranch = frame.pc;
            }
            frame.savedStackTop = frame.emptyStackTop;
            int localShift = frame.idata.itsMaxVars;
            int scopeLocal = localShift + table[indexReg + 5];
            int exLocal = localShift + table[indexReg + 4];
            frame.scope = (Scriptable)frame.stack[scopeLocal];
            frame.stack[exLocal] = throwable;
            throwable = null;
        } else {
            ContinuationJump cjump = (ContinuationJump)throwable;
            throwable = null;
            if (!Objects.equals(cjump.branchFrame, frame)) {
                Kit.codeBug();
            }
            if (cjump.capturedFrame == null) {
                Kit.codeBug();
            }
            int rewindCount = cjump.capturedFrame.frameIndex + 1;
            if (cjump.branchFrame != null) {
                rewindCount -= cjump.branchFrame.frameIndex;
            }
            int enterCount = 0;
            CallFrame[] enterFrames = null;
            CallFrame x = cjump.capturedFrame;
            for (int i = 0; i != rewindCount; ++i) {
                if (!x.frozen) {
                    Kit.codeBug();
                }
                if (x.useActivation) {
                    if (enterFrames == null) {
                        enterFrames = new CallFrame[rewindCount - i];
                    }
                    enterFrames[enterCount] = x;
                    ++enterCount;
                }
                x = x.parentFrame;
            }
            while (enterCount != 0) {
                x = enterFrames[--enterCount];
                Interpreter.enterFrame(cx, x, ScriptRuntime.emptyArgs, true);
            }
            frame = cjump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult(frame, cjump.result, cjump.resultDbl);
        }
        frame.throwable = throwable;
        return frame;
    }

    private static Scriptable getApplyThis(Context cx, Object[] stack, double[] sDbl, Object[] boundArgs, int thisIdx, int indexReg, Function target, CallFrame frame) {
        Object obj;
        if (indexReg != 0) {
            if (boundArgs != null && boundArgs.length > 0) {
                obj = boundArgs[0];
            } else {
                obj = stack[thisIdx];
                if (obj == UniqueTag.DOUBLE_MARK) {
                    obj = ScriptRuntime.wrapNumber(sDbl[thisIdx]);
                }
            }
        } else {
            obj = null;
        }
        return ScriptRuntime.getApplyOrCallThis(cx, target.getDeclarationScope(), obj, indexReg, target);
    }

    private static CallFrame initFrame(Context cx, Scriptable callerScope, Scriptable thisObj, Scriptable homeObj, Object[] args, double[] argsDbl, Object[] boundArgs, int argShift, int argCount, ScriptOrFn fnOrScript, InterpreterData code, CallFrame parentFrame) {
        CallFrame frame = new CallFrame(cx, thisObj, fnOrScript, code, parentFrame, parentFrame == null ? (CallFrame)cx.lastInterpreterFrame : parentFrame.previousInterpreterFrame);
        frame.initializeArgs(cx, callerScope, args, argsDbl, boundArgs, argShift, argCount, homeObj);
        Interpreter.enterFrame(cx, frame, args, false);
        return frame;
    }

    private static void enterFrame(Context cx, CallFrame frame, Object[] args, boolean continuationRestart) {
        boolean isDebugged;
        boolean usesActivation = frame.fnOrScript.getDescriptor().requiresActivationFrame();
        boolean bl = isDebugged = frame.debuggerFrame != null;
        if (usesActivation) {
            Scriptable scope = frame.scope;
            if (scope == null) {
                Kit.codeBug();
            } else if (continuationRestart) {
                while (scope instanceof NativeWith) {
                    if ((scope = scope.getParentScope()) != null && (frame.parentFrame == null || frame.parentFrame.scope != scope)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (isDebugged) {
                frame.debuggerFrame.onEnter(cx, scope, frame.thisObj, args);
            }
            ScriptRuntime.enterActivationFunction(cx, scope);
        } else if (isDebugged) {
            frame.debuggerFrame.onEnter(cx, new DebugScope(frame), frame.thisObj, args);
        }
    }

    private static void exitFrame(Context cx, CallFrame frame, Object throwable) {
        if (frame.fnOrScript.getDescriptor().requiresActivationFrame()) {
            ScriptRuntime.exitActivationFunction(cx);
        }
        if (frame.debuggerFrame != null) {
            try {
                if (throwable instanceof Throwable) {
                    frame.debuggerFrame.onExit(cx, true, throwable);
                } else {
                    ContinuationJump cjump = (ContinuationJump)throwable;
                    Object result = cjump == null ? frame.result : cjump.result;
                    if (result == UniqueTag.DOUBLE_MARK) {
                        double resultDbl = cjump == null ? frame.resultDbl : cjump.resultDbl;
                        result = ScriptRuntime.wrapNumber(resultDbl);
                    }
                    frame.debuggerFrame.onExit(cx, false, result);
                }
            }
            catch (Throwable ex) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                ex.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame frame, Object callResult, double callResultDbl) {
        if (frame.savedCallOp == 43 || frame.savedCallOp == -85) {
            frame.stack[frame.savedStackTop] = callResult;
            frame.sDbl[frame.savedStackTop] = callResultDbl;
        } else if (frame.savedCallOp == 30) {
            if (callResult instanceof Scriptable) {
                frame.stack[frame.savedStackTop] = callResult;
            }
        } else {
            Kit.codeBug();
        }
        frame.savedCallOp = 0;
    }

    public static NativeContinuation captureContinuation(Context cx) {
        if (cx.lastInterpreterFrame == null || !(cx.lastInterpreterFrame instanceof CallFrame)) {
            throw new IllegalStateException("Interpreter frames not found");
        }
        return Interpreter.captureContinuation(cx, (CallFrame)cx.lastInterpreterFrame, true);
    }

    private static NativeContinuation captureContinuation(Context cx, CallFrame frame, boolean requireContinuationsTopFrame) {
        NativeContinuation c = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(c, ScriptRuntime.getTopCallScope(cx));
        CallFrame x = frame;
        CallFrame outermost = frame;
        while (x != null && !x.frozen) {
            x.frozen = true;
            for (int i = x.savedStackTop + 1; i != x.stack.length; ++i) {
                x.stack[i] = null;
                x.stackAttributes[i] = 0;
            }
            if (x.savedCallOp == 43 || x.savedCallOp == -85) {
                x.stack[x.savedStackTop] = null;
            } else if (x.savedCallOp != 30) {
                Kit.codeBug();
            }
            outermost = x;
            x = x.parentFrame;
        }
        if (requireContinuationsTopFrame) {
            while (outermost.parentFrame != null) {
                outermost = outermost.parentFrame;
            }
            if (!outermost.isContinuationsTopFrame) {
                throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
            }
        }
        c.initImplementation(frame);
        return c;
    }

    private static int stack_int32(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (x == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toInt32(frame.sDbl[i]);
        }
        return ScriptRuntime.toInt32(x);
    }

    private static double stack_double(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (x != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(x);
        }
        return frame.sDbl[i];
    }

    private static Number stack_numeric(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (x != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumeric(x);
        }
        return frame.sDbl[i];
    }

    private static boolean stack_boolean(CallFrame frame, int i) {
        Object x = frame.stack[i];
        if (Boolean.TRUE.equals(x)) {
            return true;
        }
        if (Boolean.FALSE.equals(x)) {
            return false;
        }
        if (x == UniqueTag.DOUBLE_MARK) {
            double d = frame.sDbl[i];
            return !Double.isNaN(d) && d != 0.0;
        }
        if (x == null || x == Undefined.instance) {
            return false;
        }
        if (x instanceof BigInteger) {
            return !x.equals(BigInteger.ZERO);
        }
        if (x instanceof Number) {
            double d = ((Number)x).doubleValue();
            return !Double.isNaN(d) && d != 0.0;
        }
        return ScriptRuntime.toBoolean(x);
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, int shift, int count) {
        return Interpreter.getArgsArray(stack, sDbl, new Object[0], 0, shift, count);
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, Object[] bound, int bCount, int shift, int count) {
        int i;
        if (count == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] args = new Object[count];
        for (i = 0; i < bCount; ++i) {
            args[i] = bound[i];
        }
        i = bCount;
        while (i != count) {
            Object val = stack[shift];
            if (val == UniqueTag.DOUBLE_MARK) {
                val = ScriptRuntime.wrapNumber(sDbl[shift]);
            }
            args[i] = val;
            ++i;
            ++shift;
        }
        return args;
    }

    private static void addInstructionCount(Context cx, CallFrame frame, int extra) {
        cx.instructionCount += frame.pc - frame.pcPrevBranch + extra;
        if (cx.instructionCount > cx.instructionThreshold) {
            cx.observeInstructionCount(cx.instructionCount);
            cx.instructionCount = 0;
        }
    }

    private static JSFunction createClosure(Context cx, CallFrame frame, int index) {
        DebuggableScript desc = frame.fnOrScript.getDescriptor().getFunction(index);
        boolean isArrow = ((JSDescriptor)desc).getFunctionType() == 4;
        Scriptable homeObject = isArrow ? frame.fnOrScript.getHomeObject() : null;
        JSFunction f = new JSFunction(cx, frame.scope, (JSDescriptor<JSFunction>)desc, frame.thisObj, homeObject);
        return f;
    }

    private static JSFunction createMethod(Context cx, CallFrame frame, int index, Scriptable homeObject) {
        DebuggableScript desc = frame.fnOrScript.getDescriptor().getFunction(index);
        boolean isArrow = ((JSDescriptor)desc).getFunctionType() == 4;
        JSFunction f = new JSFunction(cx, frame.scope, (JSDescriptor<JSFunction>)desc, frame.thisObj, homeObject);
        return f;
    }

    static {
        int base = 87;
        Interpreter.instructionObjs[base + -69] = new DoGenerator();
        Interpreter.instructionObjs[base + 79] = new DoYield();
        Interpreter.instructionObjs[base + -73] = new DoYield();
        Interpreter.instructionObjs[base + -70] = new DoGeneratorEnd();
        Interpreter.instructionObjs[base + -72] = new DoGeneratorReturn();
        Interpreter.instructionObjs[base + 56] = new DoThrow();
        Interpreter.instructionObjs[base + 57] = new DoRethrow();
        Interpreter.instructionObjs[base + 17] = new DoCompare();
        Interpreter.instructionObjs[base + 15] = new DoCompare();
        Interpreter.instructionObjs[base + 16] = new DoCompare();
        Interpreter.instructionObjs[base + 14] = new DoCompare();
        Interpreter.instructionObjs[base + 58] = new DoInOrInstanceof();
        Interpreter.instructionObjs[base + 59] = new DoInOrInstanceof();
        Interpreter.instructionObjs[base + 12] = new DoEquals();
        Interpreter.instructionObjs[base + 13] = new DoNotEquals();
        Interpreter.instructionObjs[base + 52] = new DoShallowEquals();
        Interpreter.instructionObjs[base + 53] = new DoShallowNotEquals();
        Interpreter.instructionObjs[base + 7] = new DoIfNE();
        Interpreter.instructionObjs[base + 6] = new DoIfEQ();
        Interpreter.instructionObjs[base + -6] = new DoIfEQPop();
        Interpreter.instructionObjs[base + -83] = new DoIfNullUndef();
        Interpreter.instructionObjs[base + -84] = new DoIfNotNullUndef();
        Interpreter.instructionObjs[base + 5] = new DoGoto();
        Interpreter.instructionObjs[base + -28] = new DoGosub();
        Interpreter.instructionObjs[base + -29] = new DoStartSub();
        Interpreter.instructionObjs[base + -30] = new DoRetsub();
        Interpreter.instructionObjs[base + -4] = new DoPop();
        Interpreter.instructionObjs[base + -5] = new DoPopResult();
        Interpreter.instructionObjs[base + -1] = new DoDup();
        Interpreter.instructionObjs[base + -2] = new DoDup2();
        Interpreter.instructionObjs[base + -3] = new DoSwap();
        Interpreter.instructionObjs[base + 4] = new DoReturn();
        Interpreter.instructionObjs[base + 71] = new DoReturnResult();
        Interpreter.instructionObjs[base + -27] = new DoReturnUndef();
        Interpreter.instructionObjs[base + 27] = new DoBitNot();
        Interpreter.instructionObjs[base + 11] = new DoBitOp();
        Interpreter.instructionObjs[base + 9] = new DoBitOp();
        Interpreter.instructionObjs[base + 10] = new DoBitOp();
        Interpreter.instructionObjs[base + 18] = new DoBitOp();
        Interpreter.instructionObjs[base + 19] = new DoBitOp();
        Interpreter.instructionObjs[base + 20] = new DoUnsignedRightShift();
        Interpreter.instructionObjs[base + 28] = new DoPositive();
        Interpreter.instructionObjs[base + 29] = new DoNegative();
        Interpreter.instructionObjs[base + 21] = new DoAdd();
        Interpreter.instructionObjs[base + 22] = new DoArithmetic();
        Interpreter.instructionObjs[base + 23] = new DoArithmetic();
        Interpreter.instructionObjs[base + 24] = new DoArithmetic();
        Interpreter.instructionObjs[base + 25] = new DoArithmetic();
        Interpreter.instructionObjs[base + 83] = new DoArithmetic();
        Interpreter.instructionObjs[base + 26] = new DoNot();
        Interpreter.instructionObjs[base + 55] = new DoBindName();
        Interpreter.instructionObjs[base + 81] = new DoSetName();
        Interpreter.instructionObjs[base + 82] = new DoStringConcat();
        Interpreter.instructionObjs[base + 8] = new DoSetName();
        Interpreter.instructionObjs[base + -66] = new DoSetConst();
        Interpreter.instructionObjs[base + 31] = new DoDelName();
        Interpreter.instructionObjs[base + 0] = new DoDelName();
        Interpreter.instructionObjs[base + -86] = new DoDelPropSuper();
        Interpreter.instructionObjs[base + 34] = new DoGetPropNoWarn();
        Interpreter.instructionObjs[base + 33] = new DoGetProp();
        Interpreter.instructionObjs[base + 35] = new DoGetPropSuper();
        Interpreter.instructionObjs[base + 36] = new DoGetPropSuper();
        Interpreter.instructionObjs[base + 37] = new DoSetProp();
        Interpreter.instructionObjs[base + 38] = new DoSetPropSuper();
        Interpreter.instructionObjs[base + -9] = new DoPropIncDec();
        Interpreter.instructionObjs[base + 39] = new DoGetElem();
        Interpreter.instructionObjs[base + 40] = new DoGetElemSuper();
        Interpreter.instructionObjs[base + 41] = new DoSetElem();
        Interpreter.instructionObjs[base + 42] = new DoSetElemSuper();
        Interpreter.instructionObjs[base + -10] = new DoElemIncDec();
        Interpreter.instructionObjs[base + 74] = new DoGetRef();
        Interpreter.instructionObjs[base + 75] = new DoSetRef();
        Interpreter.instructionObjs[base + 76] = new DoDelRef();
        Interpreter.instructionObjs[base + -11] = new DoRefIncDec();
        Interpreter.instructionObjs[base + 60] = new DoLocalLoad();
        Interpreter.instructionObjs[base + -63] = new DoLocalClear();
        Interpreter.instructionObjs[base + -15] = new DoNameAndThis();
        Interpreter.instructionObjs[base + -19] = new DoNameAndThisOptional();
        Interpreter.instructionObjs[base + -16] = new DoPropAndThis();
        Interpreter.instructionObjs[base + -20] = new DoPropAndThisOptional();
        Interpreter.instructionObjs[base + -17] = new DoElemAndThis();
        Interpreter.instructionObjs[base + -21] = new DoElemAndThisOptional();
        Interpreter.instructionObjs[base + -18] = new DoValueAndThis();
        Interpreter.instructionObjs[base + -22] = new DoValueAndThisOptional();
        Interpreter.instructionObjs[base + -25] = new DoCallSpecial();
        Interpreter.instructionObjs[base + -26] = new DoCallSpecial();
        Interpreter.instructionObjs[base + 43] = new DoCallByteCode();
        Interpreter.instructionObjs[base + -85] = new DoCallByteCode();
        Interpreter.instructionObjs[base + -62] = new DoCallByteCode();
        Interpreter.instructionObjs[base + 77] = new DoCallByteCode();
        Interpreter.instructionObjs[base + 30] = new DoNew();
        Interpreter.instructionObjs[base + 32] = new DoTypeOf();
        Interpreter.instructionObjs[base + -14] = new DoTypeOfName();
        Interpreter.instructionObjs[base + 46] = new DoString();
        Interpreter.instructionObjs[base + -32] = new DoShortNumber();
        Interpreter.instructionObjs[base + -33] = new DoIntNumber();
        Interpreter.instructionObjs[base + 45] = new DoNumber();
        Interpreter.instructionObjs[base + 91] = new DoBigInt();
        Interpreter.instructionObjs[base + 44] = new DoName();
        Interpreter.instructionObjs[base + -8] = new DoNameIncDec();
        Interpreter.instructionObjs[base + -68] = new DoSetConstVar1();
        Interpreter.instructionObjs[base + -67] = new DoSetConstVar();
        Interpreter.instructionObjs[base + -56] = new DoSetVar1();
        Interpreter.instructionObjs[base + 62] = new DoSetVar();
        Interpreter.instructionObjs[base + -55] = new DoGetVar1();
        Interpreter.instructionObjs[base + 61] = new DoGetVar();
        Interpreter.instructionObjs[base + -7] = new DoVarIncDec();
        Interpreter.instructionObjs[base + -58] = new DoZero();
        Interpreter.instructionObjs[base + -59] = new DoOne();
        Interpreter.instructionObjs[base + 47] = new DoNull();
        Interpreter.instructionObjs[base + 49] = new DoThis();
        Interpreter.instructionObjs[base + 80] = new DoSuper();
        Interpreter.instructionObjs[base + 70] = new DoThisFunction();
        Interpreter.instructionObjs[base + 50] = new DoFalse();
        Interpreter.instructionObjs[base + 51] = new DoTrue();
        Interpreter.instructionObjs[base + -57] = new DoUndef();
        Interpreter.instructionObjs[base + 2] = new DoEnterWith();
        Interpreter.instructionObjs[base + 3] = new DoLeaveWith();
        Interpreter.instructionObjs[base + 63] = new DoCatchScope();
        Interpreter.instructionObjs[base + 64] = new DoEnumInit();
        Interpreter.instructionObjs[base + 65] = new DoEnumInit();
        Interpreter.instructionObjs[base + 66] = new DoEnumInit();
        Interpreter.instructionObjs[base + 67] = new DoEnumInit();
        Interpreter.instructionObjs[base + 67] = new DoEnumInit();
        Interpreter.instructionObjs[base + 68] = new DoEnumOp();
        Interpreter.instructionObjs[base + 69] = new DoEnumOp();
        Interpreter.instructionObjs[base + 78] = new DoRefSpecial();
        Interpreter.instructionObjs[base + 87] = new DoRefMember();
        Interpreter.instructionObjs[base + 88] = new DoRefNsMember();
        Interpreter.instructionObjs[base + 89] = new DoRefName();
        Interpreter.instructionObjs[base + 90] = new DoRefNsName();
        Interpreter.instructionObjs[base + -12] = new DoScopeLoad();
        Interpreter.instructionObjs[base + -13] = new DoScopeSave();
        Interpreter.instructionObjs[base + -87] = new DoSpread();
        Interpreter.instructionObjs[base + -23] = new DoClosureExpr();
        Interpreter.instructionObjs[base + -37] = new DoMethodExpr();
        Interpreter.instructionObjs[base + -24] = new DoClosureStatement();
        Interpreter.instructionObjs[base + 54] = new DoRegExp();
        Interpreter.instructionObjs[base + -81] = new DoTemplateLiteralCallSite();
        Interpreter.instructionObjs[base + -34] = new DoLiteralNewObject();
        Interpreter.instructionObjs[base + -35] = new DoLiteralNewArray();
        Interpreter.instructionObjs[base + -36] = new DoLiteralSet();
        Interpreter.instructionObjs[base + -64] = new DoLiteralGetter();
        Interpreter.instructionObjs[base + -65] = new DoLiteralSetter();
        Interpreter.instructionObjs[base + -82] = new DoLiteralKeySet();
        Interpreter.instructionObjs[base + 73] = new DoObjectLit();
        Interpreter.instructionObjs[base + 72] = new DoArrayLiteral();
        Interpreter.instructionObjs[base + -38] = new DoArrayLiteral();
        Interpreter.instructionObjs[base + -60] = new DoEnterDotQuery();
        Interpreter.instructionObjs[base + -61] = new DoLeaveDotQuery();
        Interpreter.instructionObjs[base + 84] = new DoDefaultNamespace();
        Interpreter.instructionObjs[base + 85] = new DoEscXMLAttr();
        Interpreter.instructionObjs[base + 86] = new DoEscXMLText();
        Interpreter.instructionObjs[base + -71] = new DoDebug();
        Interpreter.instructionObjs[base + -31] = new DoLineChange();
        Interpreter.instructionObjs[base + -39] = new DoIndexCn();
        Interpreter.instructionObjs[base + -40] = new DoIndexCn();
        Interpreter.instructionObjs[base + -41] = new DoIndexCn();
        Interpreter.instructionObjs[base + -42] = new DoIndexCn();
        Interpreter.instructionObjs[base + -43] = new DoIndexCn();
        Interpreter.instructionObjs[base + -44] = new DoIndexCn();
        Interpreter.instructionObjs[base + -45] = new DoRegIndex1();
        Interpreter.instructionObjs[base + -46] = new DoRegIndex2();
        Interpreter.instructionObjs[base + -47] = new DoRegIndex4();
        Interpreter.instructionObjs[base + -48] = new DoStringCn();
        Interpreter.instructionObjs[base + -49] = new DoStringCn();
        Interpreter.instructionObjs[base + -50] = new DoStringCn();
        Interpreter.instructionObjs[base + -51] = new DoStringCn();
        Interpreter.instructionObjs[base + -52] = new DoRegString1();
        Interpreter.instructionObjs[base + -53] = new DoRegString2();
        Interpreter.instructionObjs[base + -54] = new DoRegString4();
        Interpreter.instructionObjs[base + -74] = new DoBigIntCn();
        Interpreter.instructionObjs[base + -75] = new DoBigIntCn();
        Interpreter.instructionObjs[base + -76] = new DoBigIntCn();
        Interpreter.instructionObjs[base + -77] = new DoBigIntCn();
        Interpreter.instructionObjs[base + -78] = new DoRegBigInt1();
        Interpreter.instructionObjs[base + -79] = new DoRegBigInt2();
        Interpreter.instructionObjs[base + -80] = new DoRegBigInt4();
        DBL_MRK = UniqueTag.DOUBLE_MARK;
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -2843792508994958978L;
        final CallFrame parentFrame;
        final short frameIndex;
        final CallFrame previousInterpreterFrame;
        final int parentPC;
        boolean frozen;
        final ScriptOrFn<?> fnOrScript;
        final InterpreterData<?> idata;
        final Object[] stack;
        final byte[] stackAttributes;
        final double[] sDbl;
        final CallFrame varSource;
        final short emptyStackTop;
        final DebugFrame debuggerFrame;
        final boolean useActivation;
        boolean isContinuationsTopFrame;
        final Scriptable thisObj;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        CallFrame(Context cx, Scriptable thisObj, ScriptOrFn fnOrScript, InterpreterData code, CallFrame parentFrame, CallFrame previousInterpreterFrame) {
            this.idata = code;
            this.debuggerFrame = cx.debugger != null ? cx.debugger.getFrame(cx, fnOrScript.getDescriptor()) : null;
            this.useActivation = fnOrScript.getDescriptor().requiresActivationFrame();
            this.emptyStackTop = (short)(this.idata.itsMaxVars + this.idata.itsMaxLocals - 1);
            int maxFrameArray = this.idata.itsMaxFrameArray;
            if (maxFrameArray != this.emptyStackTop + this.idata.itsMaxStack + 1) {
                Kit.codeBug();
            }
            this.stack = new Object[maxFrameArray];
            this.stackAttributes = new byte[maxFrameArray];
            this.sDbl = new double[maxFrameArray];
            this.fnOrScript = fnOrScript;
            this.varSource = this;
            this.thisObj = thisObj;
            this.parentFrame = parentFrame;
            this.parentPC = parentFrame == null ? (previousInterpreterFrame == null ? -1 : previousInterpreterFrame.pcSourceLineStart) : parentFrame.pcSourceLineStart;
            this.previousInterpreterFrame = previousInterpreterFrame;
            this.frameIndex = (short)(parentFrame == null ? 0 : parentFrame.frameIndex + 1);
            if (this.frameIndex > cx.getMaximumInterpreterStackDepth()) {
                throw Context.reportRuntimeError("Exceeded maximum stack depth");
            }
            this.result = Undefined.instance;
            this.pcSourceLineStart = this.idata.firstLinePC;
            this.savedStackTop = this.emptyStackTop;
        }

        private CallFrame(CallFrame original, boolean makeOrphan) {
            this(original, makeOrphan ? null : original.parentFrame, makeOrphan ? null : original.previousInterpreterFrame);
        }

        private CallFrame(CallFrame original, CallFrame parentFrame, CallFrame previousInterpreterFrame) {
            if (!original.frozen) {
                Kit.codeBug();
            }
            this.stack = Arrays.copyOf(original.stack, original.stack.length);
            this.stackAttributes = Arrays.copyOf(original.stackAttributes, original.stackAttributes.length);
            this.sDbl = Arrays.copyOf(original.sDbl, original.sDbl.length);
            this.frozen = false;
            this.parentFrame = parentFrame;
            this.previousInterpreterFrame = previousInterpreterFrame;
            if (parentFrame == null) {
                this.frameIndex = 0;
                this.parentPC = previousInterpreterFrame == null ? -1 : previousInterpreterFrame.pcSourceLineStart;
            } else {
                this.frameIndex = original.frameIndex;
                this.parentPC = parentFrame.pcSourceLineStart;
            }
            this.fnOrScript = original.fnOrScript;
            this.idata = original.idata;
            this.varSource = original.varSource;
            this.emptyStackTop = original.emptyStackTop;
            this.debuggerFrame = original.debuggerFrame;
            this.useActivation = original.useActivation;
            this.isContinuationsTopFrame = original.isContinuationsTopFrame;
            this.thisObj = original.thisObj;
            this.result = original.result;
            this.resultDbl = original.resultDbl;
            this.pc = original.pc;
            this.pcPrevBranch = original.pcPrevBranch;
            this.pcSourceLineStart = original.pcSourceLineStart;
            this.scope = original.scope;
            this.savedStackTop = original.savedStackTop;
            this.savedCallOp = original.savedCallOp;
            this.throwable = original.throwable;
        }

        private CallFrame(CallFrame original, CallFrame parentFrame, CallFrame previousInterpreterFrame, boolean keepFrozen) {
            if (!original.frozen) {
                Kit.codeBug();
            }
            this.stack = original.stack;
            this.stackAttributes = original.stackAttributes;
            this.sDbl = original.sDbl;
            this.frozen = keepFrozen;
            this.parentFrame = parentFrame;
            this.previousInterpreterFrame = previousInterpreterFrame;
            if (parentFrame == null) {
                this.frameIndex = 0;
                this.parentPC = previousInterpreterFrame == null ? -1 : previousInterpreterFrame.pcSourceLineStart;
            } else {
                this.frameIndex = original.frameIndex;
                this.parentPC = parentFrame.pcSourceLineStart;
            }
            this.fnOrScript = original.fnOrScript;
            this.idata = original.idata;
            this.varSource = original.varSource;
            this.emptyStackTop = original.emptyStackTop;
            this.debuggerFrame = original.debuggerFrame;
            this.useActivation = original.useActivation;
            this.isContinuationsTopFrame = original.isContinuationsTopFrame;
            this.thisObj = original.thisObj;
            this.result = original.result;
            this.resultDbl = original.resultDbl;
            this.pc = original.pc;
            this.pcPrevBranch = original.pcPrevBranch;
            this.pcSourceLineStart = original.pcSourceLineStart;
            this.scope = original.scope;
            this.savedStackTop = original.savedStackTop;
            this.savedCallOp = original.savedCallOp;
            this.throwable = original.throwable;
        }

        void initializeArgs(Context cx, Scriptable callerScope, Object[] args, double[] argsDbl, Object[] boundArgs, int argShift, int argCount, Scriptable homeObject) {
            JSDescriptor<?> desc = this.fnOrScript.getDescriptor();
            if (this.useActivation) {
                if (argsDbl != null || boundArgs != null) {
                    int blen = boundArgs == null ? 0 : boundArgs.length;
                    args = Interpreter.getArgsArray(args, argsDbl, boundArgs, blen, argShift, argCount);
                }
                argShift = 0;
                argsDbl = null;
                boundArgs = null;
            }
            if (desc.getFunctionType() != 0) {
                this.scope = this.fnOrScript.getDeclarationScope();
                if (this.useActivation) {
                    this.scope = desc.getFunctionType() == 4 ? ScriptRuntime.createArrowFunctionActivation((JSFunction)this.fnOrScript, cx, this.scope, args, desc.isStrict(), desc.hasRestArg(), desc.requiresArgumentObject()) : ScriptRuntime.createFunctionActivation((JSFunction)this.fnOrScript, cx, this.scope, args, desc.isStrict(), desc.hasRestArg(), desc.requiresArgumentObject());
                }
            } else {
                this.scope = callerScope;
                ScriptRuntime.initScript(this.fnOrScript, this.thisObj, cx, this.scope, desc.isEvalFunction());
            }
            if (desc.getFunctionCount() != 0 && !desc.isES6Generator()) {
                if (desc.getFunctionType() != 0 && !desc.requiresActivationFrame()) {
                    Kit.codeBug();
                }
                for (int i = 0; i < desc.getFunctionCount(); ++i) {
                    DebuggableScript fdesc = desc.getFunction(i);
                    if (((JSDescriptor)fdesc).getFunctionType() != 1) continue;
                    Interpreter.initFunction(cx, this.scope, this.fnOrScript.getDescriptor(), i);
                }
            }
            int varCount = desc.getParamAndVarCount();
            for (int i = 0; i < varCount; ++i) {
                if (!desc.getParamOrVarConst(i)) continue;
                this.stackAttributes[i] = 13;
            }
            int definedArgs = desc.getParamCount();
            if (definedArgs > argCount) {
                definedArgs = argCount;
            }
            int blen = 0;
            if (boundArgs != null) {
                blen = Math.min(definedArgs, boundArgs.length);
                System.arraycopy(boundArgs, 0, this.stack, 0, blen);
            }
            System.arraycopy(args, argShift, this.stack, blen, definedArgs - blen);
            if (argsDbl != null) {
                System.arraycopy(argsDbl, argShift, this.sDbl, blen, definedArgs - blen);
            }
            for (int i = definedArgs; i != this.idata.itsMaxVars; ++i) {
                this.stack[i] = Undefined.instance;
            }
            if (desc.hasRestArg()) {
                Object[] vals;
                int offset = desc.getParamCount() - 1;
                if (argCount >= desc.getParamCount()) {
                    vals = new Object[argCount - offset];
                    argShift += offset;
                    for (int valsIdx = 0; valsIdx != vals.length; ++valsIdx) {
                        Object val = args[argShift];
                        if (val == UniqueTag.DOUBLE_MARK) {
                            val = ScriptRuntime.wrapNumber(argsDbl[argShift]);
                        }
                        vals[valsIdx] = val;
                        ++argShift;
                    }
                } else {
                    vals = ScriptRuntime.emptyArgs;
                }
                this.stack[offset] = cx.newArray(this.scope, vals);
            }
        }

        CallFrame cloneFrozen() {
            return new CallFrame(this, false);
        }

        CallFrame shallowCloneFrozen(CallFrame newPreviousInterpreeterFrame) {
            return new CallFrame(this, this.parentFrame, newPreviousInterpreeterFrame, true);
        }

        void syncStateToFrame(CallFrame otherFrame) {
            otherFrame.frozen = this.frozen;
            otherFrame.isContinuationsTopFrame = this.isContinuationsTopFrame;
            otherFrame.result = this.result;
            otherFrame.resultDbl = this.resultDbl;
            otherFrame.pc = this.pc;
            otherFrame.pcPrevBranch = this.pcPrevBranch;
            otherFrame.pcSourceLineStart = this.pcSourceLineStart;
            otherFrame.scope = this.scope;
            otherFrame.savedStackTop = this.savedStackTop;
            otherFrame.savedCallOp = this.savedCallOp;
            otherFrame.throwable = this.throwable;
        }

        public boolean equals(Object other) {
            if (other instanceof CallFrame) {
                try (Context cx = Context.enter();){
                    if (ScriptRuntime.hasTopCall(cx)) {
                        boolean bl = this.equalsInTopScope(other);
                        return bl;
                    }
                    Scriptable top = ScriptableObject.getTopLevelScope(this.scope);
                    boolean bl = (Boolean)ScriptRuntime.doTopCall((c, scope, thisObj) -> this.equalsInTopScope(other), cx, top, top, this.isStrictTopFrame());
                    return bl;
                }
            }
            return false;
        }

        public int hashCode() {
            int depth = 0;
            CallFrame f = this;
            int h = 0;
            do {
                h = 31 * (31 * h + f.pc) + f.idata.icodeHashCode();
            } while ((f = f.parentFrame) != null && depth++ < 8);
            return h;
        }

        private Boolean equalsInTopScope(Object other) {
            return EqualObjectGraphs.withThreadLocal(eq -> CallFrame.equals(this, (CallFrame)other, eq));
        }

        private boolean isStrictTopFrame() {
            CallFrame f = this;
            CallFrame p;
            while ((p = f.parentFrame) != null) {
                f = p;
            }
            return f.fnOrScript.getDescriptor().isStrict();
        }

        private static Boolean equals(CallFrame f1, CallFrame f2, EqualObjectGraphs equal) {
            while (f1 != f2) {
                if (f1 == null || f2 == null) {
                    return Boolean.FALSE;
                }
                if (!f1.fieldsEqual(f2, equal)) {
                    return Boolean.FALSE;
                }
                f1 = f1.parentFrame;
                f2 = f2.parentFrame;
            }
            return Boolean.TRUE;
        }

        private boolean fieldsEqual(CallFrame other, EqualObjectGraphs equal) {
            return this.frameIndex == other.frameIndex && this.pc == other.pc && Interpreter.compareDescs(this.fnOrScript.getDescriptor(), other.fnOrScript.getDescriptor()) && equal.equalGraphs(this.varSource.stack, other.varSource.stack) && Arrays.equals(this.varSource.sDbl, other.varSource.sDbl) && equal.equalGraphs(this.thisObj, other.thisObj) && equal.equalGraphs(this.fnOrScript, other.fnOrScript) && equal.equalGraphs(this.scope, other.scope);
        }

        CallFrame captureForGenerator() {
            return new CallFrame(this, true);
        }

        Object getFromVars(int offset) {
            Object value = this.stack[offset];
            if (value == UniqueTag.DOUBLE_MARK) {
                return this.sDbl[offset];
            }
            return value;
        }

        void setInVars(int offset, Object value) {
            if (value instanceof Double && Double.isFinite((Double)value)) {
                this.stack[offset] = UniqueTag.DOUBLE_MARK;
                this.sDbl[offset] = (Double)value;
            } else {
                this.stack[offset] = value;
            }
        }
    }

    private static class CompilationResult<T extends ScriptOrFn<T>> {
        private final JSDescriptor<T> descriptor;
        private final Scriptable homeObject;

        CompilationResult(JSDescriptor<T> descriptor, Scriptable homeObject) {
            this.descriptor = descriptor;
            this.homeObject = homeObject;
        }
    }

    static class GeneratorState {
        int operation;
        Object value;
        RuntimeException returnedException;

        GeneratorState(int operation, Object value) {
            this.operation = operation;
            this.value = value;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        private static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation c, CallFrame current) {
            this.capturedFrame = (CallFrame)c.getImplementation();
            if (this.capturedFrame == null || current == null) {
                this.branchFrame = null;
            } else {
                CallFrame chain1 = this.capturedFrame;
                CallFrame chain2 = current;
                int diff = chain1.frameIndex - chain2.frameIndex;
                if (diff != 0) {
                    if (diff < 0) {
                        chain1 = current;
                        chain2 = this.capturedFrame;
                        diff = -diff;
                    }
                    do {
                        chain1 = chain1.parentFrame;
                    } while (--diff != 0);
                    if (chain1.frameIndex != chain2.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (!Objects.equals(chain1, chain2) && chain1 != null) {
                    chain1 = chain1.parentFrame;
                    chain2 = chain2.parentFrame;
                }
                this.branchFrame = chain1;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    private static abstract class InterpreterResult
    extends NewState {
        private InterpreterResult() {
        }
    }

    private static class StateContinueResult
    extends InterpreterResult {
        private final CallFrame frame;
        private final int indexReg;

        private StateContinueResult(CallFrame frame, int indexReg) {
            this.frame = frame;
            this.indexReg = indexReg;
        }
    }

    private static class StateBreakResult
    extends InterpreterResult {
        private final CallFrame frame;

        private StateBreakResult(CallFrame frame) {
            this.frame = frame;
        }
    }

    private static class YieldResult
    extends InterpreterResult {
        private final Object yielding;

        private YieldResult(Object yielding) {
            this.yielding = yielding;
        }
    }

    private static class ThrowableResult
    extends InterpreterResult {
        private final CallFrame frame;
        private final Object throwable;

        private ThrowableResult(CallFrame frame, Object throwable) {
            this.frame = frame;
            this.throwable = throwable;
        }
    }

    private static class InterpreterState {
        int stackTop;
        int indexReg;
        BigInteger bigIntReg;
        String stringReg;
        final boolean instructionCounting;
        GeneratorState generatorState;
        Object throwable;

        InterpreterState(int stackTop, int indexReg, boolean instructionCounting) {
            this.stackTop = stackTop;
            this.indexReg = indexReg;
            this.instructionCounting = instructionCounting;
        }
    }

    private static abstract class InstructionClass {
        private InstructionClass() {
        }

        abstract NewState execute(Context var1, CallFrame var2, InterpreterState var3, int var4);
    }

    private static class NewState {
        private NewState() {
        }
    }

    private static class DebugScope
    implements Scriptable {
        private final CallFrame frame;
        private volatile Map<String, Integer> offsets;

        private DebugScope(CallFrame frame) {
            this.frame = frame;
        }

        private Map<String, Integer> getOffsets() {
            if (this.offsets == null) {
                this.offsets = DebugScope.buildOffsets(this.frame);
            }
            return this.offsets;
        }

        private static Map<String, Integer> buildOffsets(CallFrame frame) {
            JSDescriptor<?> desc = frame.fnOrScript.getDescriptor();
            int varCount = desc.getParamAndVarCount();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < varCount; ++i) {
                map.put(desc.getParamOrVarName(i), i);
            }
            return map;
        }

        @Override
        public void delete(String name) {
        }

        @Override
        public void delete(int index) {
        }

        @Override
        public Object get(String name, Scriptable start) {
            int offset = this.getOffsets().getOrDefault(name, -1);
            return offset >= 0 ? this.frame.getFromVars(offset) : NOT_FOUND;
        }

        @Override
        public Object get(int index, Scriptable start) {
            return NOT_FOUND;
        }

        @Override
        public String getClassName() {
            return "debugscope";
        }

        @Override
        public Object getDefaultValue(Class<?> hint) {
            return null;
        }

        @Override
        public Object[] getIds() {
            return this.getOffsets().keySet().toArray();
        }

        @Override
        public Scriptable getParentScope() {
            return this.frame.scope;
        }

        @Override
        public Scriptable getPrototype() {
            return null;
        }

        @Override
        public boolean has(String name, Scriptable start) {
            return this.getOffsets().containsKey(name);
        }

        @Override
        public boolean has(int index, Scriptable start) {
            return false;
        }

        @Override
        public boolean hasInstance(Scriptable instance) {
            return false;
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
            int offset = this.getOffsets().getOrDefault(name, -1);
            if (offset >= 0) {
                this.frame.setInVars(offset, value);
            }
        }

        @Override
        public void put(int index, Scriptable start, Object value) {
        }

        @Override
        public void setParentScope(Scriptable parent) {
        }

        @Override
        public void setPrototype(Scriptable prototype) {
        }
    }

    private static class DoGenerator
    extends InstructionClass {
        private DoGenerator() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (!frame.frozen) {
                DoGenerator.generatorCreate(cx, frame);
                return BREAK_LOOP;
            }
            if (!frame.frozen) {
                return new YieldResult(Interpreter.freezeGenerator(cx, frame, state, state.generatorState, op == -73));
            }
            Object obj = Interpreter.thawGenerator(frame, state, state.generatorState, op);
            if (obj != Scriptable.NOT_FOUND) {
                state.throwable = obj;
                return BREAK_WITHOUT_EXTENSION;
            }
            return null;
        }

        private static void generatorCreate(Context cx, CallFrame frame) {
            --frame.pc;
            CallFrame generatorFrame = Interpreter.captureFrameForGenerator(frame);
            generatorFrame.frozen = true;
            frame.result = cx.getLanguageVersion() >= 200 ? new ES6Generator(frame.scope, (JSFunction)generatorFrame.fnOrScript, generatorFrame) : new NativeGenerator(frame.scope, (JSFunction)generatorFrame.fnOrScript, generatorFrame);
        }
    }

    private static class DoYield
    extends InstructionClass {
        private DoYield() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (!frame.frozen) {
                return new YieldResult(Interpreter.freezeGenerator(cx, frame, state, state.generatorState, op == -73));
            }
            Object obj = Interpreter.thawGenerator(frame, state, state.generatorState, op);
            if (obj != Scriptable.NOT_FOUND) {
                state.throwable = obj;
                return BREAK_WITHOUT_EXTENSION;
            }
            return null;
        }
    }

    private static class DoGeneratorEnd
    extends InstructionClass {
        private DoGeneratorEnd() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.frozen = true;
            int sourceLine = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
            state.generatorState.returnedException = new JavaScriptException(NativeIterator.getStopIterationObject(frame.scope), frame.fnOrScript.getDescriptor().getSourceName(), sourceLine);
            return BREAK_LOOP;
        }
    }

    private static class DoGeneratorReturn
    extends InstructionClass {
        private DoGeneratorReturn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.frozen = true;
            frame.result = frame.stack[state.stackTop];
            frame.resultDbl = frame.sDbl[state.stackTop--];
            NativeIterator.StopIteration si = new NativeIterator.StopIteration(frame.result == UniqueTag.DOUBLE_MARK ? Double.valueOf(frame.resultDbl) : frame.result);
            int sourceLine = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
            state.generatorState.returnedException = new JavaScriptException(si, frame.fnOrScript.getDescriptor().getSourceName(), sourceLine);
            return BREAK_LOOP;
        }
    }

    private static class DoThrow
    extends InstructionClass {
        private DoThrow() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.throwable = DoThrow.throwObject(frame, frame.stack, frame.sDbl, frame.idata, frame.idata.itsICode, state);
            --state.stackTop;
            return BREAK_WITHOUT_EXTENSION;
        }

        private static Object throwObject(CallFrame frame, Object[] stack, double[] sDbl, InterpreterData iData, byte[] iCode, InterpreterState state) {
            Object value = stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            int sourceLine = Interpreter.getIndex(iCode, frame.pc);
            JavaScriptException throwable = new JavaScriptException(value, frame.fnOrScript.getDescriptor().getSourceName(), sourceLine);
            return throwable;
        }
    }

    private static class DoRethrow
    extends InstructionClass {
        private DoRethrow() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg += frame.idata.itsMaxVars;
            state.throwable = frame.stack[state.indexReg];
            return BREAK_WITHOUT_EXTENSION;
        }
    }

    private static class DoCompare
    extends InstructionClass {
        private DoCompare() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            block3: {
                stack = frame.stack;
                sDbl = frame.sDbl;
                rhs = stack[state.stackTop];
                if ((lhs = stack[--state.stackTop]) == UniqueTag.DOUBLE_MARK && rhs == UniqueTag.DOUBLE_MARK) {
                    valBln = ScriptRuntime.compareTo(sDbl[state.stackTop], sDbl[state.stackTop + 1], op);
                    stack[state.stackTop] = valBln;
                    return null;
                }
                if (rhs != UniqueTag.DOUBLE_MARK) break block3;
                rNum = sDbl[state.stackTop + 1];
                lNum /* !! */  = Interpreter.stack_numeric(frame, state.stackTop);
                ** GOTO lbl16
            }
            if (lhs == UniqueTag.DOUBLE_MARK) {
                rNum = ScriptRuntime.toNumeric(rhs);
                lNum /* !! */  = sDbl[state.stackTop];
lbl16:
                // 2 sources

                valBln = ScriptRuntime.compare(lNum /* !! */ , rNum, op);
            } else {
                valBln = ScriptRuntime.compare(lhs, rhs, op);
            }
            stack[state.stackTop] = valBln;
            return null;
        }
    }

    private static class DoInOrInstanceof
    extends InstructionClass {
        private DoInOrInstanceof() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object lhs;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            if ((lhs = stack[--state.stackTop]) == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            boolean valBln = op == 58 ? ScriptRuntime.in(lhs, rhs, cx) : ScriptRuntime.instanceOf(lhs, rhs, cx);
            stack[state.stackTop] = valBln;
            return null;
        }
    }

    private static class DoEquals
    extends InstructionClass {
        private DoEquals() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            boolean res = Interpreter.doEquals(state, stack, sDbl);
            stack[state.stackTop] = res;
            return null;
        }
    }

    private static class DoNotEquals
    extends InstructionClass {
        private DoNotEquals() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            boolean res = Interpreter.doEquals(state, stack, sDbl);
            stack[state.stackTop] = !res;
            return null;
        }
    }

    private static class DoShallowEquals
    extends InstructionClass {
        private DoShallowEquals() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            boolean res = Interpreter.doShallowEquals(state, stack, sDbl);
            stack[state.stackTop] = res;
            return null;
        }
    }

    private static class DoShallowNotEquals
    extends InstructionClass {
        private DoShallowNotEquals() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            boolean res = Interpreter.doShallowEquals(state, stack, sDbl);
            stack[state.stackTop] = !res;
            return null;
        }
    }

    private static class DoIfNE
    extends InstructionClass {
        private DoIfNE() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (Interpreter.stack_boolean(frame, state.stackTop--)) {
                frame.pc += 2;
                return null;
            }
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoIfEQ
    extends InstructionClass {
        private DoIfEQ() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (!Interpreter.stack_boolean(frame, state.stackTop--)) {
                frame.pc += 2;
                return null;
            }
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoIfEQPop
    extends InstructionClass {
        private DoIfEQPop() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (!Interpreter.stack_boolean(frame, state.stackTop--)) {
                frame.pc += 2;
                return null;
            }
            frame.stack[state.stackTop--] = null;
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoIfNullUndef
    extends InstructionClass {
        private DoIfNullUndef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object val = frame.stack[state.stackTop];
            --state.stackTop;
            if (val != null && !Undefined.isUndefined(val)) {
                frame.pc += 2;
                return null;
            }
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoIfNotNullUndef
    extends InstructionClass {
        private DoIfNotNullUndef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object val = frame.stack[state.stackTop];
            --state.stackTop;
            if (val == null || Undefined.isUndefined(val)) {
                frame.pc += 2;
                return null;
            }
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoGoto
    extends InstructionClass {
        private DoGoto() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoGosub
    extends InstructionClass {
        private DoGosub() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            frame.sDbl[state.stackTop] = frame.pc + 2;
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoStartSub
    extends InstructionClass {
        private DoStartSub() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            InterpreterData<?> iData = frame.idata;
            if (state.stackTop == frame.emptyStackTop + 1) {
                state.indexReg += iData.itsMaxVars;
                stack[state.indexReg] = stack[state.stackTop];
                sDbl[state.indexReg] = sDbl[state.stackTop];
                --state.stackTop;
            } else if (state.stackTop != frame.emptyStackTop) {
                Kit.codeBug();
            }
            return null;
        }
    }

    private static class DoRetsub
    extends InstructionClass {
        private DoRetsub() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (state.instructionCounting) {
                Interpreter.addInstructionCount(cx, frame, 0);
            }
            state.indexReg += frame.idata.itsMaxVars;
            Object value = frame.stack[state.indexReg];
            if (value != UniqueTag.DOUBLE_MARK) {
                state.throwable = value;
                return BREAK_WITHOUT_EXTENSION;
            }
            frame.pc = (int)frame.sDbl[state.indexReg];
            if (state.instructionCounting) {
                frame.pcPrevBranch = frame.pc;
            }
            return null;
        }
    }

    private static class DoPop
    extends InstructionClass {
        private DoPop() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            stack[state.stackTop] = null;
            --state.stackTop;
            return null;
        }
    }

    private static class DoPopResult
    extends InstructionClass {
        private DoPopResult() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            frame.result = stack[state.stackTop];
            frame.resultDbl = sDbl[state.stackTop];
            stack[state.stackTop] = null;
            --state.stackTop;
            return null;
        }
    }

    private static class DoDup
    extends InstructionClass {
        private DoDup() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            stack[state.stackTop + 1] = stack[state.stackTop];
            sDbl[state.stackTop + 1] = sDbl[state.stackTop];
            ++state.stackTop;
            return null;
        }
    }

    private static class DoDup2
    extends InstructionClass {
        private DoDup2() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            stack[state.stackTop + 1] = stack[state.stackTop - 1];
            sDbl[state.stackTop + 1] = sDbl[state.stackTop - 1];
            stack[state.stackTop + 2] = stack[state.stackTop];
            sDbl[state.stackTop + 2] = sDbl[state.stackTop];
            state.stackTop += 2;
            return null;
        }
    }

    private static class DoSwap
    extends InstructionClass {
        private DoSwap() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object o = stack[state.stackTop];
            stack[state.stackTop] = stack[state.stackTop - 1];
            stack[state.stackTop - 1] = o;
            double d = sDbl[state.stackTop];
            sDbl[state.stackTop] = sDbl[state.stackTop - 1];
            sDbl[state.stackTop - 1] = d;
            return null;
        }
    }

    private static class DoReturn
    extends InstructionClass {
        private DoReturn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            frame.result = stack[state.stackTop];
            frame.resultDbl = sDbl[state.stackTop];
            --state.stackTop;
            return BREAK_LOOP;
        }
    }

    private static class DoReturnResult
    extends InstructionClass {
        private DoReturnResult() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            return BREAK_LOOP;
        }
    }

    private static class DoReturnUndef
    extends InstructionClass {
        private DoReturnUndef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.result = undefined;
            return BREAK_LOOP;
        }
    }

    private static class DoBitNot
    extends InstructionClass {
        private DoBitNot() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Number value = Interpreter.stack_numeric(frame, state.stackTop);
            Number result = ScriptRuntime.bitwiseNOT(value);
            if (result instanceof BigInteger) {
                stack[state.stackTop] = result;
            } else {
                stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[state.stackTop] = result.doubleValue();
            }
            return null;
        }
    }

    private static class DoBitOp
    extends InstructionClass {
        private DoBitOp() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            if (stack[state.stackTop] == UniqueTag.DOUBLE_MARK && stack[state.stackTop - 1] == UniqueTag.DOUBLE_MARK) {
                DoBitOp.doFastBitOp(cx, frame, state, op);
                return null;
            }
            Number lValue = Interpreter.stack_numeric(frame, state.stackTop - 1);
            Number rValue = Interpreter.stack_numeric(frame, state.stackTop);
            --state.stackTop;
            Number result = null;
            switch (op) {
                case 11: {
                    result = ScriptRuntime.bitwiseAND(lValue, rValue);
                    break;
                }
                case 9: {
                    result = ScriptRuntime.bitwiseOR(lValue, rValue);
                    break;
                }
                case 10: {
                    result = ScriptRuntime.bitwiseXOR(lValue, rValue);
                    break;
                }
                case 18: {
                    result = ScriptRuntime.leftShift(lValue, rValue);
                    break;
                }
                case 19: {
                    result = ScriptRuntime.signedRightShift(lValue, rValue);
                }
            }
            if (result instanceof BigInteger) {
                stack[state.stackTop] = result;
            } else {
                stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[state.stackTop] = result.doubleValue();
            }
            return null;
        }

        private static NewState doFastBitOp(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            double lValue = sDbl[state.stackTop - 1];
            double rValue = sDbl[state.stackTop];
            --state.stackTop;
            double result = 0.0;
            switch (op) {
                case 11: {
                    result = ScriptRuntime.bitwiseAND(lValue, rValue);
                    break;
                }
                case 9: {
                    result = ScriptRuntime.bitwiseOR(lValue, rValue);
                    break;
                }
                case 10: {
                    result = ScriptRuntime.bitwiseXOR(lValue, rValue);
                    break;
                }
                case 18: {
                    result = ScriptRuntime.leftShift(lValue, rValue);
                    break;
                }
                case 19: {
                    result = ScriptRuntime.signedRightShift(lValue, rValue);
                }
            }
            stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[state.stackTop] = result;
            return null;
        }
    }

    private static class DoUnsignedRightShift
    extends InstructionClass {
        private DoUnsignedRightShift() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            double lDbl = Interpreter.stack_double(frame, state.stackTop - 1);
            int rIntValue = Interpreter.stack_int32(frame, state.stackTop) & 0x1F;
            stack[--state.stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[state.stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
            return null;
        }
    }

    private static class DoPositive
    extends InstructionClass {
        private DoPositive() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            double rDbl = Interpreter.stack_double(frame, state.stackTop);
            stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[state.stackTop] = rDbl;
            return null;
        }
    }

    private static class DoNegative
    extends InstructionClass {
        private DoNegative() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Number rNum = Interpreter.stack_numeric(frame, state.stackTop);
            Number rNegNum = ScriptRuntime.negate(rNum);
            if (rNegNum instanceof BigInteger) {
                stack[state.stackTop] = rNegNum;
            } else {
                stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[state.stackTop] = rNegNum.doubleValue();
            }
            return null;
        }
    }

    private static class DoAdd
    extends InstructionClass {
        private DoAdd() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            boolean leftRightOrder;
            double d;
            Object rhs = frame.stack[state.stackTop];
            Object lhs = frame.stack[--state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                d = frame.sDbl[state.stackTop + 1];
                if (lhs == UniqueTag.DOUBLE_MARK) {
                    int n = state.stackTop;
                    frame.sDbl[n] = frame.sDbl[n] + d;
                    return null;
                }
                leftRightOrder = true;
            } else if (lhs == UniqueTag.DOUBLE_MARK) {
                d = frame.sDbl[state.stackTop];
                lhs = rhs;
                leftRightOrder = false;
            } else {
                if (lhs instanceof Scriptable || rhs instanceof Scriptable) {
                    frame.stack[state.stackTop] = ScriptRuntime.add(lhs, rhs, cx);
                } else if (lhs instanceof CharSequence) {
                    frame.stack[state.stackTop] = rhs instanceof CharSequence ? new ConsString((CharSequence)lhs, (CharSequence)rhs) : new ConsString((CharSequence)lhs, ScriptRuntime.toCharSequence(rhs));
                } else if (rhs instanceof CharSequence) {
                    frame.stack[state.stackTop] = new ConsString(ScriptRuntime.toCharSequence(lhs), (CharSequence)rhs);
                } else {
                    Number rNum;
                    Number lNum = lhs instanceof Number ? (Number)((Number)lhs) : (Number)ScriptRuntime.toNumeric(lhs);
                    Number number = rNum = rhs instanceof Number ? (Number)((Number)rhs) : (Number)ScriptRuntime.toNumeric(rhs);
                    if (lNum instanceof BigInteger && rNum instanceof BigInteger) {
                        frame.stack[state.stackTop] = ((BigInteger)lNum).add((BigInteger)rNum);
                    } else {
                        if (lNum instanceof BigInteger || rNum instanceof BigInteger) {
                            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
                        }
                        frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                        frame.sDbl[state.stackTop] = lNum.doubleValue() + rNum.doubleValue();
                    }
                }
                return null;
            }
            if (lhs instanceof Scriptable) {
                rhs = ScriptRuntime.wrapNumber(d);
                if (!leftRightOrder) {
                    Object tmp = lhs;
                    lhs = rhs;
                    rhs = tmp;
                }
                frame.stack[state.stackTop] = ScriptRuntime.add(lhs, rhs, cx);
            } else if (lhs instanceof CharSequence) {
                String rstr = ScriptRuntime.numberToString(d, 10);
                frame.stack[state.stackTop] = leftRightOrder ? new ConsString((CharSequence)lhs, rstr) : new ConsString(rstr, (CharSequence)lhs);
            } else {
                Number lNum;
                Number number = lNum = lhs instanceof Number ? (Number)((Number)lhs) : (Number)ScriptRuntime.toNumeric(lhs);
                if (lNum instanceof BigInteger) {
                    throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
                }
                frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                frame.sDbl[state.stackTop] = lNum.doubleValue() + d;
            }
            return null;
        }
    }

    private static class DoArithmetic
    extends InstructionClass {
        private DoArithmetic() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            if (stack[state.stackTop] == UniqueTag.DOUBLE_MARK && stack[state.stackTop - 1] == UniqueTag.DOUBLE_MARK) {
                DoArithmetic.doFastArithemtic(cx, frame, state, op);
                return null;
            }
            Number lNum = Interpreter.stack_numeric(frame, state.stackTop - 1);
            Number rNum = Interpreter.stack_numeric(frame, state.stackTop);
            --state.stackTop;
            Number result = null;
            switch (op) {
                case 22: {
                    result = ScriptRuntime.subtract(lNum, rNum);
                    break;
                }
                case 23: {
                    result = ScriptRuntime.multiply(lNum, rNum);
                    break;
                }
                case 24: {
                    result = ScriptRuntime.divide(lNum, rNum);
                    break;
                }
                case 25: {
                    result = ScriptRuntime.remainder(lNum, rNum);
                    break;
                }
                case 83: {
                    result = ScriptRuntime.exponentiate(lNum, rNum);
                }
            }
            if (result instanceof BigInteger) {
                stack[state.stackTop] = result;
            } else {
                stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                sDbl[state.stackTop] = result.doubleValue();
            }
            return null;
        }

        private static NewState doFastArithemtic(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            double lNum = sDbl[state.stackTop - 1];
            double rNum = sDbl[state.stackTop];
            --state.stackTop;
            double result = 0.0;
            switch (op) {
                case 22: {
                    result = lNum - rNum;
                    break;
                }
                case 23: {
                    result = lNum * rNum;
                    break;
                }
                case 24: {
                    result = lNum / rNum;
                    break;
                }
                case 25: {
                    result = lNum % rNum;
                    break;
                }
                case 83: {
                    result = Math.pow(lNum, rNum);
                }
            }
            stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            sDbl[state.stackTop] = result;
            return null;
        }
    }

    private static class DoNot
    extends InstructionClass {
        private DoNot() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            stack[state.stackTop] = !Interpreter.stack_boolean(frame, state.stackTop);
            return null;
        }
    }

    private static class DoBindName
    extends InstructionClass {
        private DoBindName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            stack[++state.stackTop] = ScriptRuntime.bind(cx, frame.scope, state.stringReg);
            return null;
        }
    }

    private static class DoSetName
    extends InstructionClass {
        private DoSetName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            Scriptable lhs = (Scriptable)stack[state.stackTop - 1];
            stack[state.stackTop - 1] = op == 8 ? ScriptRuntime.setName(lhs, rhs, cx, frame.scope, state.stringReg) : ScriptRuntime.strictSetName(lhs, rhs, cx, frame.scope, state.stringReg);
            --state.stackTop;
            return null;
        }
    }

    private static class DoStringConcat
    extends InstructionClass {
        private DoStringConcat() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object rhs = frame.stack[state.stackTop];
            Object lhs = frame.stack[state.stackTop - 1];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop - 1]);
            }
            frame.stack[state.stackTop - 1] = ScriptRuntime.concat(lhs, rhs);
            --state.stackTop;
            return null;
        }
    }

    private static class DoSetConst
    extends InstructionClass {
        private DoSetConst() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            Scriptable lhs = (Scriptable)stack[state.stackTop - 1];
            stack[state.stackTop - 1] = ScriptRuntime.setConst(lhs, rhs, cx, state.stringReg);
            --state.stackTop;
            return null;
        }
    }

    private static class DoDelName
    extends InstructionClass {
        private DoDelName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object rhs = frame.stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object lhs = frame.stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.delete(lhs, rhs, cx, frame.scope, op == 0);
            return null;
        }
    }

    private static class DoDelPropSuper
    extends InstructionClass {
        private DoDelPropSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            --state.stackTop;
            stack[state.stackTop] = Boolean.FALSE;
            ScriptRuntime.throwDeleteOnSuperPropertyNotAllowed();
            return null;
        }
    }

    private static class DoGetPropNoWarn
    extends InstructionClass {
        private DoGetPropNoWarn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getObjectPropNoWarn(lhs, state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoGetProp
    extends InstructionClass {
        private DoGetProp() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getObjectProp(lhs, state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoGetPropSuper
    extends InstructionClass {
        private DoGetPropSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            Object superObject = stack[state.stackTop];
            if (superObject == UniqueTag.DOUBLE_MARK) {
                Kit.codeBug();
            }
            stack[state.stackTop] = ScriptRuntime.getSuperProp(superObject, state.stringReg, cx, frame.scope, frame.thisObj, op == 36);
            return null;
        }
    }

    private static class DoSetProp
    extends InstructionClass {
        private DoSetProp() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object lhs;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            if ((lhs = stack[state.stackTop - 1]) == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop - 1]);
            }
            stack[--state.stackTop] = ScriptRuntime.setObjectProp(lhs, state.stringReg, rhs, cx, frame.scope);
            return null;
        }
    }

    private static class DoSetPropSuper
    extends InstructionClass {
        private DoSetPropSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object superObject;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            if ((superObject = stack[state.stackTop - 1]) == UniqueTag.DOUBLE_MARK) {
                Kit.codeBug();
            }
            stack[--state.stackTop] = ScriptRuntime.setSuperProp(superObject, state.stringReg, rhs, cx, frame.scope, frame.thisObj);
            return null;
        }
    }

    private static class DoPropIncDec
    extends InstructionClass {
        private DoPropIncDec() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            byte[] iCode = frame.idata.itsICode;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.propIncrDecr(lhs, state.stringReg, cx, frame.scope, iCode[frame.pc]);
            ++frame.pc;
            return null;
        }
    }

    private static class DoGetElem
    extends InstructionClass {
        private DoGetElem() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value;
            Object id;
            Object lhs;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            if ((lhs = stack[--state.stackTop]) == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            if ((id = stack[state.stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.getObjectElem(lhs, id, cx, frame.scope);
            } else {
                double d = sDbl[state.stackTop + 1];
                value = ScriptRuntime.getObjectIndex(lhs, d, cx, frame.scope);
            }
            stack[state.stackTop] = value;
            return null;
        }
    }

    private static class DoGetElemSuper
    extends InstructionClass {
        private DoGetElemSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value;
            Object id;
            Object superObject;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            if ((superObject = stack[--state.stackTop]) == UniqueTag.DOUBLE_MARK) {
                Kit.codeBug();
            }
            if ((id = stack[state.stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.getSuperElem(superObject, id, cx, frame.scope, frame.thisObj);
            } else {
                double d = sDbl[state.stackTop + 1];
                value = ScriptRuntime.getSuperIndex(superObject, d, cx, frame.scope, frame.thisObj);
            }
            stack[state.stackTop] = value;
            return null;
        }
    }

    private static class DoSetElem
    extends InstructionClass {
        private DoSetElem() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value;
            Object id;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            state.stackTop -= 2;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            if ((id = stack[state.stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.setObjectElem(lhs, id, rhs, cx, frame.scope);
            } else {
                double d = sDbl[state.stackTop + 1];
                value = ScriptRuntime.setObjectIndex(lhs, d, rhs, cx, frame.scope);
            }
            stack[state.stackTop] = value;
            return null;
        }
    }

    private static class DoSetElemSuper
    extends InstructionClass {
        private DoSetElemSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value;
            Object id;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            state.stackTop -= 2;
            Object superObject = stack[state.stackTop];
            if (superObject == UniqueTag.DOUBLE_MARK) {
                Kit.codeBug();
            }
            if ((id = stack[state.stackTop + 1]) != UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.setSuperElem(superObject, id, rhs, cx, frame.scope, frame.thisObj);
            } else {
                double d = sDbl[state.stackTop + 1];
                value = ScriptRuntime.setSuperIndex(superObject, d, rhs, cx, frame.scope, frame.thisObj);
            }
            stack[state.stackTop] = value;
            return null;
        }
    }

    private static class DoElemIncDec
    extends InstructionClass {
        private DoElemIncDec() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            byte[] iCode = frame.idata.itsICode;
            Object rhs = stack[state.stackTop];
            if (rhs == UniqueTag.DOUBLE_MARK) {
                rhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.elemIncrDecr(lhs, rhs, cx, frame.scope, iCode[frame.pc]);
            ++frame.pc;
            return null;
        }
    }

    private static class DoGetRef
    extends InstructionClass {
        private DoGetRef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            Ref ref = (Ref)stack[state.stackTop];
            stack[state.stackTop] = ScriptRuntime.refGet(ref, cx);
            return null;
        }
    }

    private static class DoSetRef
    extends InstructionClass {
        private DoSetRef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object value = stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            Ref ref = (Ref)stack[state.stackTop - 1];
            stack[--state.stackTop] = ScriptRuntime.refSet(ref, value, cx, frame.scope);
            return null;
        }
    }

    private static class DoDelRef
    extends InstructionClass {
        private DoDelRef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            Ref ref = (Ref)stack[state.stackTop];
            stack[state.stackTop] = ScriptRuntime.refDel(ref, cx);
            return null;
        }
    }

    private static class DoRefIncDec
    extends InstructionClass {
        private DoRefIncDec() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            byte[] iCode = frame.idata.itsICode;
            Ref ref = (Ref)stack[state.stackTop];
            stack[state.stackTop] = ScriptRuntime.refIncrDecr(ref, cx, frame.scope, iCode[frame.pc]);
            ++frame.pc;
            return null;
        }
    }

    private static class DoLocalLoad
    extends InstructionClass {
        private DoLocalLoad() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            InterpreterData<?> iData = frame.idata;
            ++state.stackTop;
            state.indexReg += iData.itsMaxVars;
            stack[state.stackTop] = stack[state.indexReg];
            sDbl[state.stackTop] = sDbl[state.indexReg];
            return null;
        }
    }

    private static class DoLocalClear
    extends InstructionClass {
        private DoLocalClear() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            InterpreterData<?> iData = frame.idata;
            state.indexReg += iData.itsMaxVars;
            stack[state.indexReg] = null;
            return null;
        }
    }

    private static class DoNameAndThis
    extends InstructionClass {
        private DoNameAndThis() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            stack[++state.stackTop] = ScriptRuntime.getNameAndThis(state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoNameAndThisOptional
    extends InstructionClass {
        private DoNameAndThisOptional() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            stack[++state.stackTop] = ScriptRuntime.getNameAndThisOptional(state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoPropAndThis
    extends InstructionClass {
        private DoPropAndThis() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object obj = stack[state.stackTop];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getPropAndThis(obj, state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoPropAndThisOptional
    extends InstructionClass {
        private DoPropAndThisOptional() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object obj = stack[state.stackTop];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getPropAndThisOptional(obj, state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoElemAndThis
    extends InstructionClass {
        private DoElemAndThis() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object id;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object obj = stack[state.stackTop - 1];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(sDbl[state.stackTop - 1]);
            }
            if ((id = stack[state.stackTop]) == UniqueTag.DOUBLE_MARK) {
                id = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[--state.stackTop] = ScriptRuntime.getElemAndThis(obj, id, cx, frame.scope);
            return null;
        }
    }

    private static class DoElemAndThisOptional
    extends InstructionClass {
        private DoElemAndThisOptional() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object id;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object obj = stack[state.stackTop - 1];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(sDbl[state.stackTop - 1]);
            }
            if ((id = stack[state.stackTop]) == UniqueTag.DOUBLE_MARK) {
                id = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[--state.stackTop] = ScriptRuntime.getElemAndThisOptional(obj, id, cx, frame.scope);
            return null;
        }
    }

    private static class DoValueAndThis
    extends InstructionClass {
        private DoValueAndThis() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object value = stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getValueAndThis(value, cx);
            return null;
        }
    }

    private static class DoValueAndThisOptional
    extends InstructionClass {
        private DoValueAndThisOptional() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object value = stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.getValueAndThisOptional(value, cx);
            return null;
        }
    }

    private static class DoCallSpecial
    extends InstructionClass {
        private DoCallSpecial() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            boolean isOptionalChainingCall;
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            byte[] iCode = frame.idata.itsICode;
            boolean bl = isOptionalChainingCall = op == -26;
            if (state.instructionCounting) {
                cx.instructionCount += 100;
            }
            int callType = iCode[frame.pc] & 0xFF;
            boolean isNew = iCode[frame.pc + 1] != 0;
            int sourceLine = Interpreter.getIndex(iCode, frame.pc + 2);
            if (isNew) {
                state.stackTop -= state.indexReg;
                Object function = stack[state.stackTop];
                if (function == UniqueTag.DOUBLE_MARK) {
                    function = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
                }
                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, state.stackTop + 1, state.indexReg);
                stack[state.stackTop] = ScriptRuntime.newSpecial(cx, function, outArgs, frame.scope, callType);
            } else {
                state.stackTop -= state.indexReg;
                ScriptRuntime.LookupResult result = (ScriptRuntime.LookupResult)stack[state.stackTop];
                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, state.stackTop + 1, state.indexReg);
                Callable function = result.getCallable();
                stack[state.stackTop] = ScriptRuntime.callSpecial(cx, function, result.getThis(), outArgs, frame.scope, frame.thisObj, callType, frame.fnOrScript.getDescriptor().getSourceName(), sourceLine, isOptionalChainingCall);
            }
            frame.pc += 4;
            return null;
        }
    }

    private static class DoCallByteCode
    extends InstructionClass {
        private DoCallByteCode() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            BaseFunction ifun;
            Scriptable calleeScope;
            Scriptable funHomeObj;
            Scriptable funThisObj;
            Callable fun;
            int blen;
            Object[] boundArgs;
            double[] sDbl;
            Object[] stack;
            block22: {
                stack = frame.stack;
                sDbl = frame.sDbl;
                boundArgs = null;
                blen = 0;
                if (state.instructionCounting) {
                    cx.instructionCount += 100;
                }
                state.stackTop -= state.indexReg;
                ScriptRuntime.LookupResult result = (ScriptRuntime.LookupResult)stack[state.stackTop];
                fun = result.getCallable();
                funThisObj = result.getThis();
                Scriptable scriptable = funHomeObj = fun instanceof BaseFunction ? ((BaseFunction)fun).getHomeObject() : null;
                if (op == -85) {
                    funThisObj = frame.thisObj;
                }
                if (op == 77) {
                    Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, state.stackTop + 1, state.indexReg);
                    stack[state.stackTop] = ScriptRuntime.callRef(fun, funThisObj, outArgs, cx);
                    return null;
                }
                calleeScope = frame.scope;
                if (frame.useActivation) {
                    calleeScope = ScriptableObject.getTopLevelScope(frame.scope);
                }
                while (true) {
                    if (fun instanceof KnownBuiltInFunction) {
                        KnownBuiltInFunction kfun = (KnownBuiltInFunction)fun;
                        if (BaseFunction.isApplyOrCall(kfun)) {
                            fun = ScriptRuntime.getCallable(funThisObj);
                            funThisObj = Interpreter.getApplyThis(cx, stack, sDbl, boundArgs, state.stackTop + 1, state.indexReg, (Function)fun, frame);
                            if (BaseFunction.isApply(kfun)) {
                                Object[] callArgs = blen > 1 ? ScriptRuntime.getApplyArguments(cx, boundArgs[1]) : (state.indexReg < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments(cx, stack[state.stackTop - blen + 2]));
                                int alen = callArgs.length;
                                boundArgs = callArgs;
                                blen = alen;
                                state.indexReg = alen;
                                continue;
                            }
                            if (state.indexReg <= 0) continue;
                            if (state.indexReg > 1 && blen == 0) {
                                System.arraycopy(stack, state.stackTop + 2, stack, state.stackTop + 1, state.indexReg - 1);
                                System.arraycopy(sDbl, state.stackTop + 2, sDbl, state.stackTop + 1, state.indexReg - 1);
                            } else if (state.indexReg > 1) {
                                Object[] newBArgs = new Object[boundArgs.length - 1];
                                System.arraycopy(boundArgs, 1, newBArgs, 0, boundArgs.length - 1);
                                boundArgs = newBArgs;
                                blen = newBArgs.length;
                            } else {
                                boundArgs = new Object[]{};
                                blen = 0;
                            }
                            --state.indexReg;
                            continue;
                        }
                        break block22;
                    }
                    if (fun instanceof LambdaConstructor || fun instanceof LambdaFunction) break block22;
                    if (fun instanceof BoundFunction) {
                        BoundFunction bfun = (BoundFunction)fun;
                        fun = bfun.getTargetFunction();
                        funThisObj = bfun.getCallThis(cx, calleeScope);
                        Object[] bArgs = bfun.getBoundArgs();
                        boundArgs = Interpreter.addBoundArgs(boundArgs, bArgs);
                        blen += bArgs.length;
                        state.indexReg += bArgs.length;
                        continue;
                    }
                    if (!(fun instanceof ScriptRuntime.NoSuchMethodShim)) break;
                    ScriptRuntime.NoSuchMethodShim nsmfun = (ScriptRuntime.NoSuchMethodShim)fun;
                    Object[] elements = Interpreter.getArgsArray(stack, sDbl, boundArgs, blen, state.stackTop + 1, state.indexReg);
                    fun = nsmfun.noSuchMethodMethod;
                    boundArgs = new Object[2];
                    blen = 2;
                    boundArgs[0] = nsmfun.methodName;
                    boundArgs[1] = cx.newArray(calleeScope, elements);
                    state.indexReg = 2;
                }
                if (fun == null) {
                    throw ScriptRuntime.notFunctionError(null, null);
                }
            }
            if (fun instanceof JSFunction && ((JSFunction)fun).getDescriptor().getCode() instanceof InterpreterData) {
                ifun = (JSFunction)fun;
                JSDescriptor<JSFunction> desc = ((JSFunction)ifun).getDescriptor();
                InterpreterData idata = (InterpreterData)desc.getCode();
                if (frame.fnOrScript.getDescriptor().getSecurityDomain() == desc.getSecurityDomain()) {
                    CallFrame callParentFrame = frame;
                    if (op == -62) {
                        callParentFrame = frame.parentFrame;
                        Interpreter.exitFrame(cx, frame, null);
                    }
                    CallFrame calleeFrame = Interpreter.initFrame(cx, calleeScope, ((JSFunction)ifun).getFunctionThis(funThisObj), funHomeObj, stack, sDbl, boundArgs, state.stackTop + 1, state.indexReg, (ScriptOrFn)((Object)ifun), idata, callParentFrame);
                    if (op != -62) {
                        frame.savedStackTop = state.stackTop;
                        frame.savedCallOp = op;
                    }
                    return new StateContinueResult(calleeFrame, state.indexReg);
                }
            }
            if (fun instanceof NativeContinuation) {
                ContinuationJump cjump = new ContinuationJump((NativeContinuation)fun, frame);
                if (state.indexReg == 0) {
                    cjump.result = undefined;
                } else {
                    cjump.result = stack[state.stackTop + 1];
                    cjump.resultDbl = sDbl[state.stackTop + 1];
                }
                state.throwable = cjump;
                return BREAK_WITHOUT_EXTENSION;
            }
            if (fun instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor((IdFunctionObject)(ifun = (IdFunctionObject)fun))) {
                frame.stack[state.stackTop] = Interpreter.captureContinuation(cx, frame.parentFrame, false);
                return null;
            }
            frame.savedCallOp = op;
            frame.savedStackTop = state.stackTop;
            stack[state.stackTop] = fun.call(cx, calleeScope, funThisObj, Interpreter.getArgsArray(stack, sDbl, boundArgs, blen, state.stackTop + 1, state.indexReg));
            return null;
        }
    }

    private static class DoNew
    extends InstructionClass {
        private DoNew() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            IdFunctionObject ifun;
            if (state.instructionCounting) {
                cx.instructionCount += 100;
            }
            state.stackTop -= state.indexReg;
            Object lhs = frame.stack[state.stackTop];
            if (lhs instanceof JSFunction && ((JSFunction)lhs).getConstructor() instanceof InterpreterData) {
                JSFunction f = (JSFunction)lhs;
                JSDescriptor<JSFunction> desc = f.getDescriptor();
                InterpreterData idata = (InterpreterData)desc.getConstructor();
                if (frame.fnOrScript.getDescriptor().getSecurityDomain() == desc.getSecurityDomain()) {
                    if (cx.getLanguageVersion() >= 200 && f.getHomeObject() != null) {
                        throw ScriptRuntime.typeErrorById("msg.not.ctor", f.getFunctionName());
                    }
                    Scriptable newInstance = f.getHomeObject() == null ? f.createObject(cx, frame.scope) : null;
                    CallFrame calleeFrame = Interpreter.initFrame(cx, frame.scope, newInstance, newInstance, frame.stack, frame.sDbl, null, state.stackTop + 1, state.indexReg, f, idata, frame);
                    frame.stack[state.stackTop] = newInstance;
                    frame.savedStackTop = state.stackTop;
                    frame.savedCallOp = op;
                    return new StateContinueResult(calleeFrame, state.indexReg);
                }
            }
            if (!(lhs instanceof Constructable)) {
                if (lhs == UniqueTag.DOUBLE_MARK) {
                    lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
                }
                throw ScriptRuntime.notFunctionError(lhs);
            }
            Constructable ctor = (Constructable)lhs;
            if (ctor instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor(ifun = (IdFunctionObject)ctor)) {
                frame.stack[state.stackTop] = Interpreter.captureContinuation(cx, frame.parentFrame, false);
                return null;
            }
            Object[] outArgs = Interpreter.getArgsArray(frame.stack, frame.sDbl, state.stackTop + 1, state.indexReg);
            frame.stack[state.stackTop] = ctor.construct(cx, frame.scope, outArgs);
            return null;
        }
    }

    private static class DoTypeOf
    extends InstructionClass {
        private DoTypeOf() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] stack = frame.stack;
            double[] sDbl = frame.sDbl;
            Object lhs = stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(sDbl[state.stackTop]);
            }
            stack[state.stackTop] = ScriptRuntime.typeof(lhs);
            return null;
        }
    }

    private static class DoTypeOfName
    extends InstructionClass {
        private DoTypeOfName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = ScriptRuntime.typeofName(frame.scope, state.stringReg);
            return null;
        }
    }

    private static class DoString
    extends InstructionClass {
        private DoString() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = state.stringReg;
            return null;
        }
    }

    private static class DoShortNumber
    extends InstructionClass {
        private DoShortNumber() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            frame.sDbl[state.stackTop] = Interpreter.getShort(frame.idata.itsICode, frame.pc);
            frame.pc += 2;
            return null;
        }
    }

    private static class DoIntNumber
    extends InstructionClass {
        private DoIntNumber() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            frame.sDbl[state.stackTop] = Interpreter.getInt(frame.idata.itsICode, frame.pc);
            frame.pc += 4;
            return null;
        }
    }

    private static class DoNumber
    extends InstructionClass {
        private DoNumber() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
            frame.sDbl[state.stackTop] = frame.idata.itsDoubleTable[state.indexReg];
            return null;
        }
    }

    private static class DoBigInt
    extends InstructionClass {
        private DoBigInt() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = state.bigIntReg;
            return null;
        }
    }

    private static class DoName
    extends InstructionClass {
        private DoName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = ScriptRuntime.name(cx, frame.scope, state.stringReg);
            return null;
        }
    }

    private static class DoNameIncDec
    extends InstructionClass {
        private DoNameIncDec() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = ScriptRuntime.nameIncrDecr(frame.scope, state.stringReg, cx, frame.idata.itsICode[frame.pc]);
            ++frame.pc;
            return null;
        }
    }

    private static class DoSetConstVar1
    extends InstructionClass {
        private DoSetConstVar1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = frame.idata.itsICode[frame.pc++];
            byte[] varAttributes = frame.varSource.stackAttributes;
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            if ((varAttributes[state.indexReg] & 1) == 0) {
                throw Context.reportRuntimeErrorById("msg.var.redecl", frame.fnOrScript.getDescriptor().getParamOrVarName(state.indexReg));
            }
            if ((varAttributes[state.indexReg] & 8) != 0) {
                vars[state.indexReg] = frame.stack[state.stackTop];
                int n = state.indexReg;
                varAttributes[n] = (byte)(varAttributes[n] & 0xFFFFFFF7);
                varDbls[state.indexReg] = frame.sDbl[state.stackTop];
            }
            return null;
        }
    }

    private static class DoSetConstVar
    extends InstructionClass {
        private DoSetConstVar() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            byte[] varAttributes = frame.varSource.stackAttributes;
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            if ((varAttributes[state.indexReg] & 1) == 0) {
                throw Context.reportRuntimeErrorById("msg.var.redecl", frame.fnOrScript.getDescriptor().getParamOrVarName(state.indexReg));
            }
            if ((varAttributes[state.indexReg] & 8) != 0) {
                vars[state.indexReg] = frame.stack[state.stackTop];
                int n = state.indexReg;
                varAttributes[n] = (byte)(varAttributes[n] & 0xFFFFFFF7);
                varDbls[state.indexReg] = frame.sDbl[state.stackTop];
            }
            return null;
        }
    }

    private static class DoSetVar1
    extends InstructionClass {
        private DoSetVar1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = frame.idata.itsICode[frame.pc++];
            byte[] varAttributes = frame.varSource.stackAttributes;
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            if ((varAttributes[state.indexReg] & 1) == 0) {
                vars[state.indexReg] = frame.stack[state.stackTop];
                varDbls[state.indexReg] = frame.sDbl[state.stackTop];
            }
            return null;
        }
    }

    private static class DoSetVar
    extends InstructionClass {
        private DoSetVar() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            byte[] varAttributes = frame.varSource.stackAttributes;
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            if ((varAttributes[state.indexReg] & 1) == 0) {
                vars[state.indexReg] = frame.stack[state.stackTop];
                varDbls[state.indexReg] = frame.sDbl[state.stackTop];
            }
            return null;
        }
    }

    private static class DoGetVar1
    extends InstructionClass {
        private DoGetVar1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = frame.idata.itsICode[frame.pc++];
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            ++state.stackTop;
            frame.stack[state.stackTop] = vars[state.indexReg];
            frame.sDbl[state.stackTop] = varDbls[state.indexReg];
            return null;
        }
    }

    private static class DoGetVar
    extends InstructionClass {
        private DoGetVar() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            ++state.stackTop;
            frame.stack[state.stackTop] = vars[state.indexReg];
            frame.sDbl[state.stackTop] = varDbls[state.indexReg];
            return null;
        }
    }

    private static class DoVarIncDec
    extends InstructionClass {
        private DoVarIncDec() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            byte[] varAttributes = frame.varSource.stackAttributes;
            Object[] vars = frame.varSource.stack;
            double[] varDbls = frame.varSource.sDbl;
            ++state.stackTop;
            byte incrDecrMask = frame.idata.itsICode[frame.pc];
            Object varValue = vars[state.indexReg];
            double d = 0.0;
            BigInteger bi = null;
            if (varValue == UniqueTag.DOUBLE_MARK) {
                d = varDbls[state.indexReg];
            } else {
                Number num = ScriptRuntime.toNumeric(varValue);
                if (num instanceof BigInteger) {
                    bi = (BigInteger)num;
                } else {
                    d = num.doubleValue();
                }
            }
            if (bi == null) {
                boolean post;
                double d2 = (incrDecrMask & 1) == 0 ? d + 1.0 : d - 1.0;
                boolean bl = post = (incrDecrMask & 2) != 0;
                if ((varAttributes[state.indexReg] & 1) == 0) {
                    if (varValue != UniqueTag.DOUBLE_MARK) {
                        vars[state.indexReg] = UniqueTag.DOUBLE_MARK;
                    }
                    varDbls[state.indexReg] = d2;
                    frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                    frame.sDbl[state.stackTop] = post ? d : d2;
                } else if (post && varValue != UniqueTag.DOUBLE_MARK) {
                    frame.stack[state.stackTop] = varValue;
                } else {
                    frame.stack[state.stackTop] = UniqueTag.DOUBLE_MARK;
                    frame.sDbl[state.stackTop] = post ? d : d2;
                }
            } else {
                boolean post;
                BigInteger result = (incrDecrMask & 1) == 0 ? bi.add(BigInteger.ONE) : bi.subtract(BigInteger.ONE);
                boolean bl = post = (incrDecrMask & 2) != 0;
                if ((varAttributes[state.indexReg] & 1) == 0) {
                    vars[state.indexReg] = result;
                    frame.stack[state.stackTop] = post ? bi : result;
                } else {
                    frame.stack[state.stackTop] = post && varValue != UniqueTag.DOUBLE_MARK ? varValue : (post ? bi : result);
                }
            }
            ++frame.pc;
            return null;
        }
    }

    private static class DoZero
    extends InstructionClass {
        private DoZero() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = 0;
            return null;
        }
    }

    private static class DoOne
    extends InstructionClass {
        private DoOne() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++state.stackTop;
            frame.stack[state.stackTop] = 1;
            return null;
        }
    }

    private static class DoNull
    extends InstructionClass {
        private DoNull() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = null;
            return null;
        }
    }

    private static class DoThis
    extends InstructionClass {
        private DoThis() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = frame.thisObj;
            return null;
        }
    }

    private static class DoSuper
    extends InstructionClass {
        private DoSuper() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Scriptable homeObject = frame.fnOrScript.getHomeObject();
            frame.stack[++state.stackTop] = homeObject == null ? Undefined.instance : homeObject.getPrototype();
            return null;
        }
    }

    private static class DoThisFunction
    extends InstructionClass {
        private DoThisFunction() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = frame.fnOrScript;
            return null;
        }
    }

    private static class DoFalse
    extends InstructionClass {
        private DoFalse() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = Boolean.FALSE;
            return null;
        }
    }

    private static class DoTrue
    extends InstructionClass {
        private DoTrue() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = Boolean.TRUE;
            return null;
        }
    }

    private static class DoUndef
    extends InstructionClass {
        private DoUndef() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.stack[++state.stackTop] = undefined;
            return null;
        }
    }

    private static class DoEnterWith
    extends InstructionClass {
        private DoEnterWith() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object lhs = frame.stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.scope = ScriptRuntime.enterWith(lhs, cx, frame.scope);
            --state.stackTop;
            return null;
        }
    }

    private static class DoLeaveWith
    extends InstructionClass {
        private DoLeaveWith() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.scope = ScriptRuntime.leaveWith(frame.scope);
            return null;
        }
    }

    private static class DoCatchScope
    extends InstructionClass {
        private DoCatchScope() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            --state.stackTop;
            state.indexReg += frame.idata.itsMaxVars;
            boolean afterFirstScope = frame.idata.itsICode[frame.pc] != 0;
            Throwable caughtException = (Throwable)frame.stack[state.stackTop + 1];
            Scriptable lastCatchScope = !afterFirstScope ? null : (Scriptable)frame.stack[state.indexReg];
            frame.stack[state.indexReg] = ScriptRuntime.newCatchScope(caughtException, lastCatchScope, state.stringReg, cx, frame.scope);
            ++frame.pc;
            return null;
        }
    }

    private static class DoEnumInit
    extends InstructionClass {
        private DoEnumInit() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object lhs = frame.stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            state.indexReg += frame.idata.itsMaxVars;
            int enumType = op == 64 ? 0 : (op == 65 ? 1 : (op == 67 ? 6 : 2));
            frame.stack[state.indexReg] = ScriptRuntime.enumInit(lhs, cx, frame.scope, enumType);
            --state.stackTop;
            return null;
        }
    }

    private static class DoEnumOp
    extends InstructionClass {
        private DoEnumOp() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg += frame.idata.itsMaxVars;
            Object val = frame.stack[state.indexReg];
            frame.stack[++state.stackTop] = op == 68 ? ScriptRuntime.enumNext(val, cx) : ScriptRuntime.enumId(val, cx);
            return null;
        }
    }

    private static class DoRefSpecial
    extends InstructionClass {
        private DoRefSpecial() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object obj = frame.stack[state.stackTop];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.specialRef(obj, state.stringReg, cx, frame.scope);
            return null;
        }
    }

    private static class DoRefMember
    extends InstructionClass {
        private DoRefMember() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object elem = frame.stack[state.stackTop];
            if (elem == UniqueTag.DOUBLE_MARK) {
                elem = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object obj = frame.stack[state.stackTop];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.memberRef(obj, elem, cx, state.indexReg);
            return null;
        }
    }

    private static class DoRefNsMember
    extends InstructionClass {
        private DoRefNsMember() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object elem = frame.stack[state.stackTop];
            if (elem == UniqueTag.DOUBLE_MARK) {
                elem = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object ns = frame.stack[state.stackTop];
            if (ns == UniqueTag.DOUBLE_MARK) {
                ns = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object obj = frame.stack[state.stackTop];
            if (obj == UniqueTag.DOUBLE_MARK) {
                obj = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.memberRef(obj, ns, elem, cx, state.indexReg);
            return null;
        }
    }

    private static class DoRefName
    extends InstructionClass {
        private DoRefName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object name = frame.stack[state.stackTop];
            if (name == UniqueTag.DOUBLE_MARK) {
                name = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.nameRef(name, cx, frame.scope, state.indexReg);
            return null;
        }
    }

    private static class DoRefNsName
    extends InstructionClass {
        private DoRefNsName() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object name = frame.stack[state.stackTop];
            if (name == UniqueTag.DOUBLE_MARK) {
                name = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            Object ns = frame.stack[state.stackTop];
            if (ns == UniqueTag.DOUBLE_MARK) {
                ns = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.nameRef(ns, name, cx, frame.scope, state.indexReg);
            return null;
        }
    }

    private static class DoScopeLoad
    extends InstructionClass {
        private DoScopeLoad() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg += frame.idata.itsMaxVars;
            frame.scope = (Scriptable)frame.stack[state.indexReg];
            return null;
        }
    }

    private static class DoScopeSave
    extends InstructionClass {
        private DoScopeSave() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg += frame.idata.itsMaxVars;
            frame.stack[state.indexReg] = frame.scope;
            return null;
        }
    }

    private static class DoSpread
    extends InstructionClass {
        private DoSpread() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object source = frame.stack[state.stackTop];
            --state.stackTop;
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            if (store.hasSkipIndexes()) {
                int sourcePos = 0xFF & frame.idata.itsICode[frame.pc];
                ++frame.pc;
                store.spread(cx, frame.scope, source, sourcePos);
            } else {
                store.spread(cx, frame.scope, source, 0);
            }
            return null;
        }
    }

    private static class DoClosureExpr
    extends InstructionClass {
        private DoClosureExpr() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            JSFunction fn = Interpreter.createClosure(cx, frame, state.indexReg);
            frame.stack[++state.stackTop] = fn;
            return null;
        }
    }

    private static class DoMethodExpr
    extends InstructionClass {
        private DoMethodExpr() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Scriptable homeObject = (Scriptable)frame.stack[state.stackTop - 1];
            JSFunction fn = Interpreter.createMethod(cx, frame, state.indexReg, homeObject);
            frame.stack[++state.stackTop] = fn;
            return null;
        }
    }

    private static class DoClosureStatement
    extends InstructionClass {
        private DoClosureStatement() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Interpreter.initFunction(cx, frame.scope, frame.fnOrScript.getDescriptor(), state.indexReg);
            return null;
        }
    }

    private static class DoRegExp
    extends InstructionClass {
        private DoRegExp() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object re = frame.idata.itsRegExpLiterals[state.indexReg];
            frame.stack[++state.stackTop] = ScriptRuntime.wrapRegExp(cx, frame.scope, re);
            return null;
        }
    }

    private static class DoTemplateLiteralCallSite
    extends InstructionClass {
        private DoTemplateLiteralCallSite() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object[] templateLiterals = frame.idata.itsTemplateLiterals;
            frame.stack[++state.stackTop] = ScriptRuntime.getTemplateLiteralCallSite(cx, frame.scope, templateLiterals, state.indexReg);
            return null;
        }
    }

    private static class DoLiteralNewObject
    extends InstructionClass {
        private DoLiteralNewObject() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            ++frame.pc;
            ++state.stackTop;
            frame.stack[state.stackTop] = cx.newObject(frame.scope);
            ++state.stackTop;
            if (state.indexReg < 0) {
                frame.stack[state.stackTop] = NewLiteralStorage.create(cx, -state.indexReg - 1, true);
            } else {
                Object[] ids = (Object[])frame.idata.literalIds[state.indexReg];
                boolean copyArray = frame.idata.itsICode[frame.pc] != 0;
                frame.stack[state.stackTop] = NewLiteralStorage.create(cx, copyArray ? Arrays.copyOf(ids, ids.length) : ids);
            }
            return null;
        }
    }

    private static class DoLiteralNewArray
    extends InstructionClass {
        private DoLiteralNewArray() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            NewLiteralStorage storage = NewLiteralStorage.create(cx, state.indexReg, false);
            int skipIdx = 0xFF & frame.idata.itsICode[frame.pc];
            ++frame.pc;
            if (skipIdx > 0) {
                storage.setSkipIndexes((int[])frame.idata.literalIds[skipIdx - 1]);
            }
            frame.stack[++state.stackTop] = storage;
            return null;
        }
    }

    private static class DoLiteralSet
    extends InstructionClass {
        private DoLiteralSet() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            store.pushValue(value);
            return null;
        }
    }

    private static class DoLiteralGetter
    extends InstructionClass {
        private DoLiteralGetter() {
        }

        @Override
        NewState execute(Context cs, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            --state.stackTop;
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            store.pushGetter(value);
            return null;
        }
    }

    private static class DoLiteralSetter
    extends InstructionClass {
        private DoLiteralSetter() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            --state.stackTop;
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            store.pushSetter(value);
            return null;
        }
    }

    private static class DoLiteralKeySet
    extends InstructionClass {
        private DoLiteralKeySet() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object key = frame.stack[state.stackTop];
            if (key == UniqueTag.DOUBLE_MARK) {
                key = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            --state.stackTop;
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            store.pushKey(key);
            return null;
        }
    }

    private static class DoObjectLit
    extends InstructionClass {
        private DoObjectLit() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            --state.stackTop;
            Scriptable object = (Scriptable)frame.stack[state.stackTop];
            ScriptRuntime.fillObjectLiteral(object, store.getKeys(), store.getValues(), store.getGetterSetters(), cx, frame.scope);
            return null;
        }
    }

    private static class DoArrayLiteral
    extends InstructionClass {
        private DoArrayLiteral() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            NewLiteralStorage store = (NewLiteralStorage)frame.stack[state.stackTop];
            int[] skipIndexes = null;
            if (op == -38 && (skipIndexes = store.getAdjustedSkipIndexes()) == null) {
                skipIndexes = (int[])frame.idata.literalIds[state.indexReg];
            }
            frame.stack[state.stackTop] = ScriptRuntime.newArrayLiteral(store.getValues(), skipIndexes, cx, frame.scope);
            return null;
        }
    }

    private static class DoEnterDotQuery
    extends InstructionClass {
        private DoEnterDotQuery() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object lhs = frame.stack[state.stackTop];
            if (lhs == UniqueTag.DOUBLE_MARK) {
                lhs = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.scope = ScriptRuntime.enterDotQuery(lhs, frame.scope);
            --state.stackTop;
            return null;
        }
    }

    private static class DoLeaveDotQuery
    extends InstructionClass {
        private DoLeaveDotQuery() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            boolean valBln = Interpreter.stack_boolean(frame, state.stackTop);
            Object x = ScriptRuntime.updateDotQuery(valBln, frame.scope);
            if (x != null) {
                frame.stack[state.stackTop] = x;
                frame.scope = ScriptRuntime.leaveDotQuery(frame.scope);
                frame.pc += 2;
                return null;
            }
            --state.stackTop;
            return BREAK_JUMPLESSRUN;
        }
    }

    private static class DoDefaultNamespace
    extends InstructionClass {
        private DoDefaultNamespace() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            if (value == UniqueTag.DOUBLE_MARK) {
                value = ScriptRuntime.wrapNumber(frame.sDbl[state.stackTop]);
            }
            frame.stack[state.stackTop] = ScriptRuntime.setDefaultNamespace(value, cx);
            return null;
        }
    }

    private static class DoEscXMLAttr
    extends InstructionClass {
        private DoEscXMLAttr() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            if (value != UniqueTag.DOUBLE_MARK) {
                frame.stack[state.stackTop] = ScriptRuntime.escapeAttributeValue(value, cx);
            }
            return null;
        }
    }

    private static class DoEscXMLText
    extends InstructionClass {
        private DoEscXMLText() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            Object value = frame.stack[state.stackTop];
            if (value != UniqueTag.DOUBLE_MARK) {
                frame.stack[state.stackTop] = ScriptRuntime.escapeTextValue(value, cx);
            }
            return null;
        }
    }

    private static class DoDebug
    extends InstructionClass {
        private DoDebug() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            if (frame.debuggerFrame != null) {
                frame.debuggerFrame.onDebuggerStatement(cx);
            }
            return null;
        }
    }

    private static class DoLineChange
    extends InstructionClass {
        private DoLineChange() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            frame.pcSourceLineStart = frame.pc;
            if (frame.debuggerFrame != null) {
                int line = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
                frame.debuggerFrame.onLineChange(cx, line);
            }
            frame.pc += 2;
            return null;
        }
    }

    private static class DoIndexCn
    extends InstructionClass {
        private DoIndexCn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = -39 - op;
            return null;
        }
    }

    private static class DoRegIndex1
    extends InstructionClass {
        private DoRegIndex1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = 0xFF & frame.idata.itsICode[frame.pc];
            ++frame.pc;
            return null;
        }
    }

    private static class DoRegIndex2
    extends InstructionClass {
        private DoRegIndex2() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = Interpreter.getIndex(frame.idata.itsICode, frame.pc);
            frame.pc += 2;
            return null;
        }
    }

    private static class DoRegIndex4
    extends InstructionClass {
        private DoRegIndex4() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.indexReg = Interpreter.getInt(frame.idata.itsICode, frame.pc);
            frame.pc += 4;
            return null;
        }
    }

    private static class DoStringCn
    extends InstructionClass {
        private DoStringCn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.stringReg = frame.idata.itsStringTable[-48 - op];
            return null;
        }
    }

    private static class DoRegString1
    extends InstructionClass {
        private DoRegString1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.stringReg = frame.idata.itsStringTable[0xFF & frame.idata.itsICode[frame.pc]];
            ++frame.pc;
            return null;
        }
    }

    private static class DoRegString2
    extends InstructionClass {
        private DoRegString2() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.stringReg = frame.idata.itsStringTable[Interpreter.getIndex(frame.idata.itsICode, frame.pc)];
            frame.pc += 2;
            return null;
        }
    }

    private static class DoRegString4
    extends InstructionClass {
        private DoRegString4() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.stringReg = frame.idata.itsStringTable[Interpreter.getInt(frame.idata.itsICode, frame.pc)];
            frame.pc += 4;
            return null;
        }
    }

    private static class DoBigIntCn
    extends InstructionClass {
        private DoBigIntCn() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.bigIntReg = frame.idata.itsBigIntTable[-74 - op];
            return null;
        }
    }

    private static class DoRegBigInt1
    extends InstructionClass {
        private DoRegBigInt1() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.bigIntReg = frame.idata.itsBigIntTable[0xFF & frame.idata.itsICode[frame.pc]];
            ++frame.pc;
            return null;
        }
    }

    private static class DoRegBigInt2
    extends InstructionClass {
        private DoRegBigInt2() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.bigIntReg = frame.idata.itsBigIntTable[Interpreter.getIndex(frame.idata.itsICode, frame.pc)];
            frame.pc += 2;
            return null;
        }
    }

    private static class DoRegBigInt4
    extends InstructionClass {
        private DoRegBigInt4() {
        }

        @Override
        NewState execute(Context cx, CallFrame frame, InterpreterState state, int op) {
            state.bigIntReg = frame.idata.itsBigIntTable[Interpreter.getInt(frame.idata.itsICode, frame.pc)];
            frame.pc += 4;
            return null;
        }
    }
}

