/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.concurrent.locks.StampedLock;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.HashSlotMap;
import org.mozilla.javascript.LockAwareSlotMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.SlotMapOwner;

class ThreadSafeHashSlotMap
extends HashSlotMap
implements LockAwareSlotMap {
    private final StampedLock lock;

    public ThreadSafeHashSlotMap() {
        this.lock = new StampedLock();
    }

    public ThreadSafeHashSlotMap(int capacity) {
        super(capacity);
        this.lock = new StampedLock();
    }

    public ThreadSafeHashSlotMap(StampedLock lock, SlotMap oldMap) {
        super(oldMap.dirtySize());
        this.lock = lock;
        for (Slot n : oldMap) {
            this.addWithLock(null, n.copySlot());
        }
    }

    public ThreadSafeHashSlotMap(StampedLock lock, SlotMap oldMap, Slot newSlot) {
        super(oldMap.dirtySize() + 1);
        this.lock = lock;
        for (Slot n : oldMap) {
            this.addWithLock(null, n.copySlot());
        }
        this.addWithLock(null, newSlot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long stamp = this.lock.tryOptimisticRead();
        int s = super.size();
        if (this.lock.validate(stamp)) {
            return s;
        }
        stamp = this.lock.readLock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @Override
    public int dirtySize() {
        assert (this.lock.isReadLocked() || this.lock.isWriteLocked());
        return super.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.lock.tryOptimisticRead();
        boolean e = super.isEmpty();
        if (this.lock.validate(stamp)) {
            return e;
        }
        stamp = this.lock.readLock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
        long stamp = this.lock.writeLock();
        try {
            Slot slot = super.modify(owner, key, index, attributes);
            return slot;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap mutableMap, Object key, int index, SlotMap.SlotComputer<S> c) {
        long stamp = this.lock.writeLock();
        try {
            S s = super.compute(owner, mutableMap, key, index, c);
            return s;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot query(Object key, int index) {
        long stamp = this.lock.tryOptimisticRead();
        Slot s = super.query(key, index);
        if (this.lock.validate(stamp)) {
            return s;
        }
        stamp = this.lock.readLock();
        try {
            Slot slot = super.query(key, index);
            return slot;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SlotMapOwner owner, Slot newSlot) {
        long stamp = this.lock.writeLock();
        try {
            super.add(owner, newSlot);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void addWithLock(SlotMapOwner owner, Slot newSlot) {
        super.add(owner, newSlot);
    }

    @Override
    public <S extends Slot> S computeWithLock(SlotMapOwner owner, CompoundOperationMap mutableMap, Object key, int index, SlotMap.SlotComputer<S> compute) {
        return super.compute(owner, mutableMap, key, index, compute);
    }

    @Override
    public boolean isEmptyWithLock() {
        return super.isEmpty();
    }

    @Override
    public Slot modifyWithLock(SlotMapOwner owner, Object key, int index, int attributes) {
        return super.modify(owner, key, index, attributes);
    }

    @Override
    public Slot queryWithLock(Object key, int index) {
        return super.query(key, index);
    }

    @Override
    public int sizeWithLock() {
        return super.size();
    }

    @Override
    public long getReadLock() {
        return this.lock.readLock();
    }

    @Override
    public long getWriteLock() {
        return this.lock.writeLock();
    }

    @Override
    public void releaseLock(long stamp) {
        this.lock.unlock(stamp);
    }
}

