/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.lc.type;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.lc.type.ParameterizedTypeInfo;
import org.mozilla.javascript.lc.type.TypeInfo;
import org.mozilla.javascript.lc.type.VariableTypeInfo;
import org.mozilla.javascript.lc.type.impl.factory.WeakReferenceFactory;

public interface TypeInfoFactory
extends Serializable {
    public static final TypeInfoFactory GLOBAL = new WeakReferenceFactory(){

        private Object readResolve() {
            return GLOBAL;
        }
    };
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];

    public TypeInfo create(Class<?> var1);

    public TypeInfo create(GenericArrayType var1);

    public TypeInfo create(TypeVariable<?> var1);

    public TypeInfo create(ParameterizedType var1);

    public TypeInfo create(WildcardType var1);

    public TypeInfo toArray(TypeInfo var1);

    public TypeInfo attachParam(TypeInfo var1, List<TypeInfo> var2);

    default public TypeInfo attachParam(TypeInfo base, TypeInfo ... params) {
        return this.attachParam(base, Arrays.asList(params));
    }

    default public Map<VariableTypeInfo, TypeInfo> getConsolidationMapping(Class<?> from) {
        return Map.of();
    }

    default public TypeInfo consolidateType(TypeInfo type, TypeInfo consolidateHint) {
        type = type.consolidate(this.getConsolidationMapping(consolidateHint.asClass()));
        if (consolidateHint instanceof ParameterizedTypeInfo) {
            type = type.consolidate(((ParameterizedTypeInfo)consolidateHint).extractConsolidationMapping(this));
        }
        return type;
    }

    public static List<TypeInfo> consolidateAll(List<TypeInfo> types, Map<VariableTypeInfo, TypeInfo> mapping) {
        if (mapping.isEmpty()) {
            return types;
        }
        int size = types.size();
        if (size == 0) {
            return List.of();
        }
        if (size == 1) {
            TypeInfo consolidated;
            TypeInfo type = types.get(0);
            return type == (consolidated = type.consolidate(mapping)) ? types : List.of(consolidated);
        }
        ArrayList<TypeInfo> consolidatedTypes = new ArrayList<TypeInfo>(types.size());
        for (TypeInfo type : types) {
            consolidatedTypes.add(type.consolidate(mapping));
        }
        return consolidatedTypes;
    }

    public static Map<VariableTypeInfo, TypeInfo> transformMapping(Map<VariableTypeInfo, TypeInfo> mapping, Map<VariableTypeInfo, TypeInfo> transformer) {
        if (mapping.isEmpty()) {
            return Map.of();
        }
        if (mapping.size() == 1) {
            Map.Entry<VariableTypeInfo, TypeInfo> entry = mapping.entrySet().iterator().next();
            return Map.of(entry.getKey(), entry.getValue().consolidate(transformer));
        }
        HashMap<VariableTypeInfo, TypeInfo> transformed = new HashMap<VariableTypeInfo, TypeInfo>(mapping);
        for (Map.Entry<VariableTypeInfo, TypeInfo> entry : transformed.entrySet()) {
            entry.setValue(entry.getValue().consolidate(transformer));
        }
        return transformed;
    }

    default public TypeInfo create(Type type) {
        if (type instanceof Class) {
            return this.create((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.create((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.create((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this.create((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return this.create((WildcardType)type);
        }
        return TypeInfo.NONE;
    }

    default public <T extends Type> TypeInfo[] createArray(T[] types) {
        if (types.length == 0) {
            return EMPTY_ARRAY;
        }
        int len = types.length;
        TypeInfo[] arr = new TypeInfo[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.create((Type)types[i]);
        }
        return arr;
    }

    default public <T extends Type> List<TypeInfo> createList(T[] types) {
        switch (types.length) {
            case 0: {
                return List.of();
            }
            case 1: {
                return List.of(this.create((Type)types[0]));
            }
            case 2: {
                return List.of(this.create((Type)types[0]), this.create((Type)types[1]));
            }
        }
        return Collections.unmodifiableList(Arrays.asList(this.createArray((Type[])types)));
    }

    public static TypeInfo matchPredefined(Class<?> clazz) {
        if (clazz == null) {
            return TypeInfo.NONE;
        }
        if (clazz == Object.class) {
            return TypeInfo.OBJECT;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return TypeInfo.PRIMITIVE_VOID;
            }
            if (clazz == Boolean.TYPE) {
                return TypeInfo.PRIMITIVE_BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return TypeInfo.PRIMITIVE_BYTE;
            }
            if (clazz == Short.TYPE) {
                return TypeInfo.PRIMITIVE_SHORT;
            }
            if (clazz == Integer.TYPE) {
                return TypeInfo.PRIMITIVE_INT;
            }
            if (clazz == Long.TYPE) {
                return TypeInfo.PRIMITIVE_LONG;
            }
            if (clazz == Float.TYPE) {
                return TypeInfo.PRIMITIVE_FLOAT;
            }
            if (clazz == Double.TYPE) {
                return TypeInfo.PRIMITIVE_DOUBLE;
            }
            if (clazz == Character.TYPE) {
                return TypeInfo.PRIMITIVE_CHARACTER;
            }
        }
        if (clazz == Void.class) {
            return TypeInfo.VOID;
        }
        if (clazz == Boolean.class) {
            return TypeInfo.BOOLEAN;
        }
        if (clazz == Byte.class) {
            return TypeInfo.BYTE;
        }
        if (clazz == Short.class) {
            return TypeInfo.SHORT;
        }
        if (clazz == Integer.class) {
            return TypeInfo.INT;
        }
        if (clazz == Long.class) {
            return TypeInfo.LONG;
        }
        if (clazz == Float.class) {
            return TypeInfo.FLOAT;
        }
        if (clazz == Double.class) {
            return TypeInfo.DOUBLE;
        }
        if (clazz == Character.class) {
            return TypeInfo.CHARACTER;
        }
        if (clazz == Number.class) {
            return TypeInfo.NUMBER;
        }
        if (clazz == String.class) {
            return TypeInfo.STRING;
        }
        if (clazz == Class.class) {
            return TypeInfo.RAW_CLASS;
        }
        if (clazz == Date.class) {
            return TypeInfo.DATE;
        }
        if (clazz == Optional.class) {
            return TypeInfo.RAW_OPTIONAL;
        }
        if (clazz == EnumSet.class) {
            return TypeInfo.RAW_ENUM_SET;
        }
        if (clazz == Runnable.class) {
            return TypeInfo.RUNNABLE;
        }
        if (clazz == Consumer.class) {
            return TypeInfo.RAW_CONSUMER;
        }
        if (clazz == Supplier.class) {
            return TypeInfo.RAW_SUPPLIER;
        }
        if (clazz == Function.class) {
            return TypeInfo.RAW_FUNCTION;
        }
        if (clazz == Predicate.class) {
            return TypeInfo.RAW_PREDICATE;
        }
        if (clazz == List.class) {
            return TypeInfo.RAW_LIST;
        }
        if (clazz == Set.class) {
            return TypeInfo.RAW_SET;
        }
        if (clazz == Map.class) {
            return TypeInfo.RAW_MAP;
        }
        if (clazz == Object[].class) {
            return TypeInfo.OBJECT_ARRAY;
        }
        if (clazz == String[].class) {
            return TypeInfo.STRING_ARRAY;
        }
        if (clazz == BigInteger.class) {
            return TypeInfo.BIG_INT;
        }
        return null;
    }

    default public TypeInfoFactory associate(ScriptableObject topScope) {
        if (topScope.getParentScope() != null) {
            throw new IllegalArgumentException("provided scope not top scope");
        }
        return (TypeInfoFactory)topScope.associateValue("TypeInfoFactory", this);
    }

    public static TypeInfoFactory get(Scriptable scope) {
        TypeInfoFactory got = TypeInfoFactory.getOrElse(scope, null);
        if (got == null) {
            throw new IllegalArgumentException("top scope have no associated TypeInfoFactory");
        }
        return got;
    }

    public static TypeInfoFactory getOrElse(Scriptable scope, TypeInfoFactory fallback) {
        TypeInfoFactory got = (TypeInfoFactory)ScriptableObject.getTopScopeValue(scope, "TypeInfoFactory");
        if (got == null) {
            return fallback;
        }
        return got;
    }
}

