/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.lc.type.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.lc.ByteAsBool;
import org.mozilla.javascript.lc.type.impl.ClassTypeInfo;

public class InterfaceTypeInfo
extends ClassTypeInfo {
    private static final Class<? extends Annotation> FN_INTERFACE = Kit.classOrNull("java.lang.FunctionalInterface");
    private byte functional;

    public InterfaceTypeInfo(Class<?> type) {
        this(type, -1);
    }

    public InterfaceTypeInfo(Class<?> type, byte functional) {
        super(type);
        this.functional = functional;
    }

    @Override
    public boolean isFunctionalInterface() {
        if (ByteAsBool.isUnknown(this.functional)) {
            try {
                if (FN_INTERFACE != null && this.asClass().isAnnotationPresent(FN_INTERFACE)) {
                    this.functional = 1;
                } else {
                    int count = 0;
                    for (Method method : this.asClass().getMethods()) {
                        if (Modifier.isAbstract(method.getModifiers()) && !method.isSynthetic() && !method.isBridge()) {
                            ++count;
                        }
                        if (count > 1) break;
                    }
                    this.functional = ByteAsBool.fromBool(count == 1);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.functional = 0;
            }
        }
        return ByteAsBool.isTrue(this.functional);
    }

    @Override
    public boolean isInterface() {
        return true;
    }
}

