/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.math.BigInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeBigIntArrayView;
import org.mozilla.javascript.typedarrays.NativeFloat64Array;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeBigUint64Array
extends NativeBigIntArrayView {
    private static final long serialVersionUID = -1255405650050639335L;
    private static final String CLASS_NAME = "BigUint64Array";
    private static final int BYTES_PER_ELEMENT = 8;

    public NativeBigUint64Array() {
    }

    public NativeBigUint64Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len * 8);
    }

    public NativeBigUint64Array(int len) {
        this(new NativeArrayBuffer((double)len * 8.0), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 3, 2, (lcx, lscope, args) -> NativeTypedArrayView.js_constructor(lcx, lscope, args, NativeBigUint64Array::new, 8));
        constructor.setPrototypePropertyAttributes(7);
        NativeTypedArrayView.init(cx, scope, constructor, NativeBigUint64Array::realThis);
        constructor.defineProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        constructor.definePrototypeProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public int getBytesPerElement() {
        return 8;
    }

    private static NativeFloat64Array realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeFloat64Array.class);
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        long base = ByteIo.readUint64Primitive(this.arrayBuffer.buffer, index * 8 + this.offset, NativeBigUint64Array.useLittleEndian());
        if ((base & Long.MIN_VALUE) == 0L) {
            return BigInteger.valueOf(base);
        }
        BigInteger lsw = BigInteger.valueOf(base & 0xFFFFFFFFFFFFFFFFL);
        BigInteger msw = BigInteger.valueOf(base >> 32 & 0xFFFFFFFFFFFFFFFFL).shiftLeft(32);
        return msw.add(lsw);
    }

    @Override
    protected Object js_set(int index, Object c) {
        BigInteger val = ScriptRuntime.toBigInt(c);
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        long base = val.longValue();
        ByteIo.writeUint64(this.arrayBuffer.buffer, index * 8 + this.offset, base, NativeBigUint64Array.useLittleEndian());
        return null;
    }

    @Override
    public BigInteger get(int i) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (BigInteger)this.js_get(i);
    }

    @Override
    public BigInteger set(int i, BigInteger aByte) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (BigInteger)this.js_set(i, aByte);
    }
}

