/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeInt16Array
extends NativeTypedArrayView<Short> {
    private static final long serialVersionUID = -8592870435287581398L;
    private static final String CLASS_NAME = "Int16Array";
    private static final int BYTES_PER_ELEMENT = 2;

    public NativeInt16Array() {
    }

    public NativeInt16Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len * 2);
    }

    public NativeInt16Array(int len) {
        this(new NativeArrayBuffer((double)len * 2.0), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 3, 2, (lcx, lscope, args) -> NativeTypedArrayView.js_constructor(lcx, lscope, args, NativeInt16Array::new, 2));
        constructor.setPrototypePropertyAttributes(7);
        NativeTypedArrayView.init(cx, scope, constructor, NativeInt16Array::realThis);
        constructor.defineProperty("BYTES_PER_ELEMENT", (Object)2, 7);
        constructor.definePrototypeProperty("BYTES_PER_ELEMENT", (Object)2, 7);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }

    private static NativeInt16Array realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeInt16Array.class);
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readInt16(this.arrayBuffer.buffer, index * 2 + this.offset, NativeInt16Array.useLittleEndian());
    }

    @Override
    protected Object js_set(int index, Object c) {
        int val = Conversions.toInt16(c);
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        ByteIo.writeInt16(this.arrayBuffer.buffer, index * 2 + this.offset, val, NativeInt16Array.useLittleEndian());
        return null;
    }

    @Override
    public Short get(int i) {
        this.ensureIndex(i);
        return (Short)this.js_get(i);
    }

    @Override
    public Short set(int i, Short aByte) {
        this.ensureIndex(i);
        return (Short)this.js_set(i, aByte);
    }
}

