/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.php.cache.SerializationResult;
import org.sonar.php.cache.SymbolTableDeserializationInput;
import org.sonar.php.cache.SymbolTableDeserializer;
import org.sonar.php.cache.SymbolTableSerializationInput;
import org.sonar.php.cache.SymbolTableSerializer;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.cache.PhpWriteCache;

public class Cache {
    public static final String DATA_CACHE_PREFIX = "php.projectSymbolData.data:";
    public static final String STRING_TABLE_CACHE_PREFIX = "php.projectSymbolData.stringTable:";
    public static final String CONTENT_HASHES_KEY = "php.contentHashes:";
    private final CacheContext cacheContext;
    private final String pluginVersion;

    public Cache(CacheContext cacheContext) {
        this.cacheContext = cacheContext;
        this.pluginVersion = cacheContext.pluginVersion();
    }

    public void writeFileSymbolTable(InputFile file, SymbolTableImpl symbolTable) {
        if (this.cacheContext.isCacheEnabled()) {
            SymbolTableSerializationInput serializationInput = new SymbolTableSerializationInput(symbolTable, this.pluginVersion);
            SerializationResult serializationData = SymbolTableSerializer.toBinary(serializationInput);
            PhpWriteCache writeCache = this.cacheContext.getWriteCache();
            writeCache.writeBytes(Cache.cacheKey(DATA_CACHE_PREFIX, file.key()), serializationData.data());
            writeCache.writeBytes(Cache.cacheKey(STRING_TABLE_CACHE_PREFIX, file.key()), serializationData.stringTable());
        }
    }

    public void writeFileContentHash(InputFile file, byte[] hash) {
        if (this.cacheContext.isCacheEnabled()) {
            String cacheKey = Cache.cacheKey(CONTENT_HASHES_KEY, file.key());
            this.cacheContext.getWriteCache().writeBytes(cacheKey, hash);
        }
    }

    @CheckForNull
    public SymbolTableImpl read(InputFile file) {
        if (this.cacheContext.isCacheEnabled()) {
            byte[] data = this.cacheContext.getReadCache().readBytes(Cache.cacheKey(DATA_CACHE_PREFIX, file.key()));
            byte[] stringTable = this.cacheContext.getReadCache().readBytes(Cache.cacheKey(STRING_TABLE_CACHE_PREFIX, file.key()));
            if (data != null && stringTable != null) {
                return SymbolTableDeserializer.fromBinary(new SymbolTableDeserializationInput(data, stringTable, this.pluginVersion));
            }
        }
        return null;
    }

    @CheckForNull
    public byte[] readFileContentHash(InputFile file) {
        if (this.cacheContext.isCacheEnabled()) {
            String cacheKey = Cache.cacheKey(CONTENT_HASHES_KEY, file.key());
            return this.cacheContext.getReadCache().readBytes(cacheKey);
        }
        return null;
    }

    private static String cacheKey(String prefix, String file) {
        return prefix + file.replace('\\', '/');
    }
}

