/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.argumentmatching.ArgumentVerifierValueContainment;
import org.sonar.php.checks.utils.argumentmatching.FunctionArgumentCheck;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S5542")
public class EncryptionModeAndPaddingCheck
extends FunctionArgumentCheck {
    private static final String MESSAGE = "Use secure mode and padding scheme.";
    private static final String OPENSSL_PUBLIC_ENCRYPT = "openssl_public_encrypt";
    private static final String OPENSSL_PUBLIC_ENCRYPT_COMPLIANT_VALUE = "OPENSSL_PKCS1_OAEP_PADDING";
    private static final String OPENSSL_ENCRYPT = "openssl_encrypt";
    private static final Set<String> OPENSSL_ENCRYPT_NONCOMPLIANT_VALUES = EncryptionModeAndPaddingCheck.opensslPublicEncryptNoncompliantValues();
    private static final String MCRYPT_ENCRYPT = "mcrypt_encrypt";
    private static final String MCRYPT_ENCRYPT_NONCOMPLIANT_VALUE = "ecb";

    private static Set<String> opensslPublicEncryptNoncompliantValues() {
        return Set.of("aes-128-ecb", "aes-192-ecb", "aes-256-ecb", "aria-128-ecb", "aria-192-ecb", "aria-256-ecb", "bf-ecb", "camellia-128-ecb", "camellia-192-ecb", "camellia-256-ecb", "cast5-ecb", "des-ecb", "rc2-ecb", "seed-ecb", "sm4-ecb");
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (!this.checkArgumentAbsence(tree, OPENSSL_PUBLIC_ENCRYPT, 3)) {
            ArgumentVerifierValueContainment opensslPublicEncryptMatcher = ((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)ArgumentVerifierValueContainment.builder().position(3)).name("padding")).values(OPENSSL_PUBLIC_ENCRYPT_COMPLIANT_VALUE)).raiseIssueOnMatch(false).build();
            this.checkArgument(tree, OPENSSL_PUBLIC_ENCRYPT, opensslPublicEncryptMatcher);
        }
        ArgumentVerifierValueContainment opensslMatcher = ((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)ArgumentVerifierValueContainment.builder().position(1)).name("method")).values(OPENSSL_ENCRYPT_NONCOMPLIANT_VALUES)).raiseIssueOnMatch(true).build();
        ArgumentVerifierValueContainment mcryptMatcher = ((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)ArgumentVerifierValueContainment.builder().position(3)).name("mode")).values(MCRYPT_ENCRYPT_NONCOMPLIANT_VALUE)).raiseIssueOnMatch(true).build();
        this.checkArgument(tree, OPENSSL_ENCRYPT, opensslMatcher);
        this.checkArgument(tree, MCRYPT_ENCRYPT, mcryptMatcher);
        super.visitFunctionCall(tree);
    }

    @Override
    protected void createIssue(ExpressionTree tree) {
        this.context().newIssue(this, tree, MESSAGE);
    }
}

