/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1578")
public class FileNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1578";
    private static final String MESSAGE = "Rename this file to match this regular expression: \"%s\"";
    public static final String DEFAULT = "[a-z][A-Za-z0-9]+.php";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="[a-z][A-Za-z0-9]+.php")
    String format = "[a-z][A-Za-z0-9]+.php";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        String filename = this.context().getPhpFile().filename();
        if (!this.pattern.matcher(filename).matches()) {
            this.context().newFileIssue(this, String.format(MESSAGE, this.format));
        }
    }
}

