/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.metrics.ComplexityVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1541")
public class FunctionComplexityCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1541";
    private static final String MESSAGE = "The Cyclomatic Complexity of this function %s is %s which is greater than %s authorized.";
    public static final int DEFAULT = 20;
    @RuleProperty(key="threshold", defaultValue="20")
    int threshold = 20;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return CheckUtils.getFunctionKinds();
    }

    @Override
    public void visitNode(Tree tree) {
        List<Tree> complexityTrees = ComplexityVisitor.complexityNodesWithoutNestedFunctions(tree);
        int complexity = complexityTrees.size();
        if (complexity > this.threshold) {
            String functionName = CheckUtils.getFunctionName((FunctionTree)tree);
            String message = String.format(MESSAGE, functionName, complexity, this.threshold);
            int cost = complexity - this.threshold;
            PreciseIssue issue = this.context().newIssue(this, ((FunctionTree)tree).functionToken(), message).cost(cost);
            complexityTrees.forEach(complexityTree -> issue.secondary((Tree)complexityTree, "+1"));
        }
    }
}

