/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S2070")
public class InsecureHashCheck
extends FunctionUsageCheck {
    public static final String KEY = "S2070";
    private static final String MESSAGE = "Use a stronger hashing algorithm than %s.";

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("md5", "sha1");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getFunctionName(tree);
        this.context().newIssue(this, tree.callee(), String.format(MESSAGE, functionName.toUpperCase(Locale.ENGLISH)));
    }
}

