/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4524")
public class SwitchDefaultPositionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S4524";
    private static final String MESSAGE = "Move this \"default\" clause to the beginning or end of this \"switch\" statement.";

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        List<SwitchCaseClauseTree> clauses = tree.cases();
        if (clauses.size() > 2) {
            clauses.subList(1, clauses.size() - 1).stream().filter(clause -> clause.is(Tree.Kind.DEFAULT_CLAUSE)).forEach(defaultTree -> this.context().newIssue(this, defaultTree.caseToken(), MESSAGE));
        }
        super.visitSwitchStatement(tree);
    }
}

