/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.symbols.Trilean;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S107")
public class TooManyFunctionParametersCheck
extends PHPVisitorCheck {
    public static final String KEY = "S107";
    private static final String MESSAGE = "This function has %s parameters, which is greater than the %s authorized.";
    public static final int DEFAULT_MAX = 7;
    public static final int DEFAULT_CONSTRUCTOR_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    public int max = 7;
    @RuleProperty(key="constructorMax", defaultValue="7")
    public int constructorMax = 7;
    private ClassTree classTree;

    @Override
    public void visitParameterList(ParameterListTree parameterList) {
        int maxValue;
        int numberOfParameters = TooManyFunctionParametersCheck.getNumberOfParametersExcludingPromotedProperties(parameterList);
        int n = maxValue = this.isConstructorParameterList(parameterList) ? this.constructorMax : this.max;
        if (numberOfParameters > maxValue && TooManyFunctionParametersCheck.isOverriding(parameterList.getParent()).isFalse()) {
            this.context().newIssue(this, parameterList, String.format(MESSAGE, numberOfParameters, maxValue));
        }
        super.visitParameterList(parameterList);
    }

    private static int getNumberOfParametersExcludingPromotedProperties(ParameterListTree parameterList) {
        return (int)parameterList.parameters().stream().filter(Predicate.not(ParameterTree::isPropertyPromotion)).count();
    }

    private static Trilean isOverriding(@Nullable Tree tree) {
        return Optional.ofNullable(tree).filter(t -> t.is(Tree.Kind.METHOD_DECLARATION)).map(t -> Symbols.get((MethodDeclarationTree)t).isOverriding()).orElse(Trilean.FALSE);
    }

    private boolean isConstructorParameterList(ParameterListTree parameterList) {
        MethodDeclarationTree constructor;
        if (this.classTree != null && (constructor = this.classTree.fetchConstructor()) != null) {
            return parameterList.equals(constructor.parameters());
        }
        return false;
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.classTree = tree;
        super.visitClassDeclaration(tree);
        this.classTree = null;
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.classTree = tree;
        super.visitAnonymousClass(tree);
        this.classTree = null;
    }
}

