/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4834")
public class PermissionsControlCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that Permissions are controlled safely here.";
    private static final QualifiedName CAKE_BASE_AUTHORIZE_CLASS = QualifiedName.qualifiedName("Cake\\Auth\\BaseAuthorize");
    private static final QualifiedName CAKE_CONTROLLER_CLASS = QualifiedName.qualifiedName("Cake\\Controller\\Controller");

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.checkClass(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.checkClass(tree);
    }

    private void checkClass(ClassTree tree) {
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null) {
            QualifiedName fullyQualifiedSuperclassName = this.getFullyQualifiedName(superClass);
            if (fullyQualifiedSuperclassName.equals(CAKE_BASE_AUTHORIZE_CLASS)) {
                this.context().newIssue(this, superClass, MESSAGE);
            } else if (fullyQualifiedSuperclassName.equals(CAKE_CONTROLLER_CLASS)) {
                this.checkCakeControllerMethods(tree);
            }
        }
    }

    private void checkCakeControllerMethods(ClassTree tree) {
        for (ClassMemberTree member : tree.members()) {
            NameIdentifierTree name;
            if (!member.is(Tree.Kind.METHOD_DECLARATION) || !"isAuthorized".equalsIgnoreCase((name = ((MethodDeclarationTree)member).name()).text())) continue;
            this.context().newIssue(this, name, MESSAGE);
        }
    }
}

