/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5876")
public class SessionFixationStrategyCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Create a new session during user authentication to prevent session fixation attacks.";
    private static final String SECURITY_COMPONENT = "security";
    private static final String SENSITIVE_VALUE = "none";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.lowerCaseFunctionName(tree);
        if ("loadfromextension".equals(functionName) && SessionFixationStrategyCheck.isArgumentEqualsTo(tree, "extension", 0, SECURITY_COMPONENT) && SessionFixationStrategyCheck.isArgumentSensitiveArray(tree, "values", 1) || "extension".equals(functionName) && SessionFixationStrategyCheck.isArgumentEqualsTo(tree, "namespace", 0, SECURITY_COMPONENT) && SessionFixationStrategyCheck.isArgumentSensitiveArray(tree, "config", 1) || "prependextensionconfig".equals(functionName) && SessionFixationStrategyCheck.isArgumentEqualsTo(tree, "name", 0, SECURITY_COMPONENT) && SessionFixationStrategyCheck.isArgumentSensitiveArray(tree, "config", 1)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isArgumentEqualsTo(FunctionCallTree functionCallTree, String name, int position, String expected) {
        Optional<CallArgumentTree> argumentTree = CheckUtils.argument(functionCallTree, name, position);
        return argumentTree.isPresent() && SessionFixationStrategyCheck.isLiteralTreeEqualsTo(argumentTree.get().value(), expected);
    }

    private static boolean isLiteralTreeEqualsTo(ExpressionTree tree, String expected) {
        return tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && expected.equalsIgnoreCase(CheckUtils.trimQuotes((LiteralTree)tree));
    }

    private static boolean isArgumentSensitiveArray(FunctionCallTree functionCallTree, String name, int index) {
        return CheckUtils.argument(functionCallTree, name, index).map(CallArgumentTree::value).map(CheckUtils::assignedValue).filter(ArrayInitializerTree.class::isInstance).map(ArrayInitializerTree.class::cast).filter(arrayTree -> arrayTree.arrayPairs().stream().anyMatch(SessionFixationStrategyCheck::isArrayPairSensitive)).isPresent();
    }

    private static boolean isArrayPairSensitive(ArrayPairTree pair) {
        ExpressionTree key = pair.key();
        return key != null && SessionFixationStrategyCheck.isLiteralTreeEqualsTo(pair.key(), "session_fixation_strategy") && SessionFixationStrategyCheck.isLiteralTreeEqualsTo(pair.value(), SENSITIVE_VALUE);
    }
}

