/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.declaration;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class NamespaceNameTreeImpl
extends PHPTree
implements NamespaceNameTree {
    private static final Tree.Kind KIND = Tree.Kind.NAMESPACE_NAME;
    private final SyntaxToken absoluteSeparator;
    private final SeparatedList<NameIdentifierTree> namespaces;
    private final IdentifierTree name;
    private final String fullName;
    private final String qualifiedName;

    public NamespaceNameTreeImpl(@Nullable SyntaxToken absoluteSeparator, SeparatedList<NameIdentifierTree> namespaces, IdentifierTree name) {
        this.absoluteSeparator = absoluteSeparator;
        this.namespaces = namespaces;
        this.name = name;
        this.fullName = this.getFullName();
        this.qualifiedName = this.qualifiers() + this.unqualifiedName();
    }

    @Override
    @Nullable
    public SyntaxToken absoluteSeparator() {
        return this.absoluteSeparator;
    }

    @Override
    public SeparatedList<NameIdentifierTree> namespaces() {
        return this.namespaces;
    }

    @Override
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public String unqualifiedName() {
        return this.name().text();
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String fullyQualifiedName() {
        return this.getFullName();
    }

    @Override
    public boolean isFullyQualified() {
        return this.absoluteSeparator != null;
    }

    @Override
    public boolean hasQualifiers() {
        return !this.namespaces().isEmpty();
    }

    private String getFullName() {
        StringBuilder result = new StringBuilder();
        if (this.absoluteSeparator != null) {
            result.append(this.absoluteSeparator.text());
        }
        result.append(this.qualifiers());
        result.append(this.unqualifiedName());
        return result.toString();
    }

    private String qualifiers() {
        StringBuilder result = new StringBuilder();
        Iterator<Tree> iterator = this.namespaces.elementsAndSeparators();
        while (iterator.hasNext()) {
            Tree next = iterator.next();
            if (next.is(Tree.Kind.NAME_IDENTIFIER)) {
                result.append(((NameIdentifierTree)next).text());
                continue;
            }
            result.append(((SyntaxToken)next).text());
        }
        return result.toString();
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.absoluteSeparator), this.namespaces.elementsAndSeparators(), IteratorUtils.iteratorOf(this.name));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitNamespaceName(this);
    }
}

