/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.CompoundVariableTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class CompoundVariableTreeImpl
extends PHPTree
implements CompoundVariableTree {
    private static final Tree.Kind KIND = Tree.Kind.COMPOUND_VARIABLE_NAME;
    private final InternalSyntaxToken openDollarCurly;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeCurly;

    public CompoundVariableTreeImpl(InternalSyntaxToken openDollarCurly, ExpressionTree expression, InternalSyntaxToken closeCurly) {
        this.openDollarCurly = openDollarCurly;
        this.expression = expression;
        this.closeCurly = closeCurly;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public SyntaxToken openDollarCurlyBraceToken() {
        return this.openDollarCurly;
    }

    @Override
    public ExpressionTree variableExpression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurly;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.iteratorOf(this.openDollarCurly, this.expression, this.closeCurly);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitCompoundVariable(this);
    }
}

