/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.ClassSymbolIndex;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.FunctionSymbolIndex;
import org.sonar.php.symbols.LocationInFileImpl;
import org.sonar.php.symbols.MethodSymbolData;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.symbols.UnknownLocationInFile;
import org.sonar.php.symbols.Visibility;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.declaration.MethodDeclarationTreeImpl;
import org.sonar.php.tree.symbols.HasClassSymbol;
import org.sonar.php.tree.symbols.HasFunctionSymbol;
import org.sonar.php.tree.symbols.NamespaceNameResolvingVisitor;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.tree.symbols.SymbolQualifiedName;
import org.sonar.php.tree.symbols.SymbolReturnType;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.LocationInFile;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class DeclarationVisitor
extends NamespaceNameResolvingVisitor {
    private final ProjectSymbolData projectSymbolData;
    @Nullable
    private final String filePath;
    private Scope globalScope;
    private final Map<ClassTree, ClassSymbolData> classSymbolDataByTree = new LinkedHashMap<ClassTree, ClassSymbolData>();
    private ClassSymbolIndex classSymbolIndex;
    private final Map<ClassTree, List<MethodSymbolData>> methodsByClassTree = new HashMap<ClassTree, List<MethodSymbolData>>();
    private final Map<MethodSymbolData, MethodDeclarationTreeImpl> methodTreeByData = new HashMap<MethodSymbolData, MethodDeclarationTreeImpl>();
    private final Map<FunctionDeclarationTree, FunctionSymbolData> functionSymbolDataByTree = new LinkedHashMap<FunctionDeclarationTree, FunctionSymbolData>();
    private FunctionSymbolIndex functionSymbolIndex;
    private final Deque<ClassTree> classTreeStack = new ArrayDeque<ClassTree>();
    private final Deque<FunctionSymbolData.FunctionSymbolProperties> functionPropertiesStack = new ArrayDeque<FunctionSymbolData.FunctionSymbolProperties>();
    private static final Set<String> VALID_VISIBILITIES = Set.of("PUBLIC", "PRIVATE", "PROTECTED");
    private static final QualifiedName ANONYMOUS_CLASS_NAME = QualifiedName.qualifiedName("<anonymous_class>");

    DeclarationVisitor(SymbolTableImpl symbolTable, ProjectSymbolData projectSymbolData, @Nullable PhpFile file) {
        super(symbolTable);
        this.projectSymbolData = projectSymbolData;
        this.filePath = DeclarationVisitor.pathOf(file);
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.globalScope = this.symbolTable.addScope(new Scope(tree));
        super.visitCompilationUnit(tree);
        this.classSymbolIndex = ClassSymbolIndex.create(new ArrayList<ClassSymbolData>(this.classSymbolDataByTree.values()), this.projectSymbolData);
        this.classSymbolDataByTree.forEach((declaration, symbolData) -> {
            ClassSymbol symbol = this.classSymbolIndex.get((ClassSymbolData)symbolData);
            ((HasClassSymbol)((Object)declaration)).setSymbol(symbol);
            if (this.methodsByClassTree.containsKey(declaration)) {
                this.methodsByClassTree.get(declaration).forEach(methodData -> this.methodTreeByData.get(methodData).setSymbol(symbol.getDeclaredMethod(methodData.name())));
            }
        });
        this.functionSymbolIndex = FunctionSymbolIndex.create(new ArrayList<FunctionSymbolData>(this.functionSymbolDataByTree.values()), this.projectSymbolData);
        this.functionSymbolDataByTree.forEach((declaration, symbolData) -> {
            FunctionSymbol symbol = this.functionSymbolIndex.get((FunctionSymbolData)symbolData);
            ((HasFunctionSymbol)((Object)declaration)).setSymbol(symbol);
        });
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        SymbolQualifiedName qualifiedName = this.currentNamespace().resolve(tree.name().text());
        this.symbolTable.declareTypeSymbol(tree.name(), this.globalScope, qualifiedName);
        this.classTreeStack.push(tree);
        super.visitClassDeclaration(tree);
        this.classTreeStack.pop();
        this.addClassSymbolData(tree, qualifiedName, this.location(tree.name()));
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.classTreeStack.push(tree);
        super.visitAnonymousClass(tree);
        this.classTreeStack.pop();
        this.addClassSymbolData(tree, ANONYMOUS_CLASS_NAME, this.location(tree.classToken()));
    }

    private void addClassSymbolData(ClassTree tree, QualifiedName qualifiedName, LocationInFile location) {
        NamespaceNameTree superClass = tree.superClass();
        QualifiedName superClassName = superClass == null ? null : this.getFullyQualifiedName(superClass, Symbol.Kind.CLASS);
        List<QualifiedName> interfaceNames = tree.superInterfaces().stream().map(name -> this.getFullyQualifiedName((NamespaceNameTree)name, Symbol.Kind.CLASS)).toList();
        ClassSymbol.Kind kind = ClassSymbol.Kind.NORMAL;
        if (tree.is(Tree.Kind.CLASS_DECLARATION) && ((ClassDeclarationTree)tree).isAbstract()) {
            kind = ClassSymbol.Kind.ABSTRACT;
        } else if (tree.is(Tree.Kind.INTERFACE_DECLARATION)) {
            kind = ClassSymbol.Kind.INTERFACE;
        }
        ClassSymbolData classSymbolData = new ClassSymbolData(location, qualifiedName, superClassName, interfaceNames, kind, this.methodsByClassTree.getOrDefault(tree, Collections.emptyList()));
        this.classSymbolDataByTree.put(tree, classSymbolData);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        ClassTree currentClassTree = this.classTreeStack.peek();
        if (currentClassTree == null) {
            super.visitMethodDeclaration(tree);
            return;
        }
        this.functionPropertiesStack.push(new FunctionSymbolData.FunctionSymbolProperties());
        NameIdentifierTree name = tree.name();
        List<Parameter> parameters = tree.parameters().parameters().stream().map(Parameter::fromTree).toList();
        String visibilityName = tree.modifiers().stream().map(m -> m.text().toUpperCase(Locale.ROOT)).filter(VALID_VISIBILITIES::contains).findFirst().orElse("PUBLIC");
        Visibility visibility = Visibility.valueOf(visibilityName);
        boolean isAbstract = tree.modifiers().stream().map(m -> m.text().toUpperCase(Locale.ROOT)).anyMatch(m -> m.equals("ABSTRACT"));
        boolean isTestMethod = this.isTestMethod(tree, visibility);
        SymbolReturnType returnType = SymbolReturnType.from(tree.returnTypeClause());
        super.visitMethodDeclaration(tree);
        MethodSymbolData methodSymbolData = new MethodSymbolData(this.location(name), name.text(), parameters, this.functionPropertiesStack.pop(), visibility, returnType, isAbstract, isTestMethod);
        this.methodTreeByData.put(methodSymbolData, (MethodDeclarationTreeImpl)tree);
        this.methodsByClassTree.computeIfAbsent(currentClassTree, c -> new ArrayList()).add(methodSymbolData);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.functionPropertiesStack.push(new FunctionSymbolData.FunctionSymbolProperties());
        this.symbolTable.declareSymbol(tree.name(), Symbol.Kind.FUNCTION, this.globalScope, this.currentNamespace());
        NameIdentifierTree name = tree.name();
        SymbolQualifiedName qualifiedName = this.currentNamespace().resolve(name.text());
        List<Parameter> parameters = tree.parameters().parameters().stream().map(Parameter::fromTree).toList();
        SymbolReturnType returnType = SymbolReturnType.from(tree.returnTypeClause());
        super.visitFunctionDeclaration(tree);
        FunctionSymbolData data = new FunctionSymbolData(this.location(name), qualifiedName, parameters, this.functionPropertiesStack.pop(), returnType);
        this.functionSymbolDataByTree.put(tree, data);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.functionSymbolProperties().ifPresent(p -> p.hasReturn(true));
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitYieldExpression(YieldExpressionTree tree) {
        this.functionSymbolProperties().ifPresent(p -> p.hasReturn(true));
        super.visitYieldExpression(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.functionPropertiesStack.push(new FunctionSymbolData.FunctionSymbolProperties());
        super.visitFunctionExpression(tree);
        this.functionPropertiesStack.pop();
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        this.functionSymbolProperties().ifPresent(p -> {
            if (DeclarationVisitor.isFuncGetArgsCall(tree)) {
                p.hasFuncGetArgs(true);
            }
        });
        super.visitFunctionCall(tree);
    }

    public Collection<ClassSymbolData> classSymbolData() {
        return this.classSymbolDataByTree.values();
    }

    public ClassSymbolIndex classSymbolIndex() {
        return this.classSymbolIndex;
    }

    public Collection<FunctionSymbolData> functionSymbolData() {
        return this.functionSymbolDataByTree.values();
    }

    public FunctionSymbolIndex functionSymbolIndex() {
        return this.functionSymbolIndex;
    }

    private Optional<FunctionSymbolData.FunctionSymbolProperties> functionSymbolProperties() {
        if (!this.functionPropertiesStack.isEmpty()) {
            return Optional.of(this.functionPropertiesStack.getFirst());
        }
        return Optional.empty();
    }

    private LocationInFile location(Tree tree) {
        if (this.filePath == null) {
            return UnknownLocationInFile.UNKNOWN_LOCATION;
        }
        SyntaxToken firstToken = ((PHPTree)tree).getFirstToken();
        SyntaxToken lastToken = ((PHPTree)tree).getLastToken();
        return new LocationInFileImpl(this.filePath, firstToken.line(), firstToken.column(), lastToken.endLine(), lastToken.endColumn());
    }

    private static boolean isFuncGetArgsCall(FunctionCallTree fct) {
        return fct.callee().is(Tree.Kind.NAMESPACE_NAME) && ((NamespaceNameTree)fct.callee()).fullyQualifiedName().matches("func_get_arg(s)?");
    }

    @CheckForNull
    protected static String pathOf(@Nullable PhpFile file) {
        if (file == null) {
            return null;
        }
        try {
            URI uri = file.uri();
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return Paths.get(uri).toString();
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private boolean isTestMethod(MethodDeclarationTree methodTree, Visibility visibility) {
        if (!Visibility.PUBLIC.equals((Object)visibility)) {
            return false;
        }
        Predicate<MethodDeclarationTree> hasTestNamePrefix = tree -> tree.name().text().startsWith("test");
        Predicate<MethodDeclarationTree> hasTestAnnotation = tree -> TreeUtils.hasAnnotation(tree, "@test");
        Predicate<MethodDeclarationTree> hasTestAttribute = tree -> tree.attributeGroups().stream().flatMap(group -> group.attributes().stream()).map(AttributeTree::name).anyMatch(nameTree -> "phpunit\\framework\\attributes\\test".equals(this.getFullyQualifiedName((NamespaceNameTree)nameTree, Symbol.Kind.CLASS).toString()));
        return hasTestNamePrefix.or(hasTestAnnotation).or(hasTestAttribute).test(methodTree);
    }
}

