/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.php.tree.impl.VariableIdentifierTreeImpl;
import org.sonar.php.tree.symbols.SymbolImpl;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ListExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class AssignmentExpressionVisitor
extends PHPVisitorCheck {
    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        ExpressionTree lhs = assignment.variable();
        ExpressionTree rhs = assignment.value();
        if (lhs.is(Tree.Kind.LIST_EXPRESSION)) {
            this.handleListAssignment((ListExpressionTree)lhs, rhs);
        } else {
            this.assign(lhs, rhs);
        }
        super.visitAssignmentExpression(assignment);
    }

    private void handleListAssignment(ListExpressionTree lhs, ExpressionTree rhs) {
        List<Object> values = new ArrayList();
        if (rhs.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION)) {
            SeparatedList<ArrayPairTree> valueArrayParis = ((ArrayInitializerTree)rhs).arrayPairs();
            values = valueArrayParis.stream().anyMatch(p -> p.key() != null) ? Collections.emptyList() : valueArrayParis.stream().map(ArrayPairTree::value).toList();
        }
        int index = 0;
        int numValues = values.size();
        for (Optional<ArrayAssignmentPatternElementTree> element : lhs.elements()) {
            if (element.isPresent()) {
                if (index >= numValues || element.get().key() != null) {
                    this.assignToUnknown(element.get().variable());
                    continue;
                }
                this.assign(element.get().variable(), (ExpressionTree)values.get(index));
            }
            ++index;
        }
    }

    private void assign(Tree lhs, ExpressionTree rhs) {
        SymbolImpl symbol = AssignmentExpressionVisitor.getSymbol(lhs);
        if (symbol != null) {
            symbol.assignValue(rhs);
        }
    }

    private void assignToUnknown(Tree lhs) {
        SymbolImpl symbol = AssignmentExpressionVisitor.getSymbol(lhs);
        if (symbol != null) {
            symbol.assignUnknown();
        }
    }

    @CheckForNull
    private static SymbolImpl getSymbol(Tree tree) {
        if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return ((VariableIdentifierTreeImpl)tree).symbol();
        }
        return null;
    }
}

