/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.util.List;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.DurationStatistics;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.php.cache.Cache;
import org.sonar.php.compat.PhpFileImpl;
import org.sonar.php.parser.PHPParserBuilder;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.FileHashingUtils;
import org.sonar.plugins.php.Scanner;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class SymbolScanner
extends Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolScanner.class);
    private final ActionParser<Tree> parser = PHPParserBuilder.createParser();
    private final ProjectSymbolData projectSymbolData = new ProjectSymbolData();
    private int symbolTablesFromCache = 0;

    SymbolScanner(SensorContext context, DurationStatistics statistics, Cache cache) {
        super(context, statistics, cache);
    }

    @Override
    void execute(List<InputFile> files) {
        super.execute(files);
        LOG.info("Cached information of global symbols will be used for {} out of {} files. Global symbols were recomputed for the remaining files.", (Object)this.symbolTablesFromCache, (Object)files.size());
    }

    public static SymbolScanner create(SensorContext context, DurationStatistics statistics, CacheContext cacheContext) {
        Cache cache = new Cache(cacheContext);
        return new SymbolScanner(context, statistics, cache);
    }

    @Override
    String name() {
        return "PHP symbol indexer";
    }

    @Override
    void scanFile(InputFile file) {
        byte[] contentHash;
        SymbolTableImpl fileSymbolTable = null;
        if (this.fileCanBeSkipped(file)) {
            fileSymbolTable = this.readSymbolTableFromCache(file);
        }
        if (fileSymbolTable == null) {
            try {
                fileSymbolTable = this.createSymbolTable(file);
            }
            catch (RecognitionException e) {
                LOG.debug("Can not create symbols for file: {}", (Object)file.filename());
                return;
            }
        }
        fileSymbolTable.classSymbolDatas().forEach(this.projectSymbolData::add);
        fileSymbolTable.functionSymbolDatas().forEach(this.projectSymbolData::add);
        try {
            contentHash = FileHashingUtils.inputFileContentHash(file);
        }
        catch (IllegalStateException ise) {
            LOG.debug("Failed to compute content hash for file {}", (Object)file.key());
            return;
        }
        this.cache.writeFileContentHash(file, contentHash);
        this.cache.writeFileSymbolTable(file, fileSymbolTable);
    }

    @CheckForNull
    private SymbolTableImpl readSymbolTableFromCache(InputFile file) {
        SymbolTableImpl fileSymbolTable = this.cache.read(file);
        if (fileSymbolTable != null) {
            ++this.symbolTablesFromCache;
        }
        return fileSymbolTable;
    }

    private SymbolTableImpl createSymbolTable(InputFile file) throws RecognitionException {
        PhpFile phpFile = PhpFileImpl.create(file);
        CompilationUnitTree ast = (CompilationUnitTree)this.statistics.time("ProjectSymbolParsing", () -> this.parser.parse(phpFile.contents()));
        return this.statistics.time("ProjectSymbolTable", () -> SymbolTableImpl.create(ast, new ProjectSymbolData(), phpFile));
    }

    @Override
    void logException(Exception e, InputFile file) {
        LOG.debug("Unable to analyze file: {}", (Object)file, (Object)e);
    }

    public ProjectSymbolData getProjectSymbolData() {
        return this.projectSymbolData;
    }
}

