/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.php.reports.ExternalReportFileHandler;
import org.sonar.plugins.php.reports.ReportImporter;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;

public abstract class AbstractReportImporter
implements ReportImporter {
    protected final Set<String> unresolvedInputFiles = new LinkedHashSet<String>();
    protected final AnalysisWarningsWrapper analysisWarningsWrapper;
    protected ExternalReportFileHandler fileHandler;
    private ExclusionPattern[] exclusionPatterns = new ExclusionPattern[0];

    protected AbstractReportImporter(AnalysisWarningsWrapper analysisWarningsWrapper) {
        this.analysisWarningsWrapper = analysisWarningsWrapper;
    }

    @Override
    public void execute(SensorContext context) {
        this.exclusionPatterns = ExclusionPattern.create(context.config().getStringArray("sonar.exclusion"));
        this.fileHandler = ExternalReportFileHandler.create(context);
        List<File> reportFiles = this.getReportFiles(context);
        reportFiles.forEach(report -> {
            this.unresolvedInputFiles.clear();
            this.importExternalReport((File)report, context);
            this.logUnresolvedInputFiles((File)report);
        });
    }

    protected void importExternalReport(File reportPath, SensorContext context) {
        try {
            this.importReport(reportPath, context);
        }
        catch (Exception e) {
            this.logFileCantBeRead(e, reportPath);
        }
    }

    public void logFileCantBeRead(Exception e, File reportPath) {
        String msg = this.getFileReadErrorMessage(e, reportPath);
        this.logger().error(msg);
        this.analysisWarningsWrapper.addWarning(msg);
    }

    protected void addUnresolvedInputFile(String filePath) {
        if (!this.isExcluded(filePath)) {
            this.unresolvedInputFiles.add(filePath);
        }
    }

    private boolean isExcluded(String filePath) {
        if (this.exclusionPatterns.length == 0) {
            return false;
        }
        Path path = Path.of(filePath, new String[0]);
        for (ExclusionPattern exclusionPattern : this.exclusionPatterns) {
            if (!exclusionPattern.match(path)) continue;
            return true;
        }
        return false;
    }

    private void logUnresolvedInputFiles(File reportPath) {
        if (this.unresolvedInputFiles.isEmpty()) {
            return;
        }
        Object fileList = this.unresolvedInputFiles.stream().sorted().limit(5L).collect(Collectors.joining(";"));
        if (this.unresolvedInputFiles.size() > 5) {
            fileList = (String)fileList + ";...";
        }
        String msg = String.format(this.getUnresolvedInputFileMessageFormat(), this.unresolvedInputFiles.size(), this.reportName(), reportPath.getName(), fileList);
        this.logger().warn(msg);
        this.analysisWarningsWrapper.addWarning(msg);
    }

    private static class ExclusionPattern {
        final WildcardPattern pattern;

        private ExclusionPattern(String pattern) {
            this.pattern = WildcardPattern.create(pattern);
        }

        static ExclusionPattern[] create(String[] s) {
            ExclusionPattern[] result = new ExclusionPattern[s.length];
            for (int i = 0; i < s.length; ++i) {
                result[i] = new ExclusionPattern(s[i]);
            }
            return result;
        }

        boolean match(Path relativePath) {
            String path = PathUtils.sanitize(relativePath.toString());
            return path != null && this.pattern.match(path);
        }
    }
}

