/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.util.function.Consumer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.plugins.php.reports.ExternalReportFileHandler;
import org.sonar.plugins.php.reports.phpunit.xml.TestCase;

public class TestFileReport {
    private int errors = 0;
    private int failures = 0;
    private String file;
    private int skipped = 0;
    private int tests = 0;
    private double testDuration = 0.0;

    public TestFileReport(String file, double testDuration) {
        this.file = file;
        this.testDuration = testDuration;
    }

    public void saveTestMeasures(SensorContext context, ExternalReportFileHandler fileHandler, Consumer<String> addUnresolvedInputFiles) {
        this.file = fileHandler.relativePath(this.file);
        InputFile unitTestFile = this.getUnitTestInputFile(context.fileSystem());
        if (unitTestFile != null) {
            context.newMeasure().on(unitTestFile).withValue(this.skipped).forMetric(CoreMetrics.SKIPPED_TESTS).save();
            context.newMeasure().on(unitTestFile).withValue((long)this.testDurationMilliseconds()).forMetric(CoreMetrics.TEST_EXECUTION_TIME).save();
            context.newMeasure().on(unitTestFile).withValue((int)this.liveTests()).forMetric(CoreMetrics.TESTS).save();
            context.newMeasure().on(unitTestFile).withValue(this.errors).forMetric(CoreMetrics.TEST_ERRORS).save();
            context.newMeasure().on(unitTestFile).withValue(this.failures).forMetric(CoreMetrics.TEST_FAILURES).save();
        } else {
            addUnresolvedInputFiles.accept(this.file);
        }
    }

    private double liveTests() {
        return (double)this.tests - (double)this.skipped;
    }

    public double testDurationMilliseconds() {
        return this.testDuration * 1000.0;
    }

    private InputFile getUnitTestInputFile(FileSystem fileSystem) {
        FilePredicates predicates = fileSystem.predicates();
        return fileSystem.inputFile(predicates.and(predicates.hasPath(this.file), predicates.hasType(InputFile.Type.TEST), predicates.hasLanguage("php")));
    }

    public void addTestCase(TestCase testCase) {
        if (testCase.getStatus() == TestCase.Status.SKIPPED) {
            ++this.skipped;
        } else if (testCase.getStatus() == TestCase.Status.FAILURE) {
            ++this.failures;
        } else if (testCase.getStatus() == TestCase.Status.ERROR) {
            ++this.errors;
        }
        ++this.tests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestFileReport that = (TestFileReport)o;
        return new EqualsBuilder().append(this.errors, that.errors).append(this.failures, that.failures).append(this.skipped, that.skipped).append(this.tests, that.tests).append(this.testDuration, that.testDuration).append(this.file, that.file).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.errors).append(this.failures).append(this.file).append(this.skipped).append(this.tests).append(this.testDuration).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("errors", this.errors);
        builder.append("failures", this.failures);
        builder.append("file", this.file);
        builder.append("skipped", this.skipped);
        builder.append("tests", this.tests);
        builder.append("testDuration", this.testDuration);
        return builder.toString();
    }

    public int getTests() {
        return this.tests;
    }
}

