/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumanLanguageDetector {
    private static final double[] WORD_FIRST_LETTER_FREQUENCIES = new double[]{2.6590433, 1.2620203, 1.5564419, 0.9035879, 0.7042806, 1.1847413, 0.4955763, 0.9510469, 1.7106735, 0.2684641, 0.2196475, 0.7503985, 1.087598, 0.6504237, 1.7798191, 1.2322421, 0.0468438, 0.9674179, 1.8778546, 3.5174797, 0.4200321, 0.2624742, 1.2915608, 0.0095785, 0.1583926, 0.0323609};
    private static final double[] WORD_LAST_LETTER_FREQUENCIES = new double[]{0.5738782, 0.0514104, 0.2813366, 2.509574, 4.8288358, 1.0461689, 0.7732504, 0.7288072, 0.1805434, 0.0053191, 0.2896774, 0.9860451, 0.5045335, 2.8780559, 1.0164436, 0.183349, 0.0039651, 1.6346942, 3.5859066, 1.9681061, 0.0870041, 0.0362143, 0.207057, 0.0560339, 1.5560091, 0.0277812};
    private static final double[][] CHARACTER_PAIRS_FREQUENCIES = new double[][]{{0.0929348, 1.3457961, 2.7854923, 2.5539888, 0.2209547, 0.6705441, 1.8441841, 0.2415183, 2.1081316, 0.1513539, 0.7217594, 8.0951704, 3.0899456, 14.1108051, 0.0792523, 1.3738109, 0.0387682, 8.5247815, 6.357247, 8.850255, 1.0730911, 1.0915589, 0.4722228, 0.1239866, 1.5762482, 0.218569}, {1.9067869, 0.1279563, 0.0739743, 0.0265155, 3.4357286, 0.0049029, 0.005839, 0.0312368, 0.956677, 0.0743913, 0.0039669, 1.3367944, 0.0346314, 0.0176708, 1.5688768, 0.0101957, 6.587E-4, 1.1051669, 0.3112683, 0.0468363, 1.321757, 0.0127821, 0.0117435, 7.594E-4, 1.2868484, 0.0017814}, {4.0719631, 0.0205519, 0.4552517, 0.0478322, 4.0359256, 0.0136253, 0.0141062, 4.2610277, 1.9324629, 0.0027702, 1.1371642, 1.4239825, 0.0214459, 0.0160944, 5.2439283, 0.0142073, 0.0346805, 1.0777674, 0.2821967, 2.8990383, 1.0071517, 0.0049062, 0.0070608, 9.994E-4, 0.2640629, 0.0263652}, {1.4407028, 0.0366525, 0.0727675, 0.3063419, 5.3874701, 0.0432824, 0.1899634, 0.0710289, 3.8700951, 0.0319036, 0.0064268, 0.1858389, 0.1456839, 0.0833305, 1.2408384, 0.0215672, 0.0132501, 0.6165595, 0.7798563, 0.0405733, 1.0407546, 0.1140672, 0.1005016, 0.0014863, 0.2886946, 0.0112261}, {4.4101634, 0.5402931, 3.1511903, 8.335849, 2.1665083, 1.0040715, 0.9092963, 0.1880728, 1.0110292, 0.0358556, 0.188317, 3.8583031, 2.2997606, 8.5360484, 0.7791784, 1.1289852, 0.2515411, 14.4775826, 8.3971751, 2.7876921, 0.3437904, 1.4431433, 0.9862942, 1.1282521, 0.8072609, 0.0804047}, {0.9463967, 0.0087502, 0.0314099, 0.0487887, 1.5768827, 0.7325095, 0.0113305, 0.0027475, 2.0741465, 0.0032058, 0.0049733, 0.4309108, 0.0223647, 0.0049622, 3.2088246, 0.0047891, 4.224E-4, 1.5815529, 0.0435306, 0.5887487, 0.4870926, 0.0019864, 0.0038661, 0.0018069, 0.0444506, 0.0011643}, {1.4170025, 0.0481224, 0.0082768, 0.0816686, 3.0209535, 0.0149393, 0.1457067, 1.2637355, 1.121449, 0.0042659, 0.006808, 0.5162312, 0.0464436, 0.4306755, 0.8720109, 0.0092219, 0.0014534, 1.302087, 0.3605589, 0.1215897, 0.9230535, 0.003158, 0.0317547, 0.0021631, 0.2001351, 0.0043706}, {4.3917104, 0.0536482, 0.0181969, 0.0394497, 16.2490394, 0.0149868, 0.0059029, 0.0085796, 4.4951994, 0.0023695, 0.012801, 0.1408159, 0.1344758, 0.270349, 3.0645262, 0.0150515, 0.0061781, 0.5387961, 0.2133521, 0.6162165, 0.5563874, 0.0095012, 0.0915231, 5.191E-4, 0.3276425, 0.0056028}, {3.0618075, 0.5378794, 5.3672662, 1.7146727, 2.6249932, 0.9268649, 1.6588638, 0.0298823, 0.1653869, 0.0423041, 0.4355309, 3.3780001, 1.6210354, 16.2047698, 5.3259079, 0.8335975, 0.06607, 2.5575842, 7.7396368, 6.8953537, 0.1660788, 1.8670839, 0.0228681, 0.1719965, 0.0319517, 0.3727173}, {0.5384459, 0.0018035, 0.0037464, 0.0049227, 0.3791862, 0.0016495, 0.0030904, 0.0047405, 0.1010139, 0.0030284, 0.0051238, 0.0023837, 0.0052344, 0.0054429, 0.5759392, 0.0419588, 1.699E-4, 0.0199578, 0.0076412, 0.0024995, 0.511387, 0.0018288, 0.0015663, 3.011E-4, 0.0024199, 0.0015624}, {0.4584126, 0.0151268, 0.0066457, 0.0105469, 1.4778732, 0.0156612, 0.0235217, 0.0926333, 0.9247234, 0.0043772, 0.028332, 0.1271601, 0.0365927, 0.2679984, 0.2570398, 0.0171023, 8.536E-4, 0.0805852, 0.6105992, 0.0285942, 0.115693, 0.007477, 0.0280535, 0.0013893, 0.1124803, 0.0013102}, {4.548621, 0.2915819, 0.089763, 1.4893018, 6.3515348, 0.2311593, 0.0921435, 0.0322694, 5.0245197, 0.0092016, 0.1856222, 3.8105199, 0.4655274, 0.0369741, 2.6739741, 0.153297, 0.0018632, 0.0689171, 1.1608595, 0.8001751, 0.9675034, 0.2130048, 0.102301, 0.0016705, 2.2223913, 0.0112197}, {4.4732575, 0.9971554, 0.0892385, 0.0154109, 5.1403143, 0.0175541, 0.0107624, 0.0132742, 2.3275322, 0.0027971, 0.0088211, 0.0391983, 0.8021489, 0.0887556, 2.0619624, 1.4747935, 8.712E-4, 0.0401555, 0.5991706, 0.0220131, 0.881698, 0.0076061, 0.0126008, 0.0026432, 0.3033358, 0.0023306}, {3.6077607, 0.0975166, 2.589403, 7.9063088, 4.6470058, 0.3556239, 6.2425962, 0.1073503, 3.0557149, 0.0788384, 0.6186266, 0.3370293, 0.17844, 0.8651743, 2.8184623, 0.0480307, 0.0223127, 0.102047, 3.1470283, 6.0322931, 0.6582686, 0.2595533, 0.0651263, 0.0103653, 0.6055506, 0.0792284}, {0.5652844, 0.5958594, 1.2994182, 1.1115993, 0.2776038, 6.3941577, 0.7715881, 0.2678748, 0.5253778, 0.0947828, 0.4635273, 2.920816, 3.7278997, 11.6017554, 1.4753292, 1.8177215, 0.0118906, 8.8419322, 1.7595924, 2.4753308, 4.5261994, 1.4178813, 1.8557399, 0.1644457, 0.2754933, 0.0487071}, {2.5624505, 0.0202675, 0.0204994, 0.022034, 2.9595845, 0.015402, 0.0525791, 0.7732213, 1.0678211, 0.0022877, 0.0096737, 1.8234707, 0.0814874, 0.0208135, 2.2662701, 0.7738026, 8.108E-4, 2.6371155, 0.3885394, 0.5976453, 0.7912125, 0.0032943, 0.0076619, 9.594E-4, 0.0841922, 0.0031912}, {0.0116363, 0.0014528, 8.5E-4, 4.046E-4, 0.0011631, 9.863E-4, 1.834E-4, 3.922E-4, 0.0148139, 1.364E-4, 1.327E-4, 0.0016952, 8.495E-4, 3.971E-4, 0.0012619, 4.823E-4, 7.202E-4, 8.395E-4, 0.0016322, 9.446E-4, 0.781532, 8.461E-4, 7.344E-4, 2.711E-4, 1.503E-4, 1.024E-4}, {5.2664628, 0.2722724, 1.0315216, 1.5041745, 11.4452395, 0.2187558, 0.8034347, 0.1197433, 5.9004085, 0.0136782, 0.7869179, 0.7888557, 1.1905663, 1.5408916, 5.2636683, 0.2840431, 0.0162732, 0.8714239, 3.073065, 3.0935018, 1.0043785, 0.4845634, 0.1116324, 0.0059307, 1.9104828, 0.0298333}, {1.3958189, 0.1084548, 1.3997172, 0.0477502, 5.5977636, 0.0961754, 0.0285751, 2.4672552, 3.9516833, 0.0077479, 0.339737, 0.4491616, 0.3986528, 0.1207062, 2.8901855, 1.1973049, 0.080366, 0.0717654, 2.3862707, 7.8045342, 1.7449085, 0.0408148, 0.1931512, 0.0020589, 0.350114, 0.0198438}, {4.0046636, 0.2315084, 0.6360105, 0.0243227, 8.9176277, 0.0526605, 0.0200005, 18.3086482, 7.9891653, 0.0062372, 0.0151697, 0.6619201, 0.1460394, 0.0806787, 6.2468781, 0.0274042, 7.526E-4, 2.9306096, 2.1799955, 1.1239766, 1.616373, 0.1039086, 0.5300224, 0.003287, 1.5511418, 0.0753694}, {1.0405339, 0.7757457, 1.0559389, 0.6735502, 1.0636866, 0.1190306, 0.7986363, 0.0290528, 0.7019287, 0.0192097, 0.1602448, 1.8289351, 1.1563737, 3.2297811, 0.0582932, 0.8142665, 0.0061515, 3.2935746, 3.1995976, 2.5388821, 0.0101856, 0.0400647, 0.0116986, 0.0440218, 0.0426452, 0.0412904}, {0.9870774, 0.0037721, 0.006448, 0.017297, 4.6552622, 0.0133728, 0.0130077, 0.0038715, 2.1772529, 8.623E-4, 0.0029271, 0.0134182, 0.0028136, 0.0068546, 0.5066435, 0.0041575, 2.258E-4, 0.0206034, 0.0273123, 0.0044648, 0.0203117, 0.002107, 0.0015298, 5.471E-4, 0.0621332, 6.573E-4}, {2.9790214, 0.0193429, 0.0157836, 0.018724, 1.8652788, 0.0161439, 0.004503, 1.5224859, 2.2852698, 0.0017198, 0.0207637, 0.0770983, 0.0136184, 0.6167433, 1.3048155, 0.018365, 9.061E-4, 0.2921267, 0.250538, 0.0269223, 0.0164429, 0.0029288, 0.0208577, 0.0010678, 0.0402552, 0.0011097}, {0.1665908, 0.0055061, 0.086935, 0.0017397, 0.1209231, 0.0230238, 4.892E-4, 0.0240804, 0.2232723, 4.185E-4, 3.742E-4, 0.006829, 0.0051386, 0.0011599, 0.0317656, 0.2459899, 5.172E-4, 0.0012081, 0.0033771, 0.3847311, 0.0254768, 0.0063257, 0.0036148, 0.0100832, 0.0172085, 2.967E-4}, {0.3162593, 0.054578, 0.1219273, 0.0766018, 0.7890763, 0.0112568, 0.021848, 0.0089087, 0.1617439, 0.0032816, 0.0146214, 0.2275842, 0.1906941, 0.1630151, 0.6414934, 0.1588797, 4.128E-4, 0.1039721, 0.4814257, 0.1023695, 0.0593967, 0.0103587, 0.0387865, 0.0029518, 0.005733, 0.0142095}, {0.2393676, 0.0081167, 0.0035083, 0.0052527, 0.3775166, 0.0012409, 0.0050274, 0.0330923, 0.1787957, 6.392E-4, 0.006042, 0.0129057, 0.0072316, 0.0071939, 0.1036998, 0.0025679, 9.882E-4, 0.0047487, 0.0052224, 0.005546, 0.0411031, 0.0031899, 0.0047273, 7.615E-4, 0.0223349, 0.0495398}};
    private static final Pattern wordPattern = Pattern.compile("[a-z]++|[A-Z][a-z]++|[A-Za-z]++");

    private HumanLanguageDetector() {
    }

    public static double humanLanguageScore(String text) {
        double totalScore = 0.0;
        double totalWeight = 0.0;
        int camelCaseSeparator = 0;
        int lastFindingEnd = -1;
        int allWorldLength = 0;
        Matcher matcher = wordPattern.matcher(text);
        while (matcher.find()) {
            if (matcher.start() == lastFindingEnd) {
                ++camelCaseSeparator;
            }
            String word = matcher.group().toLowerCase(Locale.ROOT);
            allWorldLength += word.length();
            double weight = word.length();
            totalScore += HumanLanguageDetector.wordScore(word) * weight;
            totalWeight += weight;
            lastFindingEnd = matcher.end();
        }
        if (totalWeight == 0.0) {
            return 1.0;
        }
        int separatorCount = text.length() - allWorldLength + camelCaseSeparator;
        int expectedSeparatorCount = text.length() / 6;
        int unexpectedSeparatorCount = Math.abs(separatorCount - expectedSeparatorCount);
        return (totalScore / totalWeight * (double)allWorldLength + 0.1 * (double)unexpectedSeparatorCount) / (double)(allWorldLength + unexpectedSeparatorCount);
    }

    private static int index(char ch) {
        return ch - 97;
    }

    private static double wordScore(String word) {
        if (word.length() == 1) {
            return 0.1;
        }
        char firstChar = word.charAt(0);
        char lastChar = word.charAt(word.length() - 1);
        double firstCharScore = WORD_FIRST_LETTER_FREQUENCIES[HumanLanguageDetector.index(firstChar)];
        double lastCharScore = WORD_LAST_LETTER_FREQUENCIES[HumanLanguageDetector.index(lastChar)];
        double pairsScore = 0.0;
        int numberOfPairs = word.length() - 1;
        for (int i = 0; i < numberOfPairs; ++i) {
            pairsScore += CHARACTER_PAIRS_FREQUENCIES[HumanLanguageDetector.index(word.charAt(i))][HumanLanguageDetector.index(word.charAt(i + 1))];
        }
        return (firstCharScore + lastCharScore + pairsScore) / (double)(numberOfPairs + 2);
    }
}

