/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

public class Report {
    private int expectedIssueCount = 0;
    private int actualIssueCount = 0;
    private StringBuilder context = new StringBuilder();
    private StringBuilder expected = new StringBuilder();
    private StringBuilder actual = new StringBuilder();
    private int expectedQuickfixCount = 0;
    private int actualQuickfixCount = 0;
    private StringBuilder quickfixContext = new StringBuilder();
    private StringBuilder expectedQuickfixes = new StringBuilder();
    private StringBuilder actualQuickfixes = new StringBuilder();

    public int getExpectedIssueCount() {
        return this.expectedIssueCount;
    }

    public void setExpectedIssueCount(int count) {
        this.expectedIssueCount = count;
    }

    public int getActualIssueCount() {
        return this.actualIssueCount;
    }

    public void setActualIssueCount(int count) {
        this.actualIssueCount = count;
    }

    public int getExpectedQuickfixCount() {
        return this.expectedQuickfixCount;
    }

    public void setExpectedQuickfixCount(int expectedQuickfixCount) {
        this.expectedQuickfixCount = expectedQuickfixCount;
    }

    public int getActualQuickfixCount() {
        return this.actualQuickfixCount;
    }

    public void setActualQuickfixCount(int actualQuickfixCount) {
        this.actualQuickfixCount = actualQuickfixCount;
    }

    public String getActual() {
        return this.actual.toString();
    }

    public String getExpected() {
        return this.expected.toString();
    }

    public String getContext() {
        return this.context.toString();
    }

    public String getQuickfixContext() {
        return this.quickfixContext.toString();
    }

    public Report appendActual(String text) {
        this.actual.append(text);
        return this;
    }

    public Report prependActual(String text) {
        this.actual.insert(0, text);
        return this;
    }

    public Report appendExpected(String text) {
        this.expected.append(text);
        return this;
    }

    public Report prependContext(String text) {
        this.context.insert(0, text);
        return this;
    }

    public Report prependExpected(String text) {
        this.expected.insert(0, text);
        return this;
    }

    public Report appendContext(String text) {
        this.context.append(text);
        return this;
    }

    public Report appendQuickfixContext(String text) {
        this.quickfixContext.append(text);
        return this;
    }

    public Report append(Report report) {
        this.expectedIssueCount += report.expectedIssueCount;
        this.actualIssueCount += report.actualIssueCount;
        this.expectedQuickfixCount += report.expectedQuickfixCount;
        this.actualQuickfixCount += report.actualQuickfixCount;
        this.context.append((CharSequence)report.context).append("; ");
        this.expected.append((CharSequence)report.expected).append("\n");
        this.actual.append((CharSequence)report.actual).append("\n");
        this.expectedQuickfixes.append((CharSequence)report.expectedQuickfixes).append("\n");
        this.actualQuickfixes.append((CharSequence)report.actualQuickfixes).append("\n");
        this.quickfixContext.append((CharSequence)report.quickfixContext);
        return this;
    }
}

