/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import org.sonarsource.analyzer.commons.regex.helpers.AbstractAutomataChecker;
import org.sonarsource.analyzer.commons.regex.helpers.SimplifiedRegexCharacterClass;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public class IntersectAutomataChecker
extends AbstractAutomataChecker {
    public IntersectAutomataChecker(boolean defaultAnswer) {
        super(defaultAnswer);
    }

    @Override
    protected boolean neutralAnswer() {
        return false;
    }

    @Override
    protected boolean checkAuto1AndAuto2Successors(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer, boolean hasConsumedInput) {
        SimplifiedRegexCharacterClass characterClass1 = SimplifiedRegexCharacterClass.of(auto1.start);
        SimplifiedRegexCharacterClass characterClass2 = SimplifiedRegexCharacterClass.of(auto2.start);
        return characterClass1 != null && characterClass2 != null ? characterClass1.intersects(characterClass2, defaultAnswer) && auto1.anySuccessorMatch(successor1 -> auto2.anySuccessorMatch(successor2 -> this.check((SubAutomaton)successor1, (SubAutomaton)successor2, true))) : defaultAnswer;
    }

    @Override
    protected boolean checkAuto1Successors(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer, boolean hasConsumedInput) {
        return auto1.anySuccessorMatch(successor -> this.check((SubAutomaton)successor, auto2, hasConsumedInput));
    }

    @Override
    protected boolean checkAuto2Successors(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer, boolean hasConsumedInput) {
        return auto2.anySuccessorMatch(successor -> this.check(auto1, (SubAutomaton)successor, hasConsumedInput));
    }
}

