/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.php;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;

public class PhpRegexFlags {
    public static final int PCRE_CASELESS = 2;
    public static final int PCRE_MULTILINE = 8;
    public static final int PCRE_DOTALL = 32;
    public static final int PCRE_EXTENDED = 4;
    public static final int PCRE_UTF8 = 256;

    private PhpRegexFlags() {
    }

    public static FlagSet parseFlags(String flags) {
        FlagSet flagSet = new FlagSet();
        for (char modifier : flags.toCharArray()) {
            Optional.ofNullable(PhpRegexFlags.parseFlag(modifier)).ifPresent(flagSet::add);
        }
        return flagSet;
    }

    @CheckForNull
    public static Integer parseFlag(char ch) {
        switch (ch) {
            case 'i': {
                return 2;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'u': {
                return 256;
            }
            case 'x': {
                return 4;
            }
        }
        return null;
    }
}

