/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui;

import com.google.common.reflect.Reflection;
import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.EStartableComponent;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.config.IDistributionLayerConfiguration;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.GlobalSchemaRegistry;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.InstanceIdOption;
import com.teamscale.core.rest.client.HttpClientUtils;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.runtime.api.ProcessIdManager;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.WarmUpStorageSystemTrigger;
import com.teamscale.core.runtime.impl.scheduling.PeriodicMaintenanceJobRegistry;
import com.teamscale.core.runtime.impl.worker.WorkerCluster;
import com.teamscale.core.shutdown.ShutdownManager;
import com.teamscale.core.tfs.TeamscaleTfsConnectionAdvisor;
import com.teamscale.core.user.UserUtils;
import com.teamscale.core.utils.FileWatcher;
import com.teamscale.index.backup.snapshot.StorageSnapshotBackupUtils;
import com.teamscale.index.check.ChecksDescriptionsLoader;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.ArtifactVersionUtil;
import com.teamscale.index.external.tools.ToolAvailabilityCheckTrigger;
import com.teamscale.index.fileloaders.FileLoaderRegistry;
import com.teamscale.index.fileloaders.IFileLoader;
import com.teamscale.index.fileloaders.TeamscaleBackupFileLoader;
import com.teamscale.index.monitoring.prometheus.PrometheusMetricsUploader;
import com.teamscale.index.repository.artifact_store.external_storage.ExternalStorageConstants;
import com.teamscale.index.repository.git.GitConfigSystemReader;
import com.teamscale.index.repository.sap.abapsystem.importer.snc.SncCredentialsManager;
import com.teamscale.index.requirements_tracing.index.SpecItemDescriberInitializer;
import com.teamscale.index.sap.AbapTeamscaleSyncIndex;
import com.teamscale.index.system_info.JavaSystemInfoFragment;
import com.teamscale.index.system_info.StorageSystemPerformanceInfoFragment;
import com.teamscale.index.system_info.SystemInfoCollector;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.index.system_info.TeamscaleSystemInfoFragment;
import com.teamscale.index.utils.ClockDriftDetector;
import com.teamscale.service.DevFolderLocator;
import com.teamscale.service.admin.compaction.DatabaseCleanupMaintenanceTrigger;
import com.teamscale.service.framework.IServiceServerFactory;
import com.teamscale.service.framework.ServerStartFailedException;
import com.teamscale.service.monitoring.prometheus.PrometheusMetricService;
import com.teamscale.service.project.DefaultArtifacts;
import com.teamscale.service.project.wizard.ImportWizardRegistry;
import com.teamscale.service.system.health.GlobalStorageMetricsProvider;
import com.teamscale.ui.StorageShardingSupport;
import com.teamscale.ui.TeamscaleStartUtils;
import com.teamscale.ui.TrustStoreValidationException;
import com.teamscale.ui.TrustStoreValidator;
import com.teamscale.ui.TypedefExportWrapper;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.ConfigurationException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.monitoring.MonitoringToggle;
import org.conqat.engine.persistence.store.monitoring.OperationMonitor;
import org.conqat.engine.persistence.store.monitoring.StorageSystemMonitor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.net.TrustAllCertificatesManager;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class TeamscaleStarter
extends CommandLineBase<NeverThrownRuntimeException> {
    private static final String GENERATED_TYPEDEFS_DIR = "src/typedefs";
    private static final String CRYPTO_FAILED_MESSAGE = "Testing cryptography failed. Most likely your JVM does not support the Unlimited Strength Jurisdiction Policy. Please see the user guide for details and install a recent version of Java. \nCurrent version used: ";
    private static final String CRYPTO_FILE_NAME = "teamscale.key";
    private static final String DEFAULT_CONFIG_FILE_NAME = "teamscale.properties";
    private static final String ADMIN_SETTINGS_FILE_NAME = "admin-settings.json";
    private static final String TEAMSCALE_GIT_CONFIG_FILE_NAME = "teamscale-git.config";
    private static final boolean DISABLE_SSL_CERTIFICATE_VALIDATION_COMPLETELY = Boolean.getBoolean("com.teamscale.disable-ssl-certificate-validation");
    private static final String SNAPSHOT_LOAD_LOCATION_PARAMETER = "com.teamscale.snapshot-backup.load-location";
    private static final Logger LOGGER = LogManager.getLogger();
    private IndexLayer indexLayer;
    private ILockProvider lockProvider;
    private IMessageBroker messageBroker;
    private final List<File> startupFiles = new ArrayList<File>();
    private boolean exitAfterStartup = false;
    private File configFile;
    private File backupFileToWriteOnStart;
    private File storeSizeFileToWriteOnStart;
    private StorageShardingSupport shardingSupport;
    private FileWatcher adminSettingsFileWatcher;
    private TeamscaleStartUtils.AdminSettingsPartialValidator adminSettingsValidator;

    public static void main(String[] args) {
        LoggingUtils.OPERATIONS_LOGGER.info("Starting Teamscale");
        TeamscaleStarter.activateCppcheckPremiumIfLicensed();
        if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            EFeatureToggle.AUDIT_FEATURES.setFeatureToggle(true);
            EFeatureToggle.AI_SUPPORT.setFeatureToggle(true);
        }
        TeamscaleStarter.executeTypedefExporter();
        TeamscaleStarter.registerMaintenanceTriggers();
        TeamscaleStarter.execute(TeamscaleStarter::new, (String[])args);
    }

    private static void activateCppcheckPremiumIfLicensed() {
        if (LicenseManager.getInstance().isCppcheckPremiumLicensed()) {
            EFeatureToggle.CPPCHECK_PREMIUM_LICENSED.setFeatureToggle(true);
        }
    }

    private static void executeTypedefExporter() {
        if (!EFeatureToggle.isInUiDevServerMode()) {
            return;
        }
        File webappBundleRoot = TeamscaleStarter.getWebAppBundleRoot();
        CCSMAssert.isNotNull((Object)webappBundleRoot, (String)"com.teamscale.ui module not found!");
        File generatedTypedefsFolder = new File(webappBundleRoot, GENERATED_TYPEDEFS_DIR);
        TypedefExportWrapper.generateTsDataClasses(generatedTypedefsFolder);
    }

    private static File getUiBundleRoot() {
        File uiModule;
        File server = TeamscaleStarter.findParentFolderNamed(new File("").getAbsoluteFile(), "server");
        String teamscaleUiPackageName = Reflection.getPackageName(TeamscaleStarter.class);
        if (server == null) {
            if (new File("server", teamscaleUiPackageName).isDirectory()) {
                server = new File("server");
            } else {
                File idea = TeamscaleStarter.findParentFolderNamed(new File("").getAbsoluteFile(), ".idea");
                server = new File(idea, "../server");
                if (!new File(server, teamscaleUiPackageName).isDirectory()) {
                    return null;
                }
            }
        }
        if ((uiModule = new File(server, teamscaleUiPackageName)).isDirectory()) {
            return uiModule;
        }
        return null;
    }

    public static File getWebAppBundleRoot() {
        File uiBundleRoot = TeamscaleStarter.getUiBundleRoot();
        if (uiBundleRoot != null) {
            return new File(uiBundleRoot, "../../webapp");
        }
        return null;
    }

    public static File getDocsProjectRoot() {
        File uiBundleRoot = TeamscaleStarter.getUiBundleRoot();
        if (uiBundleRoot != null) {
            return new File(uiBundleRoot, "../../docs");
        }
        return null;
    }

    private static File findParentFolderNamed(File file, String folderName) {
        File parentFolder = file;
        do {
            if (!parentFolder.getName().equals(folderName)) continue;
            return parentFolder;
        } while ((parentFolder = parentFolder.getParentFile()) != null);
        return null;
    }

    protected void run() {
        try {
            if (DISABLE_SSL_CERTIFICATE_VALIDATION_COMPLETELY) {
                TeamscaleStarter.disableCertificateValidationCompletely();
            } else {
                TrustStoreValidator.validateTrustStoreConfiguration();
            }
            TeamscaleStarter.setupCryptoKeys();
            ServerConfiguration configuration = this.getConfiguration();
            configuration.logConfigSettings();
            this.loadAdminSettingsFile();
            this.loadGitConfigFile();
            CheckRegistry.getInstance().registerCustomChecksDirectory(configuration.getCustomChecksDirectory());
            this.configureDistributionInfrastructure(configuration);
            DatabaseConfiguration databaseConfiguration = configuration.getDatabaseConfiguration();
            ExternalStorageConstants.registerProjectConfigurationHooks();
            this.initializeIndexLayerAndStorage(configuration, databaseConfiguration);
            TeamscaleStartUtils.dumpBackupIfRequested(this.backupFileToWriteOnStart, this.indexLayer, this.lockProvider, configuration.toInstanceConfiguration());
            TeamscaleStartUtils.dumpStoreSizesIfRequested(this.storeSizeFileToWriteOnStart, this.indexLayer);
            this.indexLayer = TeamscaleStarter.installStorageMonitoring(this.indexLayer);
            ChecksDescriptionsLoader.loadCheckDescriptions(this::readCheckDescriptionFromMarkdownFile, (IndexLayer)this.indexLayer, (File)configuration.getCustomChecksDirectory());
            InstanceIdOption.ensureIdPresent((IndexLayer)this.indexLayer);
            if (this.shardingSupport != null) {
                this.shardingSupport.connectToStorageLayer(this.indexLayer);
            }
            this.initializeIndicesAndHelper();
            if (this.adminSettingsValidator != null) {
                this.adminSettingsValidator.setIndexLayer(this.indexLayer);
                this.adminSettingsValidator.validate();
            }
            SncCredentialsManager.createSNCCredentials();
            this.createWorkerCluster(configuration);
            ClockDriftDetector.setup((IMessageBroker)this.messageBroker);
            this.startSystemInfoCollection(configuration);
            this.loadStartupFiles(configuration);
            if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled() || EFeatureToggle.ENABLE_PROJECT_WIZARD.isEnabled()) {
                TeamscaleStarter.loadSampleProjects();
            }
            this.createServiceServer(configuration);
            this.registerPrometheusMonitoring(configuration);
            ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(WarmUpStorageSystemTrigger.class, "Warming up storage system for Teamscale start", this.indexLayer);
            ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(ToolAvailabilityCheckTrigger.class, "Tool availability check", this.indexLayer);
            TeamscaleStarter.printStartupSuccessMessage(configuration);
            if (this.exitAfterStartup) {
                System.exit(0);
            }
        }
        catch (MigrationException | ServerStartFailedException | TrustStoreValidationException | IOException | ConfigurationException | ConQATException e) {
            String message = "Error during startup: " + e.getMessage() + ". Terminating!";
            LOGGER.fatal(message, e);
            System.err.println(message);
            System.exit(1);
        }
    }

    private void registerPrometheusMonitoring(ServerConfiguration serverConfiguration) {
        PrometheusMetricsUploader.setInstanceName((String)serverConfiguration.getInstanceName());
        PrometheusMetricService.registerAll((IndexLayer)this.indexLayer);
    }

    private static void loadSampleProjects() {
        List<Resource> resources;
        File userFolder;
        File devSampleProjectsFolder = DevFolderLocator.getFileInTeamscaleRepository((String)"data/sample-projects");
        if (devSampleProjectsFolder != null && devSampleProjectsFolder.exists()) {
            ImportWizardRegistry.registerPath((Path)devSampleProjectsFolder.toPath(), (ImportWizardRegistry.EProjectType)ImportWizardRegistry.EProjectType.DEV);
        }
        if ((userFolder = new File(FileSystemUtils.getUserHomeDir(), ".teamscale/sample-projects")).exists()) {
            ImportWizardRegistry.registerPath((Path)userFolder.toPath(), (ImportWizardRegistry.EProjectType)ImportWizardRegistry.EProjectType.USER);
        }
        if (!(resources = ResourceUtils.listResourcesRecursively(TeamscaleStarter.class, (String)"sample-projects").stream().filter(resource -> resource.hasExtension(new String[]{"toml"})).toList()).isEmpty()) {
            ImportWizardRegistry.registerResources(resources, (ImportWizardRegistry.EProjectType)ImportWizardRegistry.EProjectType.PUBLIC);
        }
    }

    private static void registerMaintenanceTriggers() {
        if (EFeatureToggle.CLEANUP_ORPHANED_DATABASE_ENTIRES.isEnabled()) {
            TeamscaleStarter.registerDailyMaintenanceTrigger(DatabaseCleanupMaintenanceTrigger.class);
        }
    }

    private static void registerDailyMaintenanceTrigger(Class<? extends PrivilegedTriggerBase> triggerClass) {
        PeriodicMaintenanceJobRegistry.getInstance().addScheduledTrigger(PeriodicMaintenanceJobRegistry.DAILY_CRON_EXPRESSION, triggerClass);
    }

    private void initializeIndexLayerAndStorage(ServerConfiguration configuration, DatabaseConfiguration databaseConfiguration) throws StorageException, MigrationException, ConfigurationException {
        this.startInitializationOfIndexLayerAndStorageSupport(configuration, databaseConfiguration);
        this.addShutdownHook();
        this.checkForStorageSnapshotLoad();
        GlobalStorageSystem globalStorageSystem = this.initializeGlobalStorageSystem(configuration);
        this.finishInitializationOfIndexLayerAndStorageSupport();
        this.loadTeamscaleDefaults(globalStorageSystem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> readCheckDescriptionFromMarkdownFile(String checkName) {
        String descriptionsMarkdownFilePath = "/check-descriptions/" + checkName + ".md";
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(descriptionsMarkdownFilePath);){
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> stringBuilder.append((String)line).append("\n"));
                Optional<String> optional = Optional.of(stringBuilder.toString().trim());
                return optional;
            }
            LOGGER.warn("Markdown file [" + descriptionsMarkdownFilePath + "] not found in loaded check libraries");
            return Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Could not read description for check: " + descriptionsMarkdownFilePath + " Error: " + String.valueOf(e));
        }
        return Optional.empty();
    }

    private void initializeIndicesAndHelper() throws StorageException {
        SpecItemDescriberInitializer.initializeDescriber((IndexLayer)this.indexLayer);
        TeamscaleStarter.clearSapSystemUpdateIndex(this.indexLayer);
    }

    private void startInitializationOfIndexLayerAndStorageSupport(ServerConfiguration configuration, DatabaseConfiguration databaseConfiguration) throws StorageException {
        IStorageSystemProvider rawStorageSystemProvider;
        Optional shardingDescription = databaseConfiguration.getShardingDescription();
        if (shardingDescription.isEmpty()) {
            rawStorageSystemProvider = TeamscaleStarter.createSingleStorageSystemProvider(configuration, databaseConfiguration);
        } else {
            this.shardingSupport = new StorageShardingSupport(configuration, databaseConfiguration);
            rawStorageSystemProvider = this.shardingSupport.createStorageSystemProvider((String)shardingDescription.get());
        }
        rawStorageSystemProvider = GlobalStorageMetricsProvider.installIfEnabled((IStorageSystemProvider)rawStorageSystemProvider);
        this.indexLayer = new IndexLayer(rawStorageSystemProvider, StorageCacheRegistry.createCacheProvider((IMessageBroker)this.messageBroker), this.messageBroker, databaseConfiguration.getStorageDirectory());
    }

    private void finishInitializationOfIndexLayerAndStorageSupport() throws StorageException {
        if (this.shardingSupport != null) {
            this.shardingSupport.setGlobalMetaIndex(this.indexLayer.openMetaIndex());
        }
    }

    public static IStorageSystemProvider createSingleStorageSystemProvider(ServerConfiguration configuration, DatabaseConfiguration databaseConfiguration) throws StorageException {
        return databaseConfiguration.createStorageSystemProvider(configuration.getNumWorkers());
    }

    private static IndexLayer installStorageMonitoring(IndexLayer indexLayer) throws StorageException {
        if (!MonitoringToggle.ENABLE_STORAGE_MONITORING) {
            return indexLayer;
        }
        long threshold = Long.MAX_VALUE;
        OperationMonitor.ISlowOperationReporter reporter = OperationMonitor.ISlowOperationReporter.EMPTY;
        if (MonitoringToggle.ENABLE_SLOW_OPERATION_REPORTING) {
            threshold = MonitoringToggle.SLOW_OPERATION_MONITORING_THRESHOLD_NANOS;
            reporter = (operationName, storeName, runtimeNanos, keyCount) -> LOGGER.atWarn().withLocation().log("Slow operation monitoring has been enabled. The following stack-trace is not a bug, but the call location of the slow operation.\nOperation of type {} on store {} and {} keys took {} milliseconds", (Object)operationName, (Object)storeName, (Object)keyCount, (Object)((double)runtimeNanos / 1000000.0));
        }
        StorageSystemMonitor monitor = new StorageSystemMonitor(threshold, reporter);
        indexLayer = indexLayer.decorate((IStorageSystemProviderDecorator)monitor);
        TeamscaleStarter.startStorageSystemPerformanceDataCollection(indexLayer, monitor);
        return indexLayer;
    }

    private static void startStorageSystemPerformanceDataCollection(IndexLayer indexLayer, final StorageSystemMonitor monitor) throws StorageException {
        final SystemInfoIndex systemInfoIndex = (SystemInfoIndex)indexLayer.openGlobalIndex(SystemInfoIndex.class);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    systemInfoIndex.insertFragment((SystemInfoFragmentBase)new StorageSystemPerformanceInfoFragment(monitor.reportAndResetAll()));
                }
                catch (StorageException e) {
                    LOGGER.error("Error while collecting storage system performance data: " + e.getMessage(), (Throwable)e);
                }
            }
        };
        new Timer("Storage monitoring", true).scheduleAtFixedRate(task, 5000L, 5000L);
    }

    private void checkForStorageSnapshotLoad() throws StorageException {
        String snapshotLoadLocation = System.getProperty(SNAPSHOT_LOAD_LOCATION_PARAMETER);
        if (StringUtils.isEmpty((String)snapshotLoadLocation)) {
            return;
        }
        if (IndexSchema.hasSchema((IStorageSystem)this.indexLayer.openRawGlobalStorageSystem())) {
            LOGGER.error("Attempting to load a snapshot backup in a non-empty database! Skipping snapshot import.");
            return;
        }
        LOGGER.warn("Loading storage snapshot backup from " + snapshotLoadLocation + ", which will take some time and delay start up of the server. The web UI and REST API will not be available until loading is completed (you will see another log message then).");
        try {
            StorageSnapshotBackupUtils.readSnapshotBackup((String)snapshotLoadLocation, (IndexLayer)this.indexLayer);
            LOGGER.warn("Loading of the storage snapshot backup completed. Will continue with normal operation.");
        }
        catch (IOException | StorageException e) {
            LOGGER.error("Failed to load snapshot backup: " + e.getMessage(), e);
            LOGGER.error("Terminating!");
            System.exit(1);
        }
    }

    private GlobalStorageSystem initializeGlobalStorageSystem(ServerConfiguration configuration) throws StorageException, ConfigurationException, MigrationException {
        TeamscaleStarter.prepareGlobalSchema(this.indexLayer);
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        this.checkTeamscaleVersion(globalStorageSystem, configuration);
        ((CriticalSystemStateIndex)this.indexLayer.openGlobalIndex(CriticalSystemStateIndex.class)).clearStatus();
        return globalStorageSystem;
    }

    private void configureDistributionInfrastructure(ServerConfiguration configuration) {
        IDistributionLayerConfiguration layerConfiguration = configuration.getDistributionConfiguration().getLayerConfiguration();
        this.lockProvider = layerConfiguration.getLockProvider();
        this.messageBroker = layerConfiguration.getMessageBroker();
    }

    private static void disableCertificateValidationCompletely() throws ConQATException {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new TrustAllCertificatesManager()}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ConQATException("Could not disable SSL", (Throwable)e);
        }
        SSLContext.setDefault(sslContext);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((host, sslSession) -> true);
        HttpClientUtils.overwriteSslContextAndHostnameVerifier((SSLContext)sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        TeamscaleTfsConnectionAdvisor.overwriteSslContext((SSLContext)sslContext);
        Retrofit.overwriteSslContext((SSLContext)sslContext);
    }

    private static void printStartupSuccessMessage(ServerConfiguration configuration) {
        TeamscaleStarter.printInfo((String)"Teamscale started successfully");
        if (EStartableComponent.SERVICE_SERVER.isEnabled()) {
            if (configuration.isHttpConfigured()) {
                TeamscaleStarter.printInfo((String)("-> Listening on http://localhost:" + configuration.getHttpPort()));
            }
            if (configuration.isHttpsConfigured()) {
                TeamscaleStarter.printInfo((String)("-> Listening on https://localhost:" + configuration.getHttpsPort()));
            }
        }
    }

    private void loadTeamscaleDefaults(GlobalStorageSystem globalStorageSystem) throws StorageException, MigrationException {
        UserUtils.createDefaultUser((IndexLayer)this.indexLayer);
        AnalysisProfileUtils.createDefaultAnalysisProfiles((GlobalStorageSystem)globalStorageSystem);
        DefaultArtifacts.loadDefaultDashboardTemplates((GlobalStorageSystem)globalStorageSystem);
        DefaultArtifacts.loadDefaultThresholdProfiles((GlobalStorageSystem)globalStorageSystem);
    }

    private void createWorkerCluster(ServerConfiguration configuration) throws StorageException {
        if (EStartableComponent.WORKER.isEnabled()) {
            new WorkerCluster(configuration.getNumWorkers(), configuration.toInstanceConfiguration(), ProcessIdManager.getProcessId()).runEmbedded(this.indexLayer, this.lockProvider);
        }
    }

    private void createServiceServer(ServerConfiguration configuration) throws StorageException {
        if (EStartableComponent.SERVICE_SERVER.isEnabled()) {
            IServiceServerFactory.getInstance().createServer(configuration).startServer(this.indexLayer, this.lockProvider);
        }
    }

    private void startSystemInfoCollection(ServerConfiguration configuration) throws StorageException {
        File storageDirectory = null;
        DatabaseConfiguration databaseConfiguration = configuration.getDatabaseConfiguration();
        if (databaseConfiguration.getDatabaseType().isLocalDiskBased()) {
            storageDirectory = databaseConfiguration.getStorageDirectory();
        }
        SystemInfoCollector collector = new SystemInfoCollector((ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class), this.openSystemInfoIndex(), this.indexLayer, storageDirectory);
        collector.insertFragment((SystemInfoFragmentBase)new TeamscaleSystemInfoFragment(configuration, this.indexLayer));
        collector.start();
    }

    private ServerConfiguration getConfiguration() throws IOException, ConfigurationException {
        if (this.configFile != null) {
            LOGGER.info("Using explicit configuration file: " + this.configFile.getAbsolutePath());
            return ServerConfiguration.loadFromPropertiesFile((File)this.configFile);
        }
        Optional configFile = TeamscaleInstallationUtils.locateConfigFile((String)DEFAULT_CONFIG_FILE_NAME);
        if (configFile.isPresent()) {
            LOGGER.info("Using default configuration file: " + ((File)configFile.get()).getAbsolutePath());
            return ServerConfiguration.loadFromPropertiesFile((File)((File)configFile.get()));
        }
        LOGGER.info("Using default configuration");
        return ServerConfiguration.defaultConfiguration();
    }

    private void loadAdminSettingsFile() {
        Optional adminSettingsFile = TeamscaleInstallationUtils.locateConfigFile((String)ADMIN_SETTINGS_FILE_NAME);
        if (adminSettingsFile.isEmpty()) {
            return;
        }
        String filePath = ((File)adminSettingsFile.get()).getAbsolutePath();
        LOGGER.info("Using admin settings configuration file: " + filePath);
        this.adminSettingsValidator = new TeamscaleStartUtils.AdminSettingsPartialValidator();
        this.adminSettingsFileWatcher = new FileWatcher(((File)adminSettingsFile.get()).toPath(), fileContent -> {
            LOGGER.info("Loading admin settings from configuration file: " + filePath);
            ServerOptionRegistry.getInstance().loadServerOptionsFromFileContent(fileContent);
            this.adminSettingsValidator.validate();
        });
    }

    private void loadGitConfigFile() {
        Optional gitConfigFile = TeamscaleInstallationUtils.locateConfigFile((String)TEAMSCALE_GIT_CONFIG_FILE_NAME);
        if (gitConfigFile.isEmpty()) {
            SystemReader.setInstance((SystemReader)new GitConfigSystemReader());
            return;
        }
        String filePath = ((File)gitConfigFile.get()).getAbsolutePath();
        LOGGER.info("Using git configuration file: " + filePath);
        File teamscaleGitConfig = new File(filePath);
        SystemReader.setInstance((SystemReader)new GitConfigSystemReader(teamscaleGitConfig));
    }

    private static void setupCryptoKeys() throws ConQATException {
        try {
            SecretKeySpec defaultKey = EncryptedStorageHandler.getDefaultKey();
            Optional keyFile = TeamscaleInstallationUtils.locateConfigFile((String)CRYPTO_FILE_NAME);
            if (keyFile.isPresent()) {
                LOGGER.info("Using encryption key from " + ((File)keyFile.get()).getAbsolutePath());
                EncryptedStorageHandler.setPrimaryKey((SecretKeySpec)EncryptedStorageHandler.createKey((File)((File)keyFile.get())));
                EncryptedStorageHandler.addAlternativeKey((SecretKeySpec)defaultKey);
            } else {
                LOGGER.info("Using default key for encryption");
                EncryptedStorageHandler.setPrimaryKey((SecretKeySpec)defaultKey);
            }
            for (File alternativeKey : TeamscaleInstallationUtils.listConfigFiles().filter(file -> file.getName().endsWith(".key")).toList()) {
                LOGGER.info("Using alternate encryption key from " + alternativeKey.getAbsolutePath());
                EncryptedStorageHandler.addAlternativeKey((SecretKeySpec)EncryptedStorageHandler.createKey((File)alternativeKey));
            }
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            TeamscaleStarter.handleCryptoFailedError(e);
        }
        try {
            EncryptedStorageHandler.encrypt((byte[])StringUtils.randomString((int)20).getBytes(StandardCharsets.UTF_8), (SecretKeySpec)EncryptedStorageHandler.getPrimaryKey());
        }
        catch (StorageException e) {
            TeamscaleStarter.handleCryptoFailedError((Exception)((Object)e));
        }
    }

    private static void handleCryptoFailedError(Exception e) throws ConQATException {
        e.printStackTrace();
        throw new ConQATException(CRYPTO_FAILED_MESSAGE + new JavaSystemInfoFragment().toJavaInfo() + " (" + e.getMessage() + ")", (Throwable)e);
    }

    private void loadStartupFiles(ServerConfiguration configuration) {
        try {
            for (File startupFile : this.startupFiles) {
                IFileLoader loader = FileLoaderRegistry.getInstance().getFileLoader(startupFile, LOGGER);
                if (loader == null) {
                    System.exit(1);
                    return;
                }
                LOGGER.info(loader.loadFile(startupFile, this.indexLayer, this.lockProvider, configuration.toInstanceConfiguration()));
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            LOGGER.fatal("Problem loading the given startup files: " + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private void addShutdownHook() {
        ShutdownManager.getInstance().addShutdownHook(() -> {
            try {
                if (this.adminSettingsFileWatcher != null) {
                    this.adminSettingsFileWatcher.close();
                }
                this.openSystemInfoIndex().removeEntries(ProcessIdManager.getProcessId());
                LOGGER.info("Shut down of storage system.");
                this.indexLayer.getRawStorageSystemProvider().close();
                LoggingUtils.OPERATIONS_LOGGER.info("Teamscale shutdown finished");
            }
            catch (StorageException e) {
                LOGGER.error("Unclean shutdown: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private SystemInfoIndex openSystemInfoIndex() throws StorageException {
        return (SystemInfoIndex)this.indexLayer.openGlobalIndex(SystemInfoIndex.class);
    }

    private static void prepareGlobalSchema(IndexLayer indexLayer) throws StorageException {
        IStorageSystem globalStoragePartition = indexLayer.openRawGlobalStorageSystem();
        if (!IndexSchema.hasSchema((IStorageSystem)globalStoragePartition)) {
            LOGGER.info("Applying global schema");
            GlobalSchemaRegistry.getInstance().getSchema().save(globalStoragePartition, indexLayer.getStorageSystemCacheProvider("__global__").getCacheAccess(IndexSchemaCache.class));
        }
    }

    private void checkTeamscaleVersion(GlobalStorageSystem globalStorageSystem, ServerConfiguration configuration) throws StorageException, ConfigurationException {
        MetaIndex metaIndex = (MetaIndex)globalStorageSystem.openGlobalIndex(MetaIndex.class);
        EStorageSystemVersion storedVersion = (EStorageSystemVersion)metaIndex.getValue(EStorageSystemVersion.class);
        if (storedVersion == null) {
            ArtifactVersionUtil.writeCurrentVersionInfoToMetaIndex((MetaIndex)metaIndex);
        } else if (storedVersion != EStorageSystemVersion.CURRENT_VERSION) {
            LOGGER.fatal("Storage system has format for Teamscale version " + String.valueOf(storedVersion) + " but this instance is Version " + String.valueOf(EStorageSystemVersion.CURRENT_VERSION));
            File backupFile = new File("teamscale-backup.zip");
            int counter = 1;
            while (backupFile.exists()) {
                backupFile = new File("teamscale-backup-" + counter++ + ".zip");
            }
            TeamscaleStartUtils.dumpBackupFile(backupFile, this.indexLayer, this.lockProvider, configuration.toInstanceConfiguration());
            throw new ConfigurationException("Version mismatch of storage system data! See log for details.");
        }
    }

    @Option(shortName=99, longName="config-file", description="Sets the config file.")
    public void setConfigFile(String configFile) {
        this.configFile = new File(configFile);
    }

    @Option(shortName=98, longName="dump-backup", description="Dumps a backup during startup")
    public void setDumpBackup(String backupFilePath) {
        this.backupFileToWriteOnStart = new File(backupFilePath);
    }

    @Option(longName="dump-store-size", description="Dumps statistics on store size during startup")
    public void setDumpStoreSize(String soreSizeFilePath) {
        this.storeSizeFileToWriteOnStart = new File(soreSizeFilePath);
    }

    @Option(shortName=108, longName="load", greedy=true, description="File to load after startup.")
    public void addStartupFile(String startupFilename) {
        File startupFile = new File(startupFilename);
        if (!startupFile.exists()) {
            throw new IllegalArgumentException("File to load at startup not found (file does not exist): " + startupFilename);
        }
        this.startupFiles.add(startupFile);
    }

    @Option(longName="exit-after-startup", description="If set, Teamscale will immediately exit after a successful startup. This will also disable validation for projects imported via -l/--load.")
    public void exitAfterStartup() {
        this.exitAfterStartup = true;
        TeamscaleBackupFileLoader.enableSkipValidationOnBackupImport();
    }

    private static void clearSapSystemUpdateIndex(IndexLayer indexLayer) throws StorageException {
        AbapTeamscaleSyncIndex abapTeamscaleSyncIndex = (AbapTeamscaleSyncIndex)indexLayer.openGlobalIndex(AbapTeamscaleSyncIndex.class);
        abapTeamscaleSyncIndex.removeAllStates();
    }
}

