/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.code;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.user.UserOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.ui.option.CodeContainerVisibleMetricsOption;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/default-hidden-metrics")
public class DefaultHiddenMetricsService
extends ApiBase {
    @GET
    @Path(value="{uniformPathType: .*}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get hidden metrics", description="Returns the names of the metrics that are hidden by default in the project", tags={"Metrics", "Project"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public List<String> getDefaultHiddenMetrics(@PathParam(value="uniformPathType") UniformPath.EType uniformPathType, @QueryParam(value="option-name") @Parameter(required=true, description="the option name for which the default hidden metrics should be returned") String optionName) throws StorageException {
        UserOptionIndex optionIndex = (UserOptionIndex)this.openGlobalIndex(UserOptionIndex.class);
        IOption option = optionIndex.getOption(optionName);
        if (option == null && (optionName.equals("code.container.metrics.visibility") || optionName.equals("architecture.container.metrics.visibility"))) {
            return this.calculateHiddenMetrics(uniformPathType);
        }
        return CollectionUtils.emptyList();
    }

    private List<String> calculateHiddenMetrics(UniformPath.EType uniformPathType) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPathType, (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema();
        return CollectionUtils.filterAndMap((Collection)schema.getAllEntries(), entry -> !CodeContainerVisibleMetricsOption.DEFAULT_VISIBLE_METRICS.contains(entry.getName()), MetricDirectorySchemaEntry::getName);
    }
}

