/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.resources;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.cache.Cache;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.zip.Adler32;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Hidden
@Path(value="custom.css")
public class CustomCssService {
    public static final String CUSTOM_CSS_FILE = "custom.css";

    @GET
    @RequiresNoLogin
    @Produces(value={"text/css"})
    @Cache(maxAge=31536000)
    public byte[] getCustomCss() throws IOException {
        return FileSystemUtils.readFileBinary((File)CustomCssService.getCustomCssFile().orElseThrow(NotFoundException::new));
    }

    private static Optional<File> getCustomCssFile() {
        return TeamscaleInstallationUtils.locateConfigFile((String)CUSTOM_CSS_FILE);
    }

    public static String getCustomCssUrl() throws IOException {
        Optional<File> cssFile = CustomCssService.getCustomCssFile();
        if (cssFile.isEmpty()) {
            return null;
        }
        byte[] bytes = FileSystemUtils.readFileBinary((File)cssFile.get());
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        return "custom.css?" + Long.toHexString(checksum.getValue());
    }
}

