/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.resources;

import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.ui.ETeamscalePerspective;
import com.teamscale.ui.TeamscaleStarter;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;

@Hidden
@Path(value="")
public class WebUiAssetService {
    public static final String ASSETS_PATH = "assets/";
    public static final String RESOURCE_PATHS = "images/|js-libs/|styles/|public/|src/|favicon|safari_pinned_tab_icon|apple-touch-icon|robots";
    private static final String META_INF_WEB = "META-INF/web/";

    @GET
    @Path(value="{path: assets/[\\w\\-./~@]*\\.(woff2?|eot|ttf|js|map|svg|ico|png|css|txt|jpe?g|gif)}")
    @RequiresNoLogin
    @Produces(value={"font/woff", "font/woff2", "application/vnd.ms-fontobject", "font/ttf", "text/javascript", "application/octet-stream", "image/svg+xml", "image/x-icon", "image/png", "text/css", "text/plain", "image/jpeg", "image/gif"})
    @Cache(maxAge=31536000)
    public Response getAssetsFile(@PathParam(value="path") String path) {
        byte[] content = WebUiAssetService.getResource(path);
        return ResponseUtils.getResponseForAsset((String)path, (byte[])content);
    }

    @GET
    @Path(value="{path: (images/|js-libs/|styles/|public/|src/|favicon|safari_pinned_tab_icon|apple-touch-icon|robots)[\\w\\-./~@]*\\.(js|map|css|txt)}")
    @RequiresNoLogin
    @Produces(value={"text/javascript", "application/octet-stream", "text/css", "text/plain"})
    @Cache(maxAge=31536000)
    public Response getCachedResourceFile(@PathParam(value="path") String path) {
        byte[] content = WebUiAssetService.getResource(path);
        return ResponseUtils.getResponseForAsset((String)path, (byte[])content);
    }

    protected static byte[] getResource(String fileName) {
        Optional<byte[]> resourceInDevMode = WebUiAssetService.getResourceInDevMode(fileName);
        if (resourceInDevMode.isPresent()) {
            return resourceInDevMode.get();
        }
        String resourcePath = META_INF_WEB + fileName;
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resource == null) {
            throw new NotFoundException(fileName + " does not exist!");
        }
        return Resource.of(ETeamscalePerspective.class, (String)resourcePath, (URL)resource).getAsByteArray();
    }

    private static Optional<byte[]> getResourceInDevMode(String fileName) {
        if (EFeatureToggle.isInUiTestServerMode()) {
            return Optional.empty();
        }
        try {
            File publicDir;
            File webappBundleRoot = TeamscaleStarter.getWebAppBundleRoot();
            if (EFeatureToggle.isInUiDevServerMode()) {
                publicDir = new File(webappBundleRoot, "public");
            } else if (webappBundleRoot != null) {
                publicDir = new File(webappBundleRoot, "build/vite");
            } else {
                return Optional.empty();
            }
            File publicFile = new File(publicDir, fileName);
            if (publicFile.exists()) {
                return Optional.of(FileSystemUtils.readFileBinary((File)publicFile));
            }
            if (!(EFeatureToggle.DISABLE_UI_DEV_SERVER_MODE.isEnabled() || !fileName.equals("index.html") && fileName.startsWith("node_modules"))) {
                return Optional.of(FileSystemUtils.readFileBinary((File)new File(webappBundleRoot, fileName)));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new NotFoundException(fileName + " does not exist!");
        }
    }
}

