/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import com.teamscale.commons.service.client.IDeserializationFormat;
import com.teamscale.commons.service.client.ISerializationFormat;
import com.teamscale.commons.service.client.ServerDetails;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.commons.service.client.ServiceClientCallable;
import com.teamscale.commons.service.client.ServiceClientUtils;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRequest<T> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withHttpClient(CloseableHttpClient client, ServiceClientCallable<T> callable) throws ServiceCallException {
        try (CloseableHttpClient c = client;){
            T t = callable.call((HttpClient)c);
            return t;
        }
        catch (IOException e) {
            throw new ServiceCallException("Problem closing HTTP client: " + e.getMessage(), e);
        }
    }

    public static <T> T with(ServerDetails serverDetails, ServiceClientCallable<T> callable) throws ServiceCallException {
        return HttpRequest.withHttpClient(ServiceClientUtils.getHttpClient(serverDetails), callable);
    }

    public static <R> ServiceClientCallable<R> get(IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpRequestBase)new HttpGet(uri), deserializationFormat);
    }

    public static <S, T extends S, R> ServiceClientCallable<R> post(ISerializationFormat<S> serializationFormat, T data, IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpEntityEnclosingRequestBase)new HttpPost(uri), serializationFormat, data, deserializationFormat);
    }

    public static <R> ServiceClientCallable<R> post(IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpRequestBase)new HttpPost(uri), deserializationFormat);
    }

    public static <S, T extends S, R> ServiceClientCallable<R> put(ISerializationFormat<S> serializationFormat, T data, IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpEntityEnclosingRequestBase)new HttpPut(uri), serializationFormat, data, deserializationFormat);
    }

    @Deprecated
    public static <R> ServiceClientCallable<R> put(IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpRequestBase)new HttpPut(uri), deserializationFormat);
    }

    public static <R> ServiceClientCallable<R> delete(IDeserializationFormat<R> deserializationFormat, String uri) {
        return HttpRequest.execute((HttpRequestBase)new HttpDelete(uri), deserializationFormat);
    }

    private static <R> ServiceClientCallable<R> execute(HttpRequestBase httpRequest, IDeserializationFormat<R> deserializationFormat) {
        return client -> ServiceClientUtils.executeRequest(client, httpRequest, deserializationFormat.getMimeType().orElse(null), deserializationFormat::deserialize);
    }

    private static <S, T extends S, R> ServiceClientCallable<R> execute(HttpEntityEnclosingRequestBase httpRequest, ISerializationFormat<S> serializationFormat, T data, IDeserializationFormat<R> deserializationFormat) {
        serializationFormat.getMimeType().ifPresent(mimeType -> httpRequest.setHeader("Content-Type", mimeType.getType()));
        httpRequest.setEntity(serializationFormat.toHttpEntity(data));
        return HttpRequest.execute((HttpRequestBase)httpRequest, deserializationFormat);
    }
}

