/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.LanguageGroups;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum ELanguage {
    JAVA("Java", true, "java"),
    CPP("C++", true, "cpp", "hpp", "cxx", "hxx", "cc", "hh", "h", "inc", "inl"),
    CPP_MS_CLI("MS C++/CLI", true, "cpp", "hpp", "cxx", "hxx", "cc", "hh", "h", "inc", "inl"),
    C("C", true, "c", "h", "inc"),
    OPEN_CL("OpenCL C/C++", true, "cl"),
    RUST("Rust", true, "rs"),
    VB("Visual Basic", false, "vb", "frm", "cls", "bas"),
    COBOL("COBOL", false, "cbl", "cob", "cobol", "cpy", "eco"),
    CS("C#", true, "cs"),
    ABAP("ABAP", false, "abap"),
    ABAP_DDIC("ABAP Dictionary", false, "abap_ddic"),
    ADA("Ada", false, "ada", "ads", "adb"),
    TEXT("Plain Text", false, "txt"),
    XML("XML", true, "xml", "xsl", "xslt", "architecture", "cqb", "csproj", "config", "prj"),
    SQLSCRIPT("HANA SQLScript", false, "sql", "hdbprocedure", "hdbfunction", "hdbscalarfunction", "hdbtablefunction"),
    HANA_VIEW("HANA View", true, "analyticview", "attributeview", "calculationview"),
    PLSQL("PL/SQL", false, "sql", "pks", "pkb", "trg", "fnc", "typ", "tyb", "prc", "plsql"),
    PYTHON("Python", true, "py"),
    TSQL("Transact-SQL", false, "tsql", "sql"),
    MATLAB("Matlab", true, "m"),
    PHP("PHP", true, "php", "php3", "php4", "php5"),
    JAVASCRIPT("JavaScript/TypeScript", true, "js", "sj", "jsx", "ts", "tsx"),
    LINE("Line-based Text", false, "yaml", "yml", "json"),
    DELPHI("Delphi", false, "pas", "dpr"),
    IEC61131("IEC 61131-3 ST", true, "pu", "sv", "st", "scl", "pou", "dt", "var", "tu"),
    FORTRAN("Fortran", false, "f", "for", "f77", "f90", "f95", "f03"),
    XTEND("Xtend", true, "xtend"),
    SWIFT("Swift", true, "swift"),
    OCAML("OCaml", true, "ml", "mli"),
    OSCRIPT("OScript", true, "osx", "lxe", "os"),
    GROOVY("Groovy", true, "groovy"),
    NL_REQUIREMENTS("Natural Language Requirements", false, new String[0]),
    NL_TESTS("Natural Language Tests", false, "nltests"),
    NL_ISSUES("Natural Language Issues", false, new String[0]),
    SIMULINK("Simulink and Stateflow", false, "mdl", "slx", "sldd"),
    GOSU("Gosu", true, "gsp", "gs", "gsx", "gr", "grs"),
    KOTLIN("Kotlin", true, "kt", "kts", "ktm"),
    OBJECTIVE_C("Objective-C", true, "m", "h", "c"),
    OBJECTIVE_CPP("Objective-C++", true, "mm", "h", "inc", "inl", "cpp", "hpp"),
    JAVADOC("JavaDoc", true, new String[0]),
    ABAPDOC("Abap Doc", true, new String[0]),
    GO("Go", true, "go"),
    ABAP_CDS("ABAP CDS", false, "abap_cds", "abap_ddlx", "asddls", "asddlxs", "acds"),
    POWERSHELL("Powershell", false, "ps1", "psd1", "psm1"),
    ESQL("Extended SQL (ESQL)", false, "esql"),
    KUBERNETES("Kubernetes", false, "yaml", "json", "yml"),
    DART("Dart", true, "dart"),
    TOY("Teamscale Toy Language", true, new String[0]);

    private static final EnumSet<ELanguage> LANGUAGES_WITHOUT_METHODS;
    public static final Set<ELanguage> LANGUAGES_WITH_PREPROCESSOR;
    private static final EnumSet<ELanguage> LANGUAGES_WITH_PREPROCESSOR_EXPANSIONS;
    public static final Set<ELanguage> HIDDEN_LANGUAGES;
    private static final Map<String, EnumSet<ELanguage>> EXTENSION_2_LANGUAGE_MAP;
    private final String readableName;
    private final boolean caseSensitive;
    private final String[] extensions;

    private ELanguage(String readableName, boolean caseSensitive, String ... extensions) {
        this.readableName = readableName;
        this.caseSensitive = caseSensitive;
        this.extensions = extensions;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String[] getFileExtensions() {
        return (String[])CollectionUtils.copyArray((Object[])this.extensions);
    }

    public static ELanguage fromResource(Resource resource) {
        return ELanguage.getAllLanguagesForExtension(resource.getExtension()).stream().findFirst().orElse(LINE);
    }

    @Deprecated
    public static ELanguage fromPath(String path) {
        return ELanguage.fromFile(new File(path));
    }

    @Deprecated
    public static ELanguage fromFile(File file) {
        Set<ELanguage> allLanguages = ELanguage.getAllLanguagesForExtension(FileSystemUtils.getFileExtension((File)file));
        if (allLanguages.contains((Object)CPP) && allLanguages.contains((Object)CPP_MS_CLI)) {
            allLanguages.remove((Object)CPP_MS_CLI);
        }
        return allLanguages.stream().sorted().findFirst().orElse(LINE);
    }

    public static Set<ELanguage> getAllLanguagesForExtension(String extension) {
        if (extension == null) {
            return EnumSet.noneOf(ELanguage.class);
        }
        EnumSet<ELanguage> languages = EXTENSION_2_LANGUAGE_MAP.get(extension.toLowerCase());
        if (languages == null) {
            return EnumSet.noneOf(ELanguage.class);
        }
        return EnumSet.copyOf(languages);
    }

    public static Set<ELanguage> getAllLanguagesForPath(String path) {
        return ELanguage.getAllLanguagesForExtension(FileSystemUtils.getFileExtension((String)path));
    }

    public static boolean languageHasMethods(ELanguage language) {
        return !LANGUAGES_WITHOUT_METHODS.contains((Object)language);
    }

    public boolean isObjectiveCOrObjectiveCpp() {
        return LanguageGroups.OBJECTIVE_C_AND_OBJECTIVE_CPP.contains((Object)this);
    }

    public boolean isCppOrC() {
        return LanguageGroups.C_CPP_AND_MS_CLI.contains((Object)this);
    }

    public boolean isCppOrObjectiveCpp() {
        return LanguageGroups.CPP_AND_DERIVATIVES.contains((Object)this);
    }

    public static ELanguage[] getUserVisibleLanguages() {
        if (!EFeatureToggle.SHOW_HIDDEN_LANGUAGES.isEnabled()) {
            return (ELanguage[])Arrays.stream(ELanguage.values()).filter(language -> !HIDDEN_LANGUAGES.contains(language)).toArray(ELanguage[]::new);
        }
        return ELanguage.values();
    }

    static {
        LANGUAGES_WITHOUT_METHODS = EnumSet.of(ABAP_DDIC, LINE, TEXT, XML, HANA_VIEW);
        LANGUAGES_WITH_PREPROCESSOR = EnumSet.of(ABAP, new ELanguage[]{C, CPP, CPP_MS_CLI, IEC61131, OBJECTIVE_C, OBJECTIVE_CPP, SWIFT});
        LANGUAGES_WITH_PREPROCESSOR_EXPANSIONS = EnumSet.of(C, new ELanguage[]{CPP, OBJECTIVE_C, OBJECTIVE_CPP, SWIFT, CPP_MS_CLI});
        HIDDEN_LANGUAGES = EnumSet.of(RUST, TOY);
        EXTENSION_2_LANGUAGE_MAP = new HashMap<String, EnumSet<ELanguage>>();
        for (ELanguage language : ELanguage.values()) {
            for (String extension : language.extensions) {
                EnumSet languagesForExtension = EXTENSION_2_LANGUAGE_MAP.computeIfAbsent(extension.toLowerCase(), ext -> EnumSet.noneOf(ELanguage.class));
                languagesForExtension.add(language);
            }
        }
    }
}

