/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner.ambiguous_language;

import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.LineSplitter;
import org.jspecify.annotations.Nullable;

class CLikeLanguageDetector {
    private static final String[] CPP_COMMON_KEYWORDS = new String[]{"::", "using namespace", "namespace ", "try {", "constexpr ", "virtual ", "reinterpret_cast", "static_cast", "const_cast", "nullptr", "extern \"C\""};
    private static final Pattern CPP_PATTERN = Pattern.compile("(?<!@)class\\s[A-Z]|=\\snew\\s|(^|\\s)throw\\s[A-Z]|template\\s*<");
    private static final String[] OBJECTIVE_C_COMMON_KEYWORDS = new String[]{"@end", "@interface", "@property", "@protocol", "@import", "@class", "#import", "@autoreleasepool", "NSLog"};
    private static final Pattern OBJECTIVE_C_COMMON_TYPES_HINT_PATTERN = Pattern.compile("\\W?(NSString|NSMutableString|NSMutableArray|NSSet|NSDictionary|NSMutableDictionary|NSArray)\\W");
    private boolean currentlyInMultilineComment = false;
    private int currentPositionInLine = 0;
    private final EnumSet<ELanguage> languagesToSearchFor;
    private final EnumSet<ELanguage> detectedLanguagePatterns = EnumSet.noneOf(ELanguage.class);

    private CLikeLanguageDetector(EnumSet<ELanguage> languagesToSearchFor) {
        this.languagesToSearchFor = languagesToSearchFor;
    }

    public static EnumSet<ELanguage> scanForClikeLanguagePatterns(String fileContent, EnumSet<ELanguage> languagesToSearchFor) {
        CLikeLanguageDetector detector = new CLikeLanguageDetector(languagesToSearchFor);
        LineSplitter lineSplitter = new LineSplitter(fileContent);
        lineSplitter.setIncludeTrailingEmptyLine(true);
        for (String line : lineSplitter) {
            detector.advanceLine(line);
            if (!detector.detectedLanguagePatterns.equals(languagesToSearchFor)) continue;
            return detector.detectedLanguagePatterns;
        }
        return detector.detectedLanguagePatterns;
    }

    private void advanceLine(String line) {
        this.currentPositionInLine = 0;
        while (this.currentPositionInLine < line.length()) {
            String code = this.advancePositionInLine(line);
            if (code == null || code.isEmpty()) continue;
            if (this.languagesToSearchFor.contains((Object)ELanguage.CPP) && !this.detectedLanguagePatterns.contains((Object)ELanguage.CPP) && CLikeLanguageDetector.isLikelyCppCode(code)) {
                this.detectedLanguagePatterns.add(ELanguage.CPP);
            }
            if (this.languagesToSearchFor.contains((Object)ELanguage.CPP_MS_CLI) && !this.detectedLanguagePatterns.contains((Object)ELanguage.CPP_MS_CLI) && CLikeLanguageDetector.isLikelyCppCode(code)) {
                this.detectedLanguagePatterns.add(ELanguage.CPP_MS_CLI);
            }
            if (!this.languagesToSearchFor.contains((Object)ELanguage.OBJECTIVE_C) || this.detectedLanguagePatterns.contains((Object)ELanguage.OBJECTIVE_C) || !CLikeLanguageDetector.isLikelyObjectiveCCode(code)) continue;
            this.detectedLanguagePatterns.add(ELanguage.OBJECTIVE_C);
        }
    }

    private @Nullable String advancePositionInLine(String line) {
        String code = null;
        if (this.currentlyInMultilineComment) {
            int commentEndIndex = line.indexOf("*/", this.currentPositionInLine);
            if (commentEndIndex != -1) {
                this.currentlyInMultilineComment = false;
                this.currentPositionInLine = commentEndIndex + 2;
            } else {
                this.currentPositionInLine = line.length();
                this.currentlyInMultilineComment = true;
            }
        } else {
            int multilineCommentStartIndex = line.indexOf("/*", this.currentPositionInLine);
            int endOfLineCommentStartIndex = line.indexOf("//", this.currentPositionInLine);
            if (endOfLineCommentStartIndex != -1 && (endOfLineCommentStartIndex < multilineCommentStartIndex || multilineCommentStartIndex == -1)) {
                code = line.substring(this.currentPositionInLine, endOfLineCommentStartIndex);
                this.currentlyInMultilineComment = false;
                this.currentPositionInLine = line.length();
            } else if (multilineCommentStartIndex != -1) {
                code = line.substring(this.currentPositionInLine, multilineCommentStartIndex);
                this.currentlyInMultilineComment = true;
                this.currentPositionInLine = multilineCommentStartIndex + 2;
            } else {
                code = line.substring(this.currentPositionInLine);
                this.currentPositionInLine = line.length();
                this.currentlyInMultilineComment = false;
            }
        }
        return code;
    }

    private static boolean isLikelyCppCode(String lineContent) {
        return CLikeLanguageDetector.containsOneOfKeywords(lineContent, CPP_COMMON_KEYWORDS) || CPP_PATTERN.matcher(lineContent).find();
    }

    private static boolean isLikelyObjectiveCCode(String lineContent) {
        return CLikeLanguageDetector.containsOneOfKeywords(lineContent, OBJECTIVE_C_COMMON_KEYWORDS) || OBJECTIVE_C_COMMON_TYPES_HINT_PATTERN.matcher(lineContent).find();
    }

    private static boolean containsOneOfKeywords(String lineContent, String[] keywords) {
        for (String keyword : keywords) {
            int matchOffset = lineContent.indexOf(keyword);
            while (matchOffset != -1) {
                boolean matchPreceededByIdentifierChar;
                if (!Character.isJavaIdentifierPart(keyword.charAt(0))) {
                    return true;
                }
                boolean bl = matchPreceededByIdentifierChar = matchOffset != 0 && Character.isJavaIdentifierPart(lineContent.charAt(matchOffset - 1));
                if (!matchPreceededByIdentifierChar) {
                    return true;
                }
                matchOffset = lineContent.indexOf(keyword, matchOffset + 1);
            }
        }
        return false;
    }
}

