/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@IndexValueClass
public final class ParentedCommitDescriptor
implements Serializable,
Comparable<ParentedCommitDescriptor> {
    private static final long serialVersionUID = 1L;
    private static final String PARENT_COMMITS_PROPERTY = "parentCommits";
    @JsonUnwrapped
    private final CommitDescriptor commit;
    @JsonProperty(value="parentCommits")
    private final List<CommitDescriptor> parentCommits;

    public ParentedCommitDescriptor(CommitDescriptor commit, List<CommitDescriptor> parentCommits) {
        this.commit = Objects.requireNonNull(commit, "commit");
        this.parentCommits = ParentedCommitDescriptor.checkParents(commit, parentCommits);
    }

    public ParentedCommitDescriptor(CommitDescriptor commitDescriptor, CommitDescriptor ... parentCommits) {
        this(commitDescriptor, List.of(parentCommits));
    }

    @TestOnly
    public ParentedCommitDescriptor(String branch, long timestamp, CommitDescriptor ... parentCommits) {
        this(branch, timestamp, List.of(parentCommits));
    }

    @TestOnly
    public ParentedCommitDescriptor(String branch, long timestamp, List<CommitDescriptor> parentCommits) {
        this(new CommitDescriptor(branch, timestamp), parentCommits);
    }

    private static List<CommitDescriptor> checkParents(CommitDescriptor commit, List<CommitDescriptor> parentCommits) {
        for (CommitDescriptor parent : parentCommits) {
            Preconditions.checkArgument((parent.getTimestamp() < commit.getTimestamp() ? 1 : 0) != 0, (String)"Can't set newer commit (%s) as parent of older commit (%s)", (Object)parent, (Object)commit);
        }
        return List.copyOf(parentCommits);
    }

    @JsonCreator
    static ParentedCommitDescriptor fromJson(@JsonUnwrapped CommitDescriptor commit, @JsonProperty(value="parentCommits") List<CommitDescriptor> parentCommits) {
        return new ParentedCommitDescriptor(commit, parentCommits);
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public UnmodifiableList<CommitDescriptor> getParentCommits() {
        return CollectionUtils.asUnmodifiable(this.parentCommits);
    }

    public String getBranchName() {
        return this.commit.getBranchName();
    }

    public long getTimestamp() {
        return this.commit.getTimestamp();
    }

    public @Nullable CommitDescriptor getFirstParentCommit() {
        if (this.isStartCommit()) {
            return null;
        }
        return (CommitDescriptor)this.getParentCommits().getFirst();
    }

    public UnmodifiableList<CommitDescriptor> getOtherParentCommits() {
        if (this.isStartCommit()) {
            return CollectionUtils.asUnmodifiable(Collections.emptyList());
        }
        UnmodifiableList<CommitDescriptor> parentCommits = this.getParentCommits();
        return parentCommits.subList(1, parentCommits.size());
    }

    public boolean isSimpleCommit() {
        return this.parentCommits.size() == 1 && this.commit.isOnSameBranchAs(this.parentCommits.getFirst());
    }

    public boolean isMergeCommit() {
        return this.getParentCommits().size() > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isForkCommit() {
        if (this.parentCommits.isEmpty()) return false;
        if (!this.parentCommits.stream().noneMatch(this.getCommit()::isOnSameBranchAs)) return false;
        return true;
    }

    public List<CommitDescriptor> getParentCommitsOnOtherBranches() {
        return this.getParentCommits().stream().filter(Predicate.not(this.getCommit()::isOnSameBranchAs)).toList();
    }

    public boolean isStartCommit() {
        return this.getParentCommits().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentedCommitDescriptor)) return false;
        ParentedCommitDescriptor that = (ParentedCommitDescriptor)o;
        if (!Objects.equals(this.commit, that.commit)) return false;
        if (!Objects.equals(this.parentCommits, that.parentCommits)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.commit, this.parentCommits);
    }

    public String toString() {
        return String.valueOf(this.commit) + " parents: " + String.valueOf(this.parentCommits);
    }

    @Override
    public int compareTo(ParentedCommitDescriptor o) {
        int compare;
        block2: {
            Pair parents;
            compare = this.commit.compareTo(o.commit);
            if (compare == 0) {
                compare = Integer.compare(this.parentCommits.size(), o.parentCommits.size());
            }
            if (compare != 0) break block2;
            Iterator iterator = CollectionUtils.zip(this.parentCommits, o.parentCommits).iterator();
            while (iterator.hasNext() && (compare = ((CommitDescriptor)(parents = (Pair)iterator.next()).getFirst()).compareTo((CommitDescriptor)parents.getSecond())) == 0) {
            }
        }
        return compare;
    }
}

